/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Editor;

import com.dacreation.GTTM.Editor.Geometry;
import com.dacreation.GTTM.Model.GPR;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class GPRContour {
    float xf = 10.0f;
    float yf = 1.0f;
    private static double shiftx;
    private static double shifty;
    private static double yZoom;
    private static double xZoom;
    private static double leftMostTime;
    private static double rightMostTime;
    private static GPR.GPRule selectedGPRule;
    private static boolean mustUpdateCurves;
    private static boolean mustUpdateDrawing;
    Vector<Point2D.Double> rawPoints = new Vector();
    private GPR.GPRule ag;

    public GPRContour(GPR.GPRule ag) {
        this.ag = ag;
        mustUpdateDrawing = true;
        mustUpdateCurves = true;
    }

    public void setYZoom(double heipoint) {
        if (yZoom != heipoint) {
            this.invalidateDrawing();
            yZoom = heipoint;
        }
    }

    public void setLeftMostTime(double leftMostTime) {
        if (GPRContour.leftMostTime != leftMostTime) {
            this.invalidateDrawing();
            GPRContour.leftMostTime = leftMostTime;
        }
    }

    public void setXZoom(double mul) {
        if (xZoom != mul) {
            this.invalidateDrawing();
            xZoom = mul;
        }
    }

    public void setRightMostTime(double rightMostTime) {
        if (GPRContour.rightMostTime != rightMostTime) {
            this.invalidateDrawing();
            GPRContour.rightMostTime = rightMostTime;
        }
    }

    public void setSelectedGPRule(GPR.GPRule selectedGPRule) {
        if (GPRContour.selectedGPRule != selectedGPRule) {
            this.invalidateDrawing();
            GPRContour.selectedGPRule = selectedGPRule;
        }
    }

    void setXShift(double shiftx) {
        if (GPRContour.shiftx != shiftx) {
            this.invalidateDrawing();
            GPRContour.shiftx = shiftx;
        }
    }

    void setYShift(double shifty) {
        if (GPRContour.shifty != shifty) {
            this.invalidateDrawing();
            GPRContour.shifty = shifty;
        }
    }

    public void invalidateCurve() {
        mustUpdateCurves = true;
        mustUpdateDrawing = true;
    }

    public void invalidateDrawing() {
        mustUpdateDrawing = true;
    }

    public static boolean isMustUpdateCurves() {
        return mustUpdateCurves;
    }

    public static boolean isMustUpdateDrawing() {
        return mustUpdateDrawing;
    }

    private double convertX(double x) {
        return (x / (double)this.xf - leftMostTime) * xZoom + 14.0 - shiftx;
    }

    private double convertY(double y) {
        return (127.5 - y / (double)this.yf % 1200.0) * yZoom - shifty;
    }

    private double convertW(double w) {
        return w / (double)this.xf * xZoom;
    }

    private double convertH(double h) {
        return h / (double)this.yf * yZoom;
    }

    private Point2D.Double convertP(Point2D.Double p) {
        return new Point2D.Double(this.convertX(p.x), this.convertY(p.y));
    }

    public void drawCurve(Graphics2D g2d, int level) {
        Color linecolor;
        Color color;
        if (this.rawPoints.size() == 0) {
            return;
        }
        Vector<Point2D.Double> points = new Vector<Point2D.Double>();
        for (int i = 0; i < this.rawPoints.size(); ++i) {
            points.add(new Point2D.Double(this.convertX(this.rawPoints.elementAt((int)i).x), this.convertY(this.rawPoints.elementAt((int)i).y)));
        }
        Color co = this.ag.getVoice().getColor();
        if (this.ag.equals(selectedGPRule)) {
            color = new Color(co.getRed(), co.getGreen(), co.getBlue(), 100);
            g2d.setStroke(new BasicStroke(2.0f));
            linecolor = new Color(0, 0, 0);
        } else {
            color = new Color(co.getRed(), co.getGreen(), co.getBlue(), 27);
            g2d.setStroke(new BasicStroke(1.5f));
            linecolor = level % 2 == 0 ? new Color(0.4f, 0.4f, 0.4f) : new Color((float)co.getRed() / 510.0f + 0.25f, (float)co.getGreen() / 510.0f + 0.25f, (float)co.getBlue() / 510.0f + 0.25f);
        }
        GeneralPath ss = new GeneralPath();
        ss = Geometry.drawCurve(g2d, points, linecolor, color);
        this.ag.setGraph(ss);
        for (GPR.GPRule gr : this.ag.getContaindGroups()) {
            gr.contour.drawCurve(g2d, level + 1);
        }
    }

    public void createPoints() {
        Set sa = this.ag.getContaindNotes();
        if (sa.size() > 0) {
            int c;
            int i;
            TreeSet noteListStartOrder = new TreeSet(new StartTimeComparator());
            noteListStartOrder.addAll(sa);
            Vector<Point2D.Double> rightpoints = new Vector<Point2D.Double>();
            Vector<Point2D.Double> leftpoints = new Vector<Point2D.Double>();
            Geometry.Circle lastcircle = null;
            Geometry.Circle firstcircle = null;
            Iterator notes = noteListStartOrder.iterator();
            Note nextnote = (Note)notes.next();
            Note lastnote = null;
            float r = this.ag.getLevel() + 1;
            double circleDistance = r * 6.0f;
            double noteCircleDistance = (double)r * 0.65;
            boolean comeFromAbove = false;
            boolean comeFromBelow = false;
            while (nextnote != null) {
                Note n = nextnote;
                nextnote = notes.hasNext() ? (Note)notes.next() : null;
                float x1 = (float)n.getAbsoluteTime() * this.xf;
                float x2 = (float)(n.getAbsoluteTime() + n.getDuration()) * this.xf;
                float y = (float)n.getNoteNumber() * this.yf;
                int nC = (int)Math.round((double)(x2 - x1) / circleDistance);
                double m1x = (double)x1 + noteCircleDistance;
                double m2x = (double)x2 - noteCircleDistance;
                double d = 0.0;
                if (nC == 0) {
                    if (lastnote == null) {
                        m2x = (double)x2 - noteCircleDistance;
                        m1x = (double)x1 + noteCircleDistance;
                        nC = 1;
                        d = (m2x - m1x) / (double)nC;
                        if (d < 0.0) {
                            m1x = (x1 + x2) / 2.0f;
                            nC = 0;
                        }
                    } else {
                        m1x = nextnote == null ? (double)x2 - noteCircleDistance : (double)((x1 + x2) / 2.0f);
                    }
                } else {
                    d = (m2x - m1x) / (double)nC;
                }
                for (int i2 = 0; i2 <= nC; ++i2) {
                    Geometry.Circle c2;
                    double mx = m1x + d * (double)i2;
                    lastcircle = c2 = new Geometry.Circle(new Point2D.Double(mx, y), r);
                    if (firstcircle == null) {
                        firstcircle = c2;
                    }
                    rightpoints.add(new Point2D.Double(mx, y - r));
                    leftpoints.add(0, new Point2D.Double(mx, y + r));
                    if (comeFromBelow) {
                        rightpoints.add(rightpoints.size() - 1, new Point2D.Double(x1, y - r));
                        leftpoints.remove(0);
                        comeFromBelow = false;
                    }
                    if (!comeFromAbove) continue;
                    rightpoints.remove(rightpoints.size() - 1);
                    leftpoints.add(1, new Point2D.Double(x1, y + r));
                    comeFromAbove = false;
                }
                if (nextnote != null) {
                    double n1x = x2;
                    double n1y = y;
                    double n2x = nextnote.getAbsoluteTime() * (double)this.xf;
                    double n2y = (float)nextnote.getNoteNumber() * this.yf;
                    double dx = n2x - n1x;
                    double dy = n2y - n1y;
                    double d2 = Math.sqrt(dx * dx + dy * dy);
                    if (dy > 0.0) {
                        rightpoints.add(new Point2D.Double(n1x, y - r));
                        leftpoints.remove(0);
                        comeFromAbove = true;
                    }
                    if (dy < 0.0) {
                        rightpoints.remove(rightpoints.size() - 1);
                        leftpoints.add(0, new Point2D.Double(n1x, y + r));
                        comeFromBelow = true;
                    }
                    if (d2 > (double)(r * 2.0f)) {
                        int nC2 = (int)Math.round(d2 / circleDistance);
                        double dx1 = dx / (double)nC2;
                        double dy1 = dy / (double)nC2;
                        for (int i3 = 1; i3 < nC2; ++i3) {
                            Geometry.Circle c3;
                            double uy;
                            double rr = (double)r * (0.5 + (1.0 + Math.cos((double)i3 / (double)nC2 * 2.0 * Math.PI)) / 4.0);
                            double ux = dx / d2 * rr;
                            double upx = uy = dy / d2 * rr;
                            double upy = -ux;
                            double downx = -uy;
                            double downy = ux;
                            double mx = n1x + dx1 * (double)i3;
                            double my = n1y + dy1 * (double)i3;
                            lastcircle = c3 = new Geometry.Circle(new Point2D.Double(mx, my), r);
                            if (firstcircle == null) {
                                firstcircle = c3;
                            }
                            rightpoints.add(new Point2D.Double(mx + upx, my + upy));
                            leftpoints.add(0, new Point2D.Double(mx + downx, my + downy));
                        }
                    }
                }
                lastnote = n;
            }
            double xx = lastcircle.M.x + (double)r * 0.77;
            rightpoints.add(new Point2D.Double(xx, lastcircle.M.y - (double)r * 0.77));
            leftpoints.add(0, new Point2D.Double(xx, lastcircle.M.y + (double)r * 0.77));
            xx = firstcircle.M.x - (double)r * 0.77;
            rightpoints.add(0, new Point2D.Double(xx, firstcircle.M.y - (double)r * 0.77));
            leftpoints.add(new Point2D.Double(xx, firstcircle.M.y + (double)r * 0.77));
            for (i = 1; i < rightpoints.size(); ++i) {
                double d = Geometry.getVectorLength(Geometry.getVector((Point2D.Double)rightpoints.elementAt(i), (Point2D.Double)rightpoints.elementAt(i - 1)));
                if (!(d < 1.0)) continue;
                ((Point2D.Double)rightpoints.elementAt((int)(i - 1))).x = (((Point2D.Double)rightpoints.elementAt((int)(i - 1))).x + ((Point2D.Double)rightpoints.elementAt((int)i)).x) / 2.0;
                ((Point2D.Double)rightpoints.elementAt((int)(i - 1))).y = (((Point2D.Double)rightpoints.elementAt((int)(i - 1))).y + ((Point2D.Double)rightpoints.elementAt((int)i)).y) / 2.0;
                rightpoints.removeElementAt(i);
                --i;
            }
            for (i = 1; i < leftpoints.size(); ++i) {
                double d = Geometry.getVectorLength(Geometry.getVector((Point2D.Double)leftpoints.elementAt(i), (Point2D.Double)leftpoints.elementAt(i - 1)));
                if (!(d < 1.0)) continue;
                ((Point2D.Double)leftpoints.elementAt((int)(i - 1))).x = (((Point2D.Double)leftpoints.elementAt((int)(i - 1))).x + ((Point2D.Double)leftpoints.elementAt((int)i)).x) / 2.0;
                ((Point2D.Double)leftpoints.elementAt((int)(i - 1))).y = (((Point2D.Double)leftpoints.elementAt((int)(i - 1))).y + ((Point2D.Double)leftpoints.elementAt((int)i)).y) / 2.0;
                leftpoints.removeElementAt(i);
                --i;
            }
            this.rawPoints = new Vector();
            Vector<Point2D.Double> tpoints = new Vector<Point2D.Double>();
            Vector<Point2D.Double> combined_points = new Vector<Point2D.Double>();
            for (int i4 = 0; i4 < rightpoints.size(); ++i4) {
                tpoints.add((Point2D.Double)((Point2D.Double)rightpoints.get(i4)).clone());
            }
            int iterations = (1 + this.ag.getLevel()) * 2;
            for (c = 1; c < iterations; ++c) {
                Vector<Point2D.Double> filteredpoints = new Vector<Point2D.Double>();
                filteredpoints.add((Point2D.Double)((Point2D.Double)tpoints.get(0)).clone());
                for (int i5 = 1; i5 < tpoints.size() - 1; ++i5) {
                    Point2D.Double p0 = (Point2D.Double)tpoints.get(i5);
                    Point2D.Double pb = (Point2D.Double)tpoints.get(i5 - 1);
                    Point2D.Double pa = (Point2D.Double)tpoints.get(i5 + 1);
                    Double px = p0.x;
                    Double py = p0.y;
                    if (pb.y <= py && pa.y <= py) {
                        px = (pa.x + pb.x) / 2.0;
                        py = (pa.y + pb.y) / 2.0;
                    }
                    filteredpoints.add(new Point2D.Double(px, py));
                }
                filteredpoints.add((Point2D.Double)((Point2D.Double)tpoints.get(tpoints.size() - 1)).clone());
                tpoints = filteredpoints;
            }
            combined_points.addAll(tpoints);
            tpoints = new Vector();
            for (int i6 = 0; i6 < leftpoints.size(); ++i6) {
                tpoints.add((Point2D.Double)((Point2D.Double)leftpoints.get(i6)).clone());
            }
            for (c = 1; c < iterations; ++c) {
                Vector<Point2D.Double> filteredpoints = new Vector<Point2D.Double>();
                filteredpoints.add((Point2D.Double)((Point2D.Double)tpoints.get(0)).clone());
                for (int i7 = 1; i7 < tpoints.size() - 1; ++i7) {
                    Point2D.Double p0 = (Point2D.Double)tpoints.get(i7);
                    Point2D.Double pb = (Point2D.Double)tpoints.get(i7 - 1);
                    Point2D.Double pa = (Point2D.Double)tpoints.get(i7 + 1);
                    Double px = p0.x;
                    Double py = p0.y;
                    if (pb.y >= py && pa.y >= py) {
                        px = (pa.x + pb.x) / 2.0;
                        py = (pa.y + pb.y) / 2.0;
                    }
                    filteredpoints.add(new Point2D.Double(px, py));
                }
                filteredpoints.add((Point2D.Double)((Point2D.Double)tpoints.get(tpoints.size() - 1)).clone());
                tpoints = filteredpoints;
            }
            combined_points.addAll(tpoints);
            this.rawPoints = combined_points;
        }
        for (GPR.GPRule gr : this.ag.getContaindGroups()) {
            gr.contour.createPoints();
        }
    }

    void updateDone() {
        mustUpdateCurves = false;
        mustUpdateDrawing = false;
    }
}

