/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Editor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Geometry {
    private Geometry() {
    }

    public static Point2D.Double getVector(Point2D.Double from, Point2D.Double to) {
        return new Point2D.Double(to.x - from.x, to.y - from.y);
    }

    public static double getVectorLength(Point2D.Double v) {
        return Math.sqrt(v.x * v.x + v.y * v.y);
    }

    public static Point2D.Double getVector(Point2D.Double from, Point2D.Double to, boolean unity) {
        double length;
        Point2D.Double v = Geometry.getVector(from, to);
        if (unity && (length = Math.sqrt(v.x * v.x + v.y * v.y)) > 0.0) {
            v.x /= length;
            v.y /= length;
        }
        return v;
    }

    public static GeneralPath drawCurve(Graphics2D g2d, Vector<Point2D.Double> points, Color linecolor, Color fillcolor) {
        boolean useUnitVectors = true;
        GeneralPath ss = new GeneralPath();
        ss.moveTo(points.elementAt((int)0).x, points.elementAt((int)0).y);
        Point2D.Double x1 = points.elementAt(points.size() - 1);
        Point2D.Double p1 = points.elementAt(0);
        for (int i = 1; i <= points.size(); ++i) {
            double c;
            Point2D.Double p4 = points.elementAt(i % points.size());
            Point2D.Double x2 = (Point2D.Double)points.elementAt((i + 1) % points.size()).clone();
            double curvature = 0.43;
            double d = Geometry.getVectorLength(Geometry.getVector(p1, p4));
            double c2 = c = curvature * d;
            Point2D.Double x1p4 = Geometry.getVector(x1, p4, useUnitVectors);
            Point2D.Double x2p1 = Geometry.getVector(x2, p1, useUnitVectors);
            if (x1.y == p1.y) {
                x1p4.y = 0.0;
            }
            if (p1.y == p4.y) {
                x1p4.y = 0.0;
                x2p1.y = 0.0;
            }
            if (p4.y == x2.y) {
                x2p1.y = 0.0;
            }
            Point2D.Double p2 = new Point2D.Double();
            Point2D.Double p3 = new Point2D.Double();
            p2.x = p1.x + x1p4.x * c2;
            p2.y = p1.y + x1p4.y * c2;
            p3.x = p4.x + x2p1.x * c2;
            p3.y = p4.y + x2p1.y * c2;
            g2d.setColor(new Color(1.0f, 0.1f, 0.51f));
            g2d.setColor(new Color(0.1f, 0.1f, 0.51f));
            ss.curveTo(p2.x, p2.y, p3.x, p3.y, p4.x, p4.y);
            g2d.setColor(new Color(0.1f, 0.1f, 0.51f));
            x1 = p1;
            p1 = p4;
        }
        g2d.setPaint(fillcolor);
        g2d.fill(ss);
        g2d.setColor(linecolor);
        g2d.draw(ss);
        return ss;
    }

    public static Vector<Point2D.Double> getCommonTangents(Circle circle1, Circle circle2) {
        Point2D.Double M1ht2;
        Point2D.Double M1ht1;
        Circle c2;
        Circle c1;
        if (circle1.r != circle2.r) {
            if (circle1.r > circle2.r) {
                c1 = circle1;
                c2 = circle2;
            } else {
                c2 = circle1;
                c1 = circle2;
            }
            Circle h1 = new Circle(c1.M, c1.r - c2.r);
            Vector<Point2D.Double> t = h1.getTangentPoints(c2.M);
            M1ht1 = Geometry.getVector(c1.M, t.elementAt(0), true);
            M1ht2 = Geometry.getVector(c1.M, t.elementAt(1), true);
        } else {
            c1 = circle1;
            c2 = circle2;
            M1ht1 = Geometry.getVector(c1.M, c2.M, true);
            double x = M1ht1.x;
            M1ht1.x = M1ht1.y;
            M1ht1.y = -x;
            M1ht2 = new Point2D.Double();
            M1ht2.x = -M1ht1.x;
            M1ht2.y = -M1ht1.y;
        }
        Point2D.Double T1p1 = new Point2D.Double();
        Point2D.Double T2p1 = new Point2D.Double();
        T1p1.x = c1.M.x + M1ht1.x * c1.r;
        T1p1.y = c1.M.y + M1ht1.y * c1.r;
        T2p1.x = c1.M.x + M1ht2.x * c1.r;
        T2p1.y = c1.M.y + M1ht2.y * c1.r;
        Point2D.Double T1p2 = new Point2D.Double();
        Point2D.Double T2p2 = new Point2D.Double();
        T1p2.x = c2.M.x + M1ht1.x * c2.r;
        T1p2.y = c2.M.y + M1ht1.y * c2.r;
        T2p2.x = c2.M.x + M1ht2.x * c2.r;
        T2p2.y = c2.M.y + M1ht2.y * c2.r;
        Vector<Point2D.Double> p = new Vector<Point2D.Double>();
        p.add(T1p1);
        p.add(T1p2);
        p.add(T2p1);
        p.add(T2p2);
        return p;
    }

    public static boolean equalPoints(Point2D.Double p1, Point2D.Double p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }

    public static Point2D.Double intersection(Line2D.Double l1, Line2D.Double l2) {
        if (l1.intersectsLine(l2)) {
            if (Geometry.equalPoints((Point2D.Double)l1.getP1(), (Point2D.Double)l2.getP1())) {
                return null;
            }
            if (Geometry.equalPoints((Point2D.Double)l1.getP2(), (Point2D.Double)l2.getP1())) {
                return null;
            }
            if (Geometry.equalPoints((Point2D.Double)l1.getP1(), (Point2D.Double)l2.getP2())) {
                return null;
            }
            if (Geometry.equalPoints((Point2D.Double)l1.getP2(), (Point2D.Double)l2.getP2())) {
                return null;
            }
            double d = (l1.x1 - l1.x2) * (l2.y1 - l2.y2) - (l1.y1 - l1.y2) * (l2.x1 - l2.x2);
            if (d == 0.0) {
                return null;
            }
            double xi = ((l2.x1 - l2.x2) * (l1.x1 * l1.y2 - l1.y1 * l1.x2) - (l1.x1 - l1.x2) * (l2.x1 * l2.y2 - l2.y1 * l2.x2)) / d;
            double yi = ((l2.y1 - l2.y2) * (l1.x1 * l1.y2 - l1.y1 * l1.x2) - (l1.y1 - l1.y2) * (l2.x1 * l2.y2 - l2.y1 * l2.x2)) / d;
            return new Point2D.Double(xi, yi);
        }
        return null;
    }

    public static class Circle {
        Point2D.Double M;
        double r;

        Circle(Point2D.Double M, double r) {
            this.M = (Point2D.Double)M.clone();
            this.r = r;
        }

        public Vector<Point2D.Double> intersectWithCircle(Circle circle2) {
            double x1 = this.M.x;
            double y1 = this.M.y;
            double r1 = this.r;
            double x2 = circle2.M.x;
            double y2 = circle2.M.y;
            double r2 = circle2.r;
            double resultX1 = 0.0;
            double resultX2 = 0.0;
            double resultY1 = 0.0;
            double resultY2 = 0.0;
            if (y1 == y2 && x2 != x1) {
                resultX2 = resultX1 = x1 + (r1 * r1 - r2 * r2 + x2 * x2 + x1 * x1 - 2.0 * x1 * x2) / (2.0 * x2 - 2.0 * x1);
                double p1 = y1 * y1 - r1 * r1 + resultX1 * resultX1 - 2.0 * x1 * resultX1 + x1 * x1;
                resultY1 = y1 + Math.sqrt(y1 * y1 - p1);
                resultY2 = y1 - Math.sqrt(y1 * y1 - p1);
            } else if (x2 == x1 && y2 != y1) {
                resultY2 = resultY1 = y2 + (r1 * r1 - r2 * r2 + y2 * y2 + y2 * y2 - 2.0 * y2 * y2) / (2.0 * y2 - 2.0 * y2);
                double q1 = x1 * x1 + resultY1 * resultY1 - 2.0 * y1 * resultY1 + y1 * y1 - r1 * r1;
                resultX1 = x1 + Math.sqrt(x1 * x1 - q1);
                resultX2 = x1 - Math.sqrt(x1 * x1 - q1);
            } else if (x2 != x1 || y2 != y1) {
                double c1 = (Math.pow(r1, 2.0) - Math.pow(r2, 2.0) - Math.pow(x1, 2.0) + Math.pow(x2, 2.0) - Math.pow(y1, 2.0) + Math.pow(y2, 2.0)) / (2.0 * x2 - 2.0 * x1);
                double c2 = (y1 - y2) / (x2 - x1);
                double k1 = 1.0 + 1.0 / Math.pow(c2, 2.0);
                double k2 = 2.0 * x1 + 2.0 * y1 / c2 + 2.0 * c1 / Math.pow(c2, 2.0);
                double k3 = Math.pow(x1, 2.0) + Math.pow(c1, 2.0) / Math.pow(c2, 2.0) + 2.0 * y1 * c1 / c2 + Math.pow(y1, 2.0) - Math.pow(r1, 2.0);
                resultX1 = k2 / k1 / 2.0 + Math.sqrt(Math.pow(k2 / k1, 2.0) / 4.0 - k3 / k1);
                resultX2 = k2 / k1 / 2.0 - Math.sqrt(Math.pow(k2 / k1, 2.0) / 4.0 - k3 / k1);
                resultY1 = 1.0 / c2 * resultX1 - c1 / c2;
                resultY2 = 1.0 / c2 * resultX2 - c1 / c2;
            }
            Vector<Point2D.Double> intersections = new Vector<Point2D.Double>();
            intersections.add(new Point2D.Double(resultX1, resultY1));
            intersections.add(new Point2D.Double(resultX2, resultY2));
            return intersections;
        }

        public Vector<Point2D.Double> getTangentPoints(Point2D.Double P) {
            Point2D.Double TM = new Point2D.Double((P.x + this.M.x) / 2.0, (P.y + this.M.y) / 2.0);
            double tr = Math.sqrt(Math.pow(P.x - this.M.x, 2.0) + Math.pow(P.y - this.M.y, 2.0)) / 2.0;
            return this.intersectWithCircle(new Circle(TM, tr));
        }
    }
}

