/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Editor;

import com.dacreation.GTTM.Model.MusicXML.EndTimeComparator;
import com.dacreation.GTTM.Model.MusicXML.Measure;
import com.dacreation.GTTM.Model.MusicXML.MusicXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.NotePlayer;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.gttmeditor.Voices;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JPanel;

public class NotePanel
extends JPanel {
    public static final int DRAG_NOTHING = 0;
    public static final int DRAG_SELECTION_BOX = 1;
    public static final int DRAG_TIME_SPAN_TREE_NODE = 2;
    public Profile parent;
    BufferedImage backGround;
    BufferedImage noteBackGround;
    TreeSet noteListInRangeNoteOrder = new TreeSet();
    TreeSet noteListInRangeStartOrder = new TreeSet(new StartTimeComparator());
    TreeSet noteListInRangeEndOrder = new TreeSet(new EndTimeComparator());
    double leftMostTime;
    double rightMostTime;
    double selectionStartX;
    int selectionStartY;
    double selectionNowX;
    int selectionNowY;
    Set selectedSet = new HashSet();
    Set measureSetInRange = new HashSet();
    public int dragStatus = 0;
    boolean popupTrigger = false;
    public NotePlayer aNotePlayer = new NotePlayer();
    boolean autoPlay = false;

    protected void finalize() throws Throwable {
        if (this.backGround != null) {
            this.backGround.flush();
        }
        if (this.noteBackGround != null) {
            this.noteBackGround.flush();
        }
        if (this.aNotePlayer != null) {
            this.aNotePlayer.stop();
        }
        this.backGround = null;
        this.noteBackGround = null;
        this.noteListInRangeNoteOrder = null;
        this.noteListInRangeStartOrder = null;
        this.noteListInRangeEndOrder = null;
        this.selectedSet = null;
        this.measureSetInRange = null;
        this.aNotePlayer = null;
        super.finalize();
    }

    public void setAutoPlay(boolean ab) {
        this.autoPlay = ab;
    }

    public void playSelectedNotes() {
        this.aNotePlayer.playNoteSet(this.selectedSet);
    }

    public void playVisibleNotes() {
        MusicXML aScore = this.parent.getMXML().getContent();
        if (aScore != null) {
            Set aSet = aScore.getNotesInRange(this.leftMostTime, this.rightMostTime);
            ArrayList<Object> aaSet = new ArrayList<Object>();
            Iterator i = aSet.iterator();
            String lastId = null;
            Double lastDuration = 0.0;
            TreeMap<Double, Object> tempTie = new TreeMap<Double, Object>();
            TreeMap<String, Double> sortTie = new TreeMap<String, Double>();
            while (i.hasNext()) {
                Object temp = new Note();
                Note j = (Note)i.next();
                ((Note)temp).setAbsoluteTime(j.getAbsoluteTime());
                ((Note)temp).setAlter(j.getAlter());
                ((Note)temp).setAt(j.getAt());
                ((Note)temp).setDuration(j.getDuration());
                ((Note)temp).setIdName(j.getIdName());
                ((Note)temp).setOctave_base(j.getOctave_base());
                ((Note)temp).setOctave_width(j.getOctave_width());
                ((Note)temp).setParent(j.getParent());
                ((Note)temp).setRoot(j.getRoot());
                ((Note)temp).setStep(j.getStep());
                ((Note)temp).setVelocity(j.getVelocity());
                ((Note)temp).setVoice(j.getVoice());
                ((Note)temp).setTie(j.getTie());
                String temp2 = ((Note)temp).getTie();
                if (temp2 != null) {
                    if (temp2.equals("stop")) {
                        tempTie.put(((Note)temp).getAbsoluteTime(), temp);
                        continue;
                    }
                    lastId = ((Note)temp).getIdName();
                    tempTie.put(((Note)temp).getAbsoluteTime(), temp);
                    aaSet.add(temp);
                    continue;
                }
                aaSet.add(temp);
            }
            for (Double key : tempTie.keySet()) {
                Note temp = (Note)tempTie.get(key);
                if (temp.getTie() == null) continue;
                if (temp.getTie().equals("start")) {
                    lastDuration = temp.getDuration();
                    lastId = temp.getIdName();
                    continue;
                }
                sortTie.put(lastId, lastDuration + temp.getDuration());
            }
            for (Object temp : aaSet) {
                String temp2 = ((Note)temp).getTie();
                if (temp2 == null || !temp2.equals("start")) continue;
                for (String key : sortTie.keySet()) {
                    Double duration = (Double)sortTie.get(key);
                    if (!((Note)temp).getIdName().equals(key)) continue;
                    ((Note)temp).setDuration(duration);
                }
            }
            HashSet s = new HashSet(aaSet);
            this.aNotePlayer.playNoteSet(s);
        }
    }

    private void initializePane() {
        this.backGround = this.getGraphicsConfiguration().createCompatibleImage(1, 512);
        Graphics2D g2d = this.backGround.createGraphics();
        Color sep = new Color(0.6f, 0.6f, 0.64f);
        Rectangle2D.Double ard = new Rectangle2D.Double();
        Line2D.Double lrd = new Line2D.Double();
        for (int cc = 0; cc < 128; ++cc) {
            Color kokken;
            Color hakken;
            if (cc % 24 < 12) {
                hakken = new Color(0.84f, 0.84f, 0.89f);
                kokken = new Color(0.7f, 0.7f, 0.8f);
            } else {
                hakken = new Color(0.95f, 0.95f, 1.0f);
                kokken = new Color(0.82f, 0.82f, 0.85f);
            }
            if (cc % 12 == 0 || cc % 12 == 2 || cc % 12 == 4 || cc % 12 == 5 || cc % 12 == 7 || cc % 12 == 9 || cc % 12 == 11) {
                g2d.setColor(hakken);
            } else {
                g2d.setColor(kokken);
            }
            ((Rectangle2D)ard).setRect(0.0, 512 - (cc + 1) * 4, 1.0, 4.0);
            g2d.fill(ard);
            g2d.setColor(sep);
            ((Line2D)lrd).setLine(0.0, 512 - (cc + 1) * 4, 1.0, 512 - (cc + 1) * 4);
            g2d.draw(lrd);
        }
    }

    public NotePanel(Profile pm) {
        this.parent = pm;
        this.initComponents();
    }

    public NotePanel(NotePanel source, Profile pm) {
        this.parent = pm;
        this.initComponents();
        this.noteListInRangeNoteOrder.addAll(new HashSet(source.noteListInRangeNoteOrder));
        this.noteListInRangeStartOrder.addAll(new HashSet(source.noteListInRangeStartOrder));
        this.noteListInRangeEndOrder.addAll(new HashSet(source.noteListInRangeEndOrder));
        this.leftMostTime = source.leftMostTime;
        this.rightMostTime = source.rightMostTime;
        this.selectionStartX = source.selectionStartX;
        this.selectionStartY = source.selectionStartY;
        this.selectionNowX = source.selectionNowX;
        this.selectionNowY = source.selectionNowY;
        this.selectedSet.add(source.selectedSet);
        this.measureSetInRange.addAll(source.measureSetInRange);
        this.dragStatus = source.dragStatus;
        this.popupTrigger = source.popupTrigger;
        this.autoPlay = source.autoPlay;
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(200, 200));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                NotePanel.this.formComponentResized(evt);
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
                NotePanel.this.formComponentMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                NotePanel.this.formMouseDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NotePanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                NotePanel.this.formMouseReleased(evt);
            }
        });
    }

    private void formComponentResized(ComponentEvent evt) {
        this.formComponentResizedGT(evt);
    }

    protected void formComponentResizedGT(ComponentEvent evt) {
        if (this.noteBackGround == null) {
            return;
        }
        if (this.getWidth() == this.noteBackGround.getWidth() + 14) {
            return;
        }
        this.makeBackGround();
    }

    private void formMouseDragged(MouseEvent evt) {
        this.formMouseDraggedGT(evt);
    }

    protected void formMouseDraggedGT(MouseEvent evt) {
        int X = evt.getX();
        int Y = evt.getY();
        if (X < 0) {
            X = 0;
        } else if (X > this.getWidth()) {
            X = this.getWidth();
        }
        if (Y < 0) {
            Y = 0;
        } else if (Y > this.getHeight()) {
            Y = this.getHeight();
        }
        if (!this.getVisibleRect().contains(X, Y)) {
            this.scrollRectToVisible(new Rectangle(X, Y, 1, 1));
        }
        if (this.dragStatus == 1) {
            X = X < 14 ? 0 : X - 14;
            this.selectionNowX = (double)X / ((double)this.getWidth() - 14.0) * (this.rightMostTime - this.leftMostTime) + this.leftMostTime;
            this.selectionNowY = (int)((1.0 - (double)Y / (double)this.getHeight()) * 128.0);
            this.repaint();
            return;
        }
    }

    private void formMouseReleased(MouseEvent evt) {
        this.formMouseReleasedGT(evt);
    }

    protected void formMouseReleasedGT(MouseEvent evt) {
        if (!this.popupTrigger) {
            this.popupTrigger = evt.isMetaDown();
        }
        if (this.dragStatus == 1) {
            int topn;
            int btmn;
            double edp;
            double stp;
            if (this.selectionNowX > this.selectionStartX) {
                stp = this.selectionStartX;
                edp = this.selectionNowX;
            } else {
                edp = this.selectionStartX;
                stp = this.selectionNowX;
            }
            if (this.selectionNowY > this.selectionStartY) {
                btmn = this.selectionStartY;
                topn = this.selectionNowY + 1;
            } else {
                topn = this.selectionStartY + 1;
                btmn = this.selectionNowY;
            }
            Note n1 = new Note();
            Note n2 = new Note();
            n1.setAbsoluteTime(stp);
            n1.setByNoteNumber(btmn);
            n2.setAbsoluteTime(edp);
            n2.setByNoteNumber(topn);
            HashSet<Note> aSet = new HashSet<Note>(this.noteListInRangeNoteOrder.subSet(n1, n2));
            aSet.removeAll(new HashSet<Note>(this.noteListInRangeStartOrder.tailSet(n2)));
            aSet.removeAll(new HashSet<Note>(this.noteListInRangeEndOrder.headSet(n1)));
            if (evt.isShiftDown()) {
                HashSet<Note> bSet = new HashSet<Note>(aSet);
                bSet.retainAll(this.selectedSet);
                this.selectedSet.addAll(aSet);
                this.selectedSet.removeAll(bSet);
            } else {
                this.selectedSet = aSet;
            }
            if (this.autoPlay) {
                this.aNotePlayer.playNoteSet(this.selectedSet);
            }
            this.makeBackGround();
            this.repaint();
            if (!this.popupTrigger) {
                this.dragStatus = 0;
            }
        }
    }

    private void formMousePressed(MouseEvent evt) {
        this.formMousePressedGT(evt);
    }

    private void formComponentMoved(ComponentEvent evt) {
        this.repaint();
    }

    protected void formMousePressedGT(MouseEvent evt) {
        int X = evt.getX();
        int Y = evt.getY();
        if (this.dragStatus == 4 || this.dragStatus == 5) {
            return;
        }
        this.popupTrigger = evt.isMetaDown();
        this.aNotePlayer.stop();
        X = X < 14 ? 0 : X - 14;
        this.selectionStartX = this.selectionNowX = (double)X / ((double)this.getWidth() - 14.0) * (this.rightMostTime - this.leftMostTime) + this.leftMostTime;
        this.selectionStartY = this.selectionNowY = (int)((1.0 - (double)Y / (double)this.getHeight()) * 128.0);
        this.dragStatus = 1;
    }

    public synchronized void setDisplayRange(double startAbsTime, double endAbsTime) {
        this.leftMostTime = startAbsTime;
        this.rightMostTime = endAbsTime;
    }

    public void selectNotes() {
        MusicXML aScore;
        this.noteListInRangeNoteOrder.clear();
        this.noteListInRangeStartOrder.clear();
        this.noteListInRangeEndOrder.clear();
        this.measureSetInRange.clear();
        if (this.parent.getMXML() != null && (aScore = this.parent.getMXML().getContent()) != null) {
            Set aSet = aScore.getNotesInRange(this.leftMostTime, this.rightMostTime);
            ArrayList<Object> aaSet = new ArrayList<Object>();
            Iterator i = aSet.iterator();
            String lastId = null;
            Double lastDuration = 0.0;
            TreeMap<Double, Object> tempTie = new TreeMap<Double, Object>();
            TreeMap<String, Double> sortTie = new TreeMap<String, Double>();
            while (i.hasNext()) {
                Object temp = new Note();
                Note j = (Note)i.next();
                ((Note)temp).setAbsoluteTime(j.getAbsoluteTime());
                ((Note)temp).setAlter(j.getAlter());
                ((Note)temp).setAt(j.getAt());
                ((Note)temp).setDuration(j.getDuration());
                ((Note)temp).setIdName(j.getIdName());
                ((Note)temp).setOctave_base(j.getOctave_base());
                ((Note)temp).setOctave_width(j.getOctave_width());
                ((Note)temp).setParent(j.getParent());
                ((Note)temp).setRoot(j.getRoot());
                ((Note)temp).setStep(j.getStep());
                ((Note)temp).setVelocity(j.getVelocity());
                ((Note)temp).setVoice(j.getVoice());
                ((Note)temp).setTie(j.getTie());
                String temp2 = ((Note)temp).getTie();
                if (temp2 != null) {
                    if (temp2.equals("stop")) {
                        tempTie.put(((Note)temp).getAbsoluteTime(), temp);
                        continue;
                    }
                    lastId = ((Note)temp).getIdName();
                    tempTie.put(((Note)temp).getAbsoluteTime(), temp);
                    aaSet.add(temp);
                    continue;
                }
                aaSet.add(temp);
            }
            for (Double key : tempTie.keySet()) {
                Note temp = (Note)tempTie.get(key);
                if (temp.getTie() == null) continue;
                if (temp.getTie().equals("start")) {
                    lastDuration = temp.getDuration();
                    lastId = temp.getIdName();
                    continue;
                }
                sortTie.put(lastId, lastDuration + temp.getDuration());
            }
            for (Object temp : aaSet) {
                Iterator noteIterator = this.selectedSet.iterator();
                Voices.Voice v = this.parent.getVoices().getEditVoice();
                while (noteIterator.hasNext()) {
                    Note aNote = (Note)noteIterator.next();
                    if (((Note)temp).getIdName() != aNote.getIdName()) continue;
                    ((Note)temp).setVoice(v);
                }
                String temp2 = ((Note)temp).getTie();
                if (temp2 == null || !temp2.equals("start")) continue;
                for (String key : sortTie.keySet()) {
                    Double duration = (Double)sortTie.get(key);
                    if (!((Note)temp).getIdName().equals(key)) continue;
                    ((Note)temp).setDuration(duration);
                }
            }
            this.noteListInRangeNoteOrder.addAll(aaSet);
            this.noteListInRangeStartOrder.addAll(aaSet);
            this.noteListInRangeEndOrder.addAll(aaSet);
            this.measureSetInRange.addAll(aScore.getMeasuresInRange(this.leftMostTime, this.rightMostTime));
        }
    }

    public void makeBackGround() {
        this.selectNotes();
        int gw = this.getWidth() - 14;
        if (gw < 1) {
            gw = 1;
        }
        if (this.noteBackGround != null) {
            this.noteBackGround.flush();
        }
        this.noteBackGround = this.getGraphicsConfiguration().createCompatibleImage(gw, 256);
        Graphics2D g2d = this.noteBackGround.createGraphics();
        if (this.backGround == null) {
            this.initializePane();
        }
        g2d.drawImage(this.backGround, 0, 0, gw, 256, null);
        double mulpoint = (double)gw / (this.rightMostTime - this.leftMostTime);
        Iterator amm = this.measureSetInRange.iterator();
        Line2D.Double all = new Line2D.Double();
        while (amm.hasNext()) {
            Measure aMeasure = (Measure)amm.next();
            g2d.setColor(new Color(0.4f, 0.55f, 0.55f));
            double abt = (aMeasure.getAbsoluteTime() - this.leftMostTime) * mulpoint;
            ((Line2D)all).setLine(abt, 0.0, abt, 512.0);
            g2d.draw(all);
        }
        g2d.dispose();
        this.repaint();
    }

    public synchronized void paintNotes(Graphics2D g2d, double mulpoint, double heipoint) {
        Color sel1 = new Color(0.82f, 0.72f, 0.37f);
        Color sel2 = new Color(0.52f, 0.52f, 0.1f);
        Color el1 = new Color(0.57f, 0.47f, 0.53f);
        Color el2 = new Color(0.17f, 0.17f, 0.16f);
        Color lf1 = new Color(0.1f, 0.52f, 0.59f);
        Color lf2 = new Color(0.72f, 0.32f, 0.32f);
        Color slf1 = new Color(1.0f, 0.72f, 0.47f);
        Color slf2 = new Color(0.82f, 0.52f, 0.2f);
        Rectangle2D.Float ara = new Rectangle2D.Float();
        for (Note aNote : this.noteListInRangeNoteOrder) {
            Color c2;
            Color c1;
            if (!aNote.getVoice().isShow()) continue;
            float xxxx = (float)((aNote.getAbsoluteTime() - this.leftMostTime) * mulpoint) + 14.0f;
            float yyyy = (float)((double)(127 - aNote.getNoteNumber() % 1200) * heipoint);
            float wwww = (float)(aNote.getDuration() * mulpoint);
            float hhhh = (float)(1.0 * heipoint);
            if (this.parent.getMXML().anyToElement.get(aNote.getIdName()) != null) {
                if (this.selectedSet.contains(aNote)) {
                    c1 = sel2;
                    c2 = sel1;
                } else {
                    c1 = el2;
                    c2 = el1;
                }
            } else if (this.selectedSet.contains(aNote)) {
                c1 = slf2;
                c2 = slf1;
            } else {
                c1 = lf2;
                c2 = lf1;
            }
            if (this.parent.getVoices().optionColorNotes()) {
                c1 = this.selectedSet.contains(aNote) ? aNote.getVoice().getSelectedNoteColor() : aNote.getVoice().getNoteColor();
            }
            GradientPaint gp = new GradientPaint(xxxx, yyyy, c1, xxxx + wwww, yyyy + hhhh, c2);
            g2d.setPaint(gp);
            ((Rectangle2D)ara).setRect(xxxx, yyyy, wwww, hhhh);
            g2d.fill(ara);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        double heipoint = (double)this.getHeight() / 128.0;
        float ghh = (float)heipoint;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(0, 0, 0));
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.noteBackGround == null) {
            this.makeBackGround();
        }
        g2d.drawImage(this.noteBackGround, 14, 0, this.getWidth() - 14, this.getHeight(), null);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setColor(new Color(0.42f, 0.42f, 0.61f));
        g2d.setFont(new Font("Dialog", 1, 10));
        g2d.drawString("C8-", 0.0f, ghh * 20.0f);
        g2d.drawString("C7-", 0.0f, ghh * 32.0f);
        g2d.drawString("C6-", 0.0f, ghh * 44.0f);
        g2d.drawString("C5-", 0.0f, ghh * 56.0f);
        g2d.drawString("C4-", 0.0f, ghh * 68.0f);
        g2d.drawString("C3-", 0.0f, ghh * 80.0f);
        g2d.drawString("C2-", 0.0f, ghh * 92.0f);
        g2d.drawString("C1-", 0.0f, ghh * 104.0f);
        g2d.drawString("C0-", 0.0f, ghh * 116.0f);
        double mulpoint = ((double)this.getWidth() - 14.0) / (this.rightMostTime - this.leftMostTime);
        if (this.dragStatus == 1) {
            AlphaComposite composite = AlphaComposite.getInstance(3, 0.5f);
            g2d.setComposite(composite);
            g2d.setColor(new Color(0.52f, 0.52f, 0.81f));
            boolean abx = this.selectionNowX > this.selectionStartX;
            boolean aby = this.selectionNowY > this.selectionStartY;
            double xx = abx ? this.selectionStartX : this.selectionNowX;
            double ww = abx ? this.selectionNowX - this.selectionStartX : this.selectionStartX - this.selectionNowX;
            int yy = aby ? this.selectionNowY : this.selectionStartY;
            int hh = aby ? this.selectionNowY - this.selectionStartY : this.selectionStartY - this.selectionNowY;
            Rectangle2D.Double aRec = new Rectangle2D.Double((xx - this.leftMostTime) * mulpoint + 14.0, (double)(127 - yy) * heipoint, ww * mulpoint, (double)(hh + 1) * heipoint);
            g2d.fill(aRec);
            g2d.setColor(new Color(0.22f, 0.22f, 0.51f));
            g2d.draw(aRec);
        }
    }
}

