/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Editor.GPRContour;
import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.GTTM.Model.MusicXML.TimeInterface;
import com.dacreation.GTTM.Model.PolyphonicMRObject;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.Voices;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;

public class GPR
extends PolyphonicMRObject {
    private Hashtable<String, GPRule> GGPRule;
    private Hashtable<String, Map> GPRAppliedMap;
    private boolean showBrackets;
    private boolean showContours;
    double currentPos = 0.0;

    @Override
    protected void prepareVectors() {
        this.GGPRule = new Hashtable();
        this.GPRAppliedMap = new Hashtable();
    }

    public GPR(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
        this.prepareVectors();
    }

    public GPR(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
        this.prepareVectors();
    }

    public GPR(Profile pr) throws Exception {
        super(pr);
        this.prepareVectors();
        this.MRDocument.setRootElement(new Element("GPR"));
    }

    public GPR(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        this.prepareVectors();
        GPR source = (GPR)sourcex;
        if (source != null) {
            // empty if block
        }
    }

    public GPRule getGPRule(String id) {
        return this.GGPRule.get(id);
    }

    public URL getURL() throws MalformedURLException {
        if (this.parent.getVoices().getEditVoice() != null) {
            return new URL(this.parent.getVoices().getEditVoice().getGPRFilename());
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return new URL(this.parent.getVoices().getDefaultVoice().getGPRFilename());
        }
        return null;
    }

    public String getURLString() {
        if (this.parent.getVoices().getEditVoice() != null) {
            return this.parent.getVoices().getEditVoice().getGPRFilename();
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return this.parent.getVoices().getDefaultVoice().getGPRFilename();
        }
        return null;
    }

    public Map getGPRAppliedMap(String voiceID) {
        return this.GPRAppliedMap.get(voiceID);
    }

    @Override
    public void setupMRObject() throws UIException {
        this.prepareVectors();
        if (this.MRDocument.getRootElement().getName().compareToIgnoreCase("GPR") != 0) {
            throw new UIException("The file is not of the expected type.");
        }
        if (!this.containsOnlyKnownVoices()) {
            throw new UIException("The file contains groups for voices for which you do not have music xml data. Please use [File > Import] to open only certain voices instead.");
        }
        Iterator itr = this.MRDocument.getRootElement().getChildren("part").iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                Element voice = (Element)itr.next();
                String voiceID = voice.getAttributeValue("id");
                Voices.Voice newVoice = this.parent.getVoices().registerVoice(voiceID);
                this.GGPRule.put(voiceID, new GPRule(voice, null, newVoice));
                String source = voice.getAttributeValue("src");
                if (source != null) {
                    newVoice.setGPRfilename(source);
                    continue;
                }
                newVoice.setGPRfilename(this.MRURL.toString());
            }
        } else {
            Voices.Voice voice = this.parent.getVoices().getEditVoice();
            if (voice == null && this.parent.getVoices().getNumberOfVoices() == 1) {
                voice = this.parent.getVoices().getDefaultVoice();
            }
            this.GGPRule.put(voice.getId(), new GPRule(this.MRDocument.getRootElement(), null, voice));
            voice.setGPRfilename(this.MRURL.toString());
        }
    }

    @Override
    String getRootTagName() {
        return "GPR";
    }

    public Document exportXmlDocument(boolean allParts, boolean writePartTags) {
        Document doc = new Document();
        Element root = new Element("GPR");
        Enumeration e = this.parent.getGPR().getVoiceEnumeration();
        while (e.hasMoreElements()) {
            GPRule agr = (GPRule)e.nextElement();
            if (!allParts && !agr.getVoice().isEdit()) continue;
            if (writePartTags) {
                Element part = new Element("part");
                String id = agr.getVoice().getId();
                part.setAttribute("id", id);
                part.addContent(agr.createElement(new HashMap(this.GPRAppliedMap.get(id))));
                root.addContent(part);
                continue;
            }
            root.addContent(agr.createElement(new HashMap(this.GPRAppliedMap.get(agr.getVoice().getId()))));
        }
        doc.setRootElement(root);
        return doc;
    }

    public Document exportXmlDocument(Hashtable<String, String> choices) {
        Document doc = new Document();
        Element root = new Element("GPR");
        Enumeration e = this.parent.getGPR().getVoiceEnumeration();
        while (e.hasMoreElements()) {
            GPRule agr = (GPRule)e.nextElement();
            String oldID = agr.getVoice().getId();
            String partID = choices.get(oldID);
            if (partID == null) continue;
            Element part = new Element("part");
            part.setAttribute("id", partID);
            part.addContent(agr.createElement(new HashMap(this.GPRAppliedMap.get(oldID))));
            root.addContent(part);
        }
        doc.setRootElement(root);
        return doc;
    }

    public Enumeration getVoiceEnumeration() {
        return this.GGPRule.elements();
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = this.exportXmlDocument(true, true);
    }

    public void exportXMLDocumentToFile(String filename, boolean allVoices) throws IOException {
        Document doc = this.exportXmlDocument(allVoices, true);
        GPR.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToWriter(Writer writer, boolean allVoices) throws IOException {
        Document doc = this.exportXmlDocument(allVoices, true);
        GPR.saveToWriter(writer, doc);
    }

    public void exportEditVoiceToFileWithoutPartTags(String filename) throws IOException {
        Document doc = this.exportXmlDocument(false, false);
        GPR.saveToFile(filename, doc);
    }

    public void exportAllVoicesToFileWithoutPartTags(String filename) throws IOException {
        Document doc = this.exportXmlDocument(true, false);
        GPR.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToFile(String filename, Hashtable<String, String> choices) throws IOException {
        Document doc = this.exportXmlDocument(choices);
        GPR.saveToFile(filename, doc);
    }

    public void unregisterVoices() {
        Enumeration e = this.getVoiceEnumeration();
        while (e.hasMoreElements()) {
            GPRule part = (GPRule)e.nextElement();
            this.parent.getVoices().unregisterVoice(part.getVoice());
        }
    }

    public boolean isShowBrackets() {
        return this.showBrackets;
    }

    public void setShowBrackets(boolean show) {
        this.showBrackets = show;
    }

    public boolean isShowContours() {
        return this.showContours;
    }

    public void setShowContours(boolean show) {
        this.showContours = show;
    }

    @Override
    public boolean isShow() {
        return this.showBrackets || this.showContours;
    }

    @Override
    public void setShow(boolean show) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public class GPRule
    implements TimeInterface {
        private List<TimeInterface> children = new ArrayList<TimeInterface>();
        private GPRule gpParent;
        private double absoluteTime;
        private double duration;
        private GeneralPath graph;
        public GPRContour contour = new GPRContour(this);
        private int level;
        private Voices.Voice voice;

        public GeneralPath getGraph() {
            return this.graph;
        }

        public void setGraph(GeneralPath graph) {
            this.graph = graph;
        }

        private Element createElement(Map copiedMap) {
            Element el = new Element("group");
            TreeSet<TimeInterface> as = new TreeSet<TimeInterface>(new StartTimeComparator());
            as.addAll(this.children);
            for (TimeInterface ti : as) {
                double dd = ti.getAbsoluteTime();
                GPRApplied agp = (GPRApplied)copiedMap.get(new Double(dd));
                if (agp != null) {
                    copiedMap.remove(new Double(dd));
                    for (String rule : agp.rule) {
                        Element app = new Element("applied");
                        app.setAttribute("rule", rule);
                        el.addContent(app);
                    }
                }
                if (ti instanceof Note) {
                    Element nt = new Element("note");
                    nt.setAttribute("id", ((Note)ti).getIdName());
                    el.addContent(nt);
                    continue;
                }
                if (!(ti instanceof GPRule)) continue;
                Element nc = ((GPRule)ti).createElement(copiedMap);
                el.addContent(nc);
            }
            return el;
        }

        public GPRule(Element group, GPRule p, Voices.Voice voice) {
            this.voice = voice;
            if (GPR.this.GPRAppliedMap.get(this.voice.getId()) == null) {
                GPR.this.GPRAppliedMap.put(this.voice.getId(), new HashMap());
            }
            MXML amx = GPR.this.parent.getMXML();
            if (p == null && group.getChildren("group").size() == 0) {
                if (amx != null) {
                    this.addAllToChild(amx.getContent().getNoteStartTimeSet(this.voice.getId()));
                }
            } else {
                if (p == null) {
                    GPR.this.currentPos = 0.0;
                }
                if (group != null) {
                    List cc = group.getChildren();
                    for (Element cie : cc) {
                        double at;
                        if (cie.getName().compareToIgnoreCase("group") == 0) {
                            GPRule ang = new GPRule(cie, this, this.voice);
                            this.addToChild(ang);
                            continue;
                        }
                        if (cie.getName().compareToIgnoreCase("note") == 0) {
                            String nid = cie.getAttributeValue("id");
                            Note aNote = amx.getNoteFromID(nid);
                            if (aNote == null) continue;
                            this.addToChild(aNote);
                            GPR.this.currentPos = aNote.getAbsoluteTime();
                            if (aNote.getIdName().split("-")[0].equals(this.voice.getId())) continue;
                            aNote.setVoice(this.voice);
                            continue;
                        }
                        if (cie.getName().compareToIgnoreCase("applied") != 0) continue;
                        Note n1 = new Note();
                        n1.setAbsoluteTime(GPR.this.currentPos + 1.0E-4);
                        TreeSet startTimeSet = amx.getContent().getNoteStartTimeSet(this.voice.getId());
                        if (startTimeSet == null) continue;
                        SortedSet<Note> as = startTimeSet.tailSet(n1);
                        if (as.size() > 0) {
                            TimeInterface tis = as.first();
                            at = tis.getAbsoluteTime();
                        } else {
                            Note lastnote = (Note)amx.getContent().getNoteStartTimeSet(this.voice.getId()).last();
                            at = lastnote.getAbsoluteTime() + lastnote.getDuration();
                        }
                        GPRApplied ap = (GPRApplied)((Map)GPR.this.GPRAppliedMap.get(this.voice.getId())).get(new Double(at));
                        if (ap == null) {
                            ((Map)GPR.this.GPRAppliedMap.get(this.voice.getId())).put(new Double(at), new GPRApplied(cie.getAttributeValue("rule"), at));
                            continue;
                        }
                        ap.add(cie.getAttributeValue("rule"));
                    }
                }
            }
            this.updateTime();
            this.level = -1;
        }

        public void updateTime() {
            TimeInterface ii;
            Set sa = this.getContaindNotes();
            if (sa.size() > 0) {
                TreeSet noteListStartOrder = new TreeSet(new StartTimeComparator());
                noteListStartOrder.addAll(sa);
                Note fn = (Note)noteListStartOrder.first();
                Note en = (Note)noteListStartOrder.last();
                Note ex = new Note();
                ex.setAbsoluteTime(en.getAbsoluteTime() + 0.001);
                MXML am = GPR.this.parent.getMXML();
                TreeSet startTimeSet = am.getContent().getNoteStartTimeSet(this.voice.getId());
                if (startTimeSet != null) {
                    SortedSet<Note> ss = startTimeSet.tailSet(ex);
                    this.absoluteTime = fn.getAbsoluteTime();
                    this.duration = ss.size() > 0 ? en.getAbsoluteTime() + en.getDuration() - this.absoluteTime : en.getAbsoluteTime() + en.getDuration() - this.absoluteTime;
                }
            }
            if (this.children.size() == 1 && (ii = (TimeInterface)this.children.toArray()[0]) instanceof GPRule && ((GPRule)ii).getContaindNotes().equals(sa)) {
                this.removeFromChild(ii);
                this.addAllToChild(((GPRule)ii).children);
            }
            if (this.gpParent != null) {
                this.gpParent.updateTime();
            }
        }

        private void addToChild(TimeInterface at) {
            if (at instanceof GPRule) {
                ((GPRule)at).gpParent = this;
            }
            this.children.add(at);
        }

        private void addAllToChild(Collection<TimeInterface> ata) {
            for (TimeInterface at : ata) {
                if (at instanceof GPRule) {
                    ((GPRule)at).gpParent = this;
                }
                this.children.add(at);
            }
        }

        private void removeFromChild(TimeInterface at) {
            this.children.remove(at);
        }

        private void removeAllFromChild(Collection<TimeInterface> ata) {
            for (TimeInterface at : ata) {
                this.children.remove(at);
            }
        }

        private void clearChild() {
            this.children.clear();
        }

        public Set getContaindNotes() {
            HashSet<TimeInterface> aSet = new HashSet<TimeInterface>();
            for (TimeInterface cn : this.children) {
                if (cn instanceof Note) {
                    aSet.add(cn);
                    continue;
                }
                if (!(cn instanceof GPRule)) continue;
                aSet.addAll(((GPRule)cn).getContaindNotes());
            }
            return aSet;
        }

        public Set getContaindGroups() {
            HashSet<TimeInterface> aSet = new HashSet<TimeInterface>();
            for (TimeInterface cn : this.children) {
                if (!(cn instanceof GPRule)) continue;
                aSet.add(cn);
            }
            return aSet;
        }

        private void invalidateLevelsUp() {
            if (this.gpParent != null) {
                this.gpParent.invalidateLevelsUp();
            } else {
                this.invalidateLevelsDown();
            }
        }

        private void invalidateLevelsDown() {
            this.level = -1;
            for (GPRule sg : this.getContaindGroups()) {
                sg.invalidateLevelsDown();
            }
        }

        private void updateLevel() {
            this.level = 0;
            Iterator sgi = this.getContaindGroups().iterator();
            int highestLevel = 0;
            if (sgi.hasNext()) {
                this.level = 1;
            }
            while (sgi.hasNext()) {
                GPRule sg = (GPRule)sgi.next();
                int l = sg.getLevel();
                if (l <= highestLevel) continue;
                highestLevel = l;
            }
            this.level += highestLevel;
        }

        public int getLevel() {
            if (this.level == -1) {
                this.updateLevel();
            }
            return this.level;
        }

        public void addGPRuleFromNotes(Collection noteSet) {
            Set cn = this.getContaindNotes();
            cn.retainAll(noteSet);
            noteSet.removeAll(cn);
            for (GPRule gPRule : this.children) {
                gPRule.addGPRuleFromNotes(cn);
            }
        }

        @Override
        public double getAbsoluteTime() {
            return this.absoluteTime;
        }

        @Override
        public double getDuration() {
            return this.duration;
        }

        public void deleteOnlyThisGPRule() {
            if (this.gpParent != null) {
                GPRule par = this.gpParent;
                par.addAllToChild(this.children);
                this.clearChild();
                par.removeFromChild(this);
                par.updateTime();
                this.invalidateLevelsUp();
            }
        }

        public void deleteAllDesendant() {
            Set as = this.getContaindNotes();
            this.clearChild();
            this.addAllToChild(as);
            this.updateTime();
            this.invalidateLevelsUp();
        }

        public void divideHere(double divTime) {
            if (this.gpParent != null) {
                GPRule par = this.gpParent;
                TreeSet<TimeInterface> gListStartOrder = new TreeSet<TimeInterface>(new StartTimeComparator());
                gListStartOrder.addAll(this.children);
                if (gListStartOrder.size() > 0) {
                    TimeInterface ti;
                    Note dn = new Note();
                    dn.setAbsoluteTime(divTime - 1.0E-4);
                    dn.setDuration(1.0E-4);
                    SortedSet<TimeInterface> fh = gListStartOrder.headSet(dn);
                    SortedSet<TimeInterface> eh = gListStartOrder.tailSet(dn);
                    GPRule first = new GPRule(null, par, this.voice);
                    GPRule end = new GPRule(null, par, this.voice);
                    HashSet<TimeInterface> an = new HashSet<TimeInterface>();
                    if (fh.size() > 0 && eh.size() > 0 && (ti = (TimeInterface)eh.first()).getAbsoluteTime() == divTime) {
                        first.addAllToChild(fh);
                        an.add(first);
                        end.addAllToChild(eh);
                        an.add(end);
                        first.updateTime();
                        end.updateTime();
                        this.clearChild();
                        par.addAllToChild(an);
                        par.removeFromChild(this);
                        par.updateTime();
                        this.invalidateLevelsUp();
                    }
                }
            }
        }

        public void divideHereAndCreateSubGroups(double divTime) {
            TreeSet<TimeInterface> gListStartOrder = new TreeSet<TimeInterface>(new StartTimeComparator());
            gListStartOrder.addAll(this.children);
            if (gListStartOrder.size() > 0) {
                TimeInterface ti;
                Note dn = new Note();
                dn.setAbsoluteTime(divTime - 1.0E-4);
                dn.setDuration(1.0E-4);
                SortedSet<TimeInterface> fh = gListStartOrder.headSet(dn);
                SortedSet<TimeInterface> eh = gListStartOrder.tailSet(dn);
                GPRule first = new GPRule(null, this, this.voice);
                GPRule end = new GPRule(null, this, this.voice);
                HashSet<TimeInterface> an = new HashSet<TimeInterface>();
                if (fh.size() > 0 && eh.size() > 0 && (ti = (TimeInterface)eh.first()).getAbsoluteTime() == divTime) {
                    first.addAllToChild(fh);
                    an.add(first);
                    end.addAllToChild(eh);
                    an.add(end);
                    first.updateTime();
                    end.updateTime();
                    this.clearChild();
                    this.addAllToChild(an);
                    this.updateTime();
                    this.invalidateLevelsUp();
                }
            }
        }

        public GPRule getParent() {
            return this.gpParent;
        }

        public boolean isShow() {
            return this.voice.isShow();
        }

        public Voices.Voice getVoice() {
            return this.voice;
        }
    }

    public class GPRApplied {
        public double at;
        public List rule = new ArrayList();

        public GPRApplied(String r, double a) {
            this.rule.add(r);
            this.at = a;
        }

        public GPRApplied(double a) {
            this.at = a;
        }

        public void add(String r) {
            this.rule.add(r);
        }
    }
}

