/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.Profile;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class HARMONY
extends MRObject {
    public ArrayList<Key> keys = new ArrayList();

    public HARMONY(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
    }

    public HARMONY(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
    }

    public HARMONY(Profile pr) throws Exception {
        super(pr);
        this.MRDocument.setRootElement(new Element("harmony"));
    }

    public HARMONY(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        HARMONY source = (HARMONY)sourcex;
        if (source != null) {
            // empty if block
        }
    }

    @Override
    String getRootTagName() {
        return "harmony";
    }

    @Override
    public void setupMRObject() {
        List ks = this.MRDocument.getRootElement().getChildren("key");
        for (Element ket : ks) {
            String knm = ket.getAttributeValue("name");
            double kat = Double.parseDouble(ket.getAttributeValue("at"));
            Key ssk = new Key(knm, kat);
            this.keys.add(ssk);
            List rn = ket.getChildren("roman");
            for (Element rne : rn) {
                String rnm = rne.getAttributeValue("numeral");
                double rat = Double.parseDouble(rne.getAttributeValue("at"));
                ssk.elements.add(new HarmonyElement(rnm, rat));
            }
        }
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = new Document();
        Element root = new Element("harmony");
        for (Key m : this.keys) {
            Element el = new Element("key");
            el.setAttribute("name", m.name);
            el.setAttribute("at", "" + m.at);
            for (HarmonyElement mi : m.elements) {
                Element eapl = new Element("roman");
                eapl.setAttribute("numeral", mi.romanName);
                eapl.setAttribute("at", "" + mi.at);
                el.addContent(eapl);
            }
            root.addContent(el);
        }
        this.MRDocument.setRootElement(root);
    }

    public static class HarmonyElement
    implements Comparable {
        public String romanName;
        public double at;
        public double duration;

        public HarmonyElement(String a, double d) {
            this.romanName = a;
            this.at = d;
        }

        public int compareTo(Object obj) {
            HarmonyElement n1 = (HarmonyElement)obj;
            return (int)(this.at * 100000.0 - n1.at * 100000.0);
        }
    }

    public static class Key
    implements Comparable {
        public String name;
        public double at;
        public double duration;
        public ArrayList<HarmonyElement> elements = new ArrayList();

        public Key(String a, double d) {
            this.name = a;
            this.at = d;
        }

        public int compareTo(Object obj) {
            Key n1 = (Key)obj;
            return (int)(this.at * 100000.0 - n1.at * 100000.0);
        }
    }
}

