/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.GTTM.Model.MusicXML.TimeInterface;
import com.dacreation.GTTM.Model.Profile;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;

public class HM
extends MRObject {
    HMGroup GHMGroup;

    public HM(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
    }

    public HM(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
    }

    public HM(Profile pr) throws Exception {
        super(pr);
        this.MRDocument.setRootElement(new Element("region"));
    }

    public HM(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        HM source = (HM)sourcex;
        if (source != null) {
            // empty if block
        }
    }

    public HMGroup getHMGroup() {
        return this.GHMGroup;
    }

    @Override
    public void setupMRObject() {
        this.GHMGroup = new HMGroup(this.MRDocument.getRootElement(), null);
    }

    @Override
    String getRootTagName() {
        return "region";
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = new Document();
        Element root = this.GHMGroup.createElement();
        this.MRDocument.setRootElement(root);
    }

    public URL getURL() {
        return this.MRURL;
    }

    public class HMGroup
    implements TimeInterface {
        private List<TimeInterface> children = new ArrayList<TimeInterface>();
        private HMGroup gpParent;
        private double absoluteTime;
        private double duration;
        private boolean isRegion;
        private String label;

        private Element createElement() {
            Element el;
            if (this.isRegion) {
                el = new Element("region");
                el.setAttribute("label", this.label);
            } else {
                el = new Element("chord-span");
                el.setAttribute("deg", this.label);
            }
            TreeSet<TimeInterface> as = new TreeSet<TimeInterface>(new StartTimeComparator());
            as.addAll(this.children);
            for (TimeInterface ti : as) {
                double dd = ti.getAbsoluteTime();
                if (ti instanceof Note) {
                    Element nt = new Element("note");
                    nt.setAttribute("id", ((Note)ti).getIdName());
                    el.addContent(nt);
                    continue;
                }
                if (!(ti instanceof HMGroup)) continue;
                Element nc = ((HMGroup)ti).createElement();
                el.addContent(nc);
            }
            return el;
        }

        public HMGroup(Element group, HMGroup p) {
            MXML amx = HM.this.parent.getMXML();
            if (p == null && group != null && group.getChildren().size() == 0) {
                if (amx != null) {
                    this.addAllToChild(amx.getContent().getNoteStartTimeSet());
                    this.setRegion(true);
                    this.setLabel("root");
                }
            } else if (group != null) {
                String lb;
                if (group.getName().compareToIgnoreCase("region") == 0) {
                    this.setRegion(true);
                    lb = group.getAttributeValue("label");
                    this.setLabel(lb);
                } else if (group.getName().compareToIgnoreCase("chord-span") == 0) {
                    this.setRegion(false);
                    lb = group.getAttributeValue("deg");
                    this.setLabel(lb);
                }
                List cc = group.getChildren();
                for (Element cie : cc) {
                    String id;
                    Note aNote;
                    HMGroup ang;
                    if (cie.getName().compareToIgnoreCase("region") == 0) {
                        ang = new HMGroup(cie, this);
                        this.addToChild(ang);
                        continue;
                    }
                    if (cie.getName().compareToIgnoreCase("chord-span") == 0) {
                        ang = new HMGroup(cie, this);
                        this.addToChild(ang);
                        continue;
                    }
                    if (cie.getName().compareToIgnoreCase("note") != 0 || (aNote = amx.getNoteFromID(id = cie.getAttributeValue("id"))) == null) continue;
                    this.addToChild(aNote);
                }
            }
            this.updateTime();
        }

        public void updateTime() {
            Set sa = this.getContaindNotes();
            if (sa.size() > 0) {
                TreeSet noteListStartOrder = new TreeSet(new StartTimeComparator());
                noteListStartOrder.addAll(sa);
                Note fn = (Note)noteListStartOrder.first();
                Note en = (Note)noteListStartOrder.last();
                Note ex = new Note();
                ex.setAbsoluteTime(en.getAbsoluteTime() + 0.001);
                MXML am = HM.this.parent.getMXML();
                SortedSet<Note> ss = am.getContent().getNoteStartTimeSet().tailSet(ex);
                this.absoluteTime = fn.getAbsoluteTime();
                this.duration = ss.size() > 0 ? ss.first().getAbsoluteTime() - this.absoluteTime : en.getAbsoluteTime() + en.getDuration() - this.absoluteTime;
            }
            if (this.gpParent != null) {
                this.gpParent.updateTime();
            }
        }

        private void addToChild(TimeInterface at) {
            if (at instanceof HMGroup) {
                ((HMGroup)at).gpParent = this;
            }
            this.children.add(at);
        }

        private void addAllToChild(Collection<TimeInterface> ata) {
            for (TimeInterface at : ata) {
                if (at instanceof HMGroup) {
                    ((HMGroup)at).gpParent = this;
                }
                this.children.add(at);
            }
        }

        private void removeFromChild(TimeInterface at) {
            this.children.remove(at);
        }

        private void removeAllFromChild(Collection<TimeInterface> ata) {
            for (TimeInterface at : ata) {
                this.children.remove(at);
            }
        }

        private void clearChild() {
            this.children.clear();
        }

        public Set getContaindNotes() {
            HashSet<TimeInterface> aSet = new HashSet<TimeInterface>();
            for (TimeInterface cn : this.children) {
                if (cn instanceof Note) {
                    aSet.add(cn);
                    continue;
                }
                if (!(cn instanceof HMGroup)) continue;
                aSet.addAll(((HMGroup)cn).getContaindNotes());
            }
            return aSet;
        }

        public Set getContaindGroups() {
            HashSet<TimeInterface> aSet = new HashSet<TimeInterface>();
            for (TimeInterface cn : this.children) {
                if (!(cn instanceof HMGroup)) continue;
                aSet.add(cn);
            }
            return aSet;
        }

        public void addHMGroupFromNotes(Collection noteSet) {
            Set cn = this.getContaindNotes();
            cn.retainAll(noteSet);
            noteSet.removeAll(cn);
            for (HMGroup hMGroup : this.children) {
                hMGroup.addHMGroupFromNotes(cn);
            }
        }

        @Override
        public double getAbsoluteTime() {
            return this.absoluteTime;
        }

        @Override
        public double getDuration() {
            return this.duration;
        }

        public boolean isRegion() {
            return this.isRegion;
        }

        public void setRegion(boolean reg) {
            this.isRegion = reg;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String lb) {
            this.label = lb;
        }

        public void deleteOnlyThisHMGroup() {
            if (this.gpParent != null) {
                HMGroup par = this.gpParent;
                par.addAllToChild(this.children);
                this.clearChild();
                par.removeFromChild(this);
                par.updateTime();
            }
        }

        public void deleteAllDesendant() {
            Set as = this.getContaindNotes();
            this.clearChild();
            this.addAllToChild(as);
            this.updateTime();
        }

        public void divideHere(double divTime) {
            if (this.gpParent != null) {
                HMGroup par = this.gpParent;
                TreeSet<TimeInterface> gListStartOrder = new TreeSet<TimeInterface>(new StartTimeComparator());
                gListStartOrder.addAll(this.children);
                if (gListStartOrder.size() > 0) {
                    TimeInterface ti;
                    Note dn = new Note();
                    dn.setAbsoluteTime(divTime - 1.0E-4);
                    dn.setDuration(1.0E-4);
                    SortedSet<TimeInterface> fh = gListStartOrder.headSet(dn);
                    SortedSet<TimeInterface> eh = gListStartOrder.tailSet(dn);
                    HMGroup first = new HMGroup(null, par);
                    HMGroup end = new HMGroup(null, par);
                    first.setLabel("deg");
                    end.setLabel("deg");
                    HashSet<TimeInterface> an = new HashSet<TimeInterface>();
                    if (fh.size() > 0 && eh.size() > 0 && (ti = (TimeInterface)eh.first()).getAbsoluteTime() == divTime) {
                        first.addAllToChild(fh);
                        an.add(first);
                        end.addAllToChild(eh);
                        an.add(end);
                        first.updateTime();
                        end.updateTime();
                        this.clearChild();
                        par.addAllToChild(an);
                        par.removeFromChild(this);
                        par.updateTime();
                    }
                }
            }
        }

        public void divideHereAndCreateSubGroups(double divTime) {
            TreeSet<TimeInterface> gListStartOrder = new TreeSet<TimeInterface>(new StartTimeComparator());
            gListStartOrder.addAll(this.children);
            if (gListStartOrder.size() > 0) {
                TimeInterface ti;
                Note dn = new Note();
                dn.setAbsoluteTime(divTime - 1.0E-4);
                dn.setDuration(1.0E-4);
                SortedSet<TimeInterface> fh = gListStartOrder.headSet(dn);
                SortedSet<TimeInterface> eh = gListStartOrder.tailSet(dn);
                HMGroup first = new HMGroup(null, this);
                HMGroup end = new HMGroup(null, this);
                first.setLabel("deg");
                end.setLabel("deg");
                HashSet<TimeInterface> an = new HashSet<TimeInterface>();
                if (fh.size() > 0 && eh.size() > 0 && (ti = (TimeInterface)eh.first()).getAbsoluteTime() == divTime) {
                    first.addAllToChild(fh);
                    an.add(first);
                    end.addAllToChild(eh);
                    an.add(end);
                    first.updateTime();
                    end.updateTime();
                    this.clearChild();
                    this.addAllToChild(an);
                    this.updateTime();
                }
            }
        }

        public void createSubGroup() {
            HMGroup first = new HMGroup(null, this);
            first.setLabel("deg");
            first.addAllToChild(this.children);
            this.clearChild();
            this.addToChild(first);
            first.updateTime();
        }

        public HMGroup getParent() {
            return this.gpParent;
        }
    }
}

