/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.PolyphonicMRObject;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.Voices;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdom.Document;
import org.jdom.Element;

public class MPR
extends PolyphonicMRObject {
    public Hashtable<String, MetricRuleTree> metricRuleTree;

    public MPR(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
        this.prepareVectors();
    }

    public MPR(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
        this.prepareVectors();
    }

    public MPR(Profile pr) throws Exception {
        super(pr);
        this.prepareVectors();
        this.MRDocument.setRootElement(new Element("MPR"));
    }

    public MPR(MRObject sourcex, Profile pr, Voices.Voice voice) throws Exception {
        super(sourcex, pr);
        this.prepareVectors();
        MPR source = (MPR)sourcex;
        if (source != null) {
            // empty if block
        }
    }

    @Override
    String getRootTagName() {
        return "MPR";
    }

    @Override
    public void setupMRObject() throws UIException {
        if (this.MRDocument.getRootElement().getName().compareToIgnoreCase("MPR") != 0) {
            throw new UIException("The file is not of the expected type.");
        }
        if (!this.containsOnlyKnownVoices()) {
            throw new UIException("The file contains metric data for voices for which you do not have music xml data. Please use [File > Import] to open only certain voices instead.");
        }
        Iterator itr = this.MRDocument.getRootElement().getChildren("part").iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                Element voice = (Element)itr.next();
                String voiceID = voice.getAttributeValue("id");
                Voices.Voice newVoice = this.parent.getVoices().registerVoice(voiceID);
                this.metricRuleTree.put(voiceID, new MetricRuleTree(voice, newVoice));
                String source = voice.getAttributeValue("src");
                if (source != null) {
                    newVoice.setMPRfilename(source);
                    continue;
                }
                newVoice.setMPRfilename(this.MRURL.toString());
            }
        } else {
            Voices.Voice voice = this.parent.getVoices().getEditVoice();
            if (voice == null && this.parent.getVoices().getNumberOfVoices() == 1) {
                voice = this.parent.getVoices().getDefaultVoice();
            }
            this.metricRuleTree.put(voice.getId(), new MetricRuleTree(this.MRDocument.getRootElement(), voice));
            voice.setMPRfilename(this.MRURL.toString());
        }
    }

    public MetricRuleTree getMRMPRule(String voiceID) {
        return this.metricRuleTree.get(voiceID);
    }

    @Override
    protected void prepareVectors() {
        this.metricRuleTree = new Hashtable();
    }

    public URL getURL() throws MalformedURLException {
        if (this.parent.getVoices().getEditVoice() != null) {
            return new URL(this.parent.getVoices().getEditVoice().getGPRFilename());
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return new URL(this.parent.getVoices().getDefaultVoice().getGPRFilename());
        }
        return null;
    }

    public String getURLString() {
        if (this.parent.getVoices().getEditVoice() != null) {
            return this.parent.getVoices().getEditVoice().getGPRFilename();
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return this.parent.getVoices().getDefaultVoice().getGPRFilename();
        }
        return null;
    }

    public Document exportXmlDocument(boolean allParts, boolean writePartTags) {
        MXML am = this.parent.getMXML();
        Document doc = new Document();
        Element root = new Element("MPR");
        Enumeration e = this.parent.getMPR().getVoiceEnumeration();
        while (e.hasMoreElements()) {
            MetricRuleTree mrt = (MetricRuleTree)e.nextElement();
            if (!allParts && !mrt.getVoice().isEdit()) continue;
            Element part = new Element("part");
            String id = mrt.getVoice().getId();
            part.setAttribute("id", id);
            TreeSet ns = am.getContent().getNoteStartTimeSet(id);
            for (MetricRuleTree.MPRMetric m : mrt.MRMPRule) {
                Element el = new Element("metric");
                el.setAttribute("dot", "" + m.dot);
                el.setAttribute("at", "" + m.at);
                for (MetricRuleTree.MetricRule mi : m.applied) {
                    Element eapl = new Element("applied");
                    eapl.setAttribute("level", "" + mi.level);
                    eapl.setAttribute("rule", "" + mi.rule);
                    el.addContent(eapl);
                }
                Note fn = new Note();
                Note en = new Note();
                fn.setAbsoluteTime(m.at - 1.0E-4);
                en.setAbsoluteTime(m.at + 1.0E-4);
                SortedSet<Note> s1 = ns.tailSet(fn);
                SortedSet<Note> s2 = ns.headSet(en);
                HashSet<Note> dds = new HashSet<Note>(s1);
                HashSet<Note> ddt = new HashSet<Note>(s2);
                dds.retainAll(ddt);
                for (Note an : dds) {
                    Element nn = new Element("note");
                    nn.setAttribute("id", an.getIdName());
                    el.addContent(nn);
                }
                if (writePartTags) {
                    part.addContent(el);
                    continue;
                }
                root.addContent(el);
            }
            if (!writePartTags) continue;
            root.addContent(part);
        }
        doc.setRootElement(root);
        return doc;
    }

    public Document exportXmlDocument(Hashtable<String, String> choices) {
        MXML am = this.parent.getMXML();
        Document doc = new Document();
        Element root = new Element("MPR");
        Enumeration e = this.parent.getMPR().getVoiceEnumeration();
        while (e.hasMoreElements()) {
            MetricRuleTree mrt = (MetricRuleTree)e.nextElement();
            String oldID = mrt.getVoice().getId();
            String partID = choices.get(oldID);
            if (partID == null) continue;
            Element part = new Element("part");
            part.setAttribute("id", partID);
            TreeSet ns = am.getContent().getNoteStartTimeSet(oldID);
            for (MetricRuleTree.MPRMetric m : mrt.MRMPRule) {
                Element el = new Element("metric");
                el.setAttribute("dot", "" + m.dot);
                el.setAttribute("at", "" + m.at);
                for (MetricRuleTree.MetricRule mi : m.applied) {
                    Element eapl = new Element("applied");
                    eapl.setAttribute("level", "" + mi.level);
                    eapl.setAttribute("rule", "" + mi.rule);
                    el.addContent(eapl);
                }
                Note fn = new Note();
                Note en = new Note();
                fn.setAbsoluteTime(m.at - 1.0E-4);
                en.setAbsoluteTime(m.at + 1.0E-4);
                SortedSet<Note> s1 = ns.tailSet(fn);
                SortedSet<Note> s2 = ns.headSet(en);
                HashSet<Note> dds = new HashSet<Note>(s1);
                HashSet<Note> ddt = new HashSet<Note>(s2);
                dds.retainAll(ddt);
                for (Note an : dds) {
                    Element nn = new Element("note");
                    nn.setAttribute("id", an.getIdName());
                    el.addContent(nn);
                }
                part.addContent(el);
            }
            root.addContent(part);
        }
        doc.setRootElement(root);
        return doc;
    }

    public Enumeration getVoiceEnumeration() {
        return this.metricRuleTree.elements();
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = this.exportXmlDocument(true, true);
    }

    public void exportXMLDocumentToFile(String filename, boolean allVoices) throws IOException {
        Document doc = this.exportXmlDocument(allVoices, true);
        MPR.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToWriter(Writer writer, boolean allVoices) throws IOException {
        Document doc = this.exportXmlDocument(allVoices, true);
        MPR.saveToWriter(writer, doc);
    }

    public void exportEditVoiceToFileWithoutPartTags(String filename) throws IOException {
        Document doc = this.exportXmlDocument(false, false);
        MPR.saveToFile(filename, doc);
    }

    public void exportAllVoicesToFileWithoutPartTags(String filename) throws IOException {
        Document doc = this.exportXmlDocument(true, false);
        MPR.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToFile(String filename, Hashtable<String, String> choices) throws IOException {
        Document doc = this.exportXmlDocument(choices);
        MPR.saveToFile(filename, doc);
    }

    public void unregisterVoices() {
        Enumeration e = this.getVoiceEnumeration();
        while (e.hasMoreElements()) {
            MetricRuleTree part = (MetricRuleTree)e.nextElement();
            this.parent.getVoices().unregisterVoice(part.getVoice());
        }
    }

    public class MetricRuleTree {
        public TreeSet<MPRMetric> MRMPRule = new TreeSet();
        public double minMetrics;
        private Voices.Voice voice;

        public MetricRuleTree(Element parent, Voices.Voice voice) {
            this.voice = voice;
            List ml = parent.getChildren("metric");
            Iterator mli = ml.iterator();
            double aad = 0.0;
            while (mli.hasNext()) {
                Element met = (Element)mli.next();
                int dot = Integer.parseInt(met.getAttributeValue("dot"));
                double att = Double.parseDouble(met.getAttributeValue("at"));
                MPRMetric mprmm = new MPRMetric(att, dot);
                List apl = met.getChildren("applied");
                for (Element aplieel : apl) {
                    MetricRule mrr = new MetricRule(Double.parseDouble(aplieel.getAttributeValue("level")), aplieel.getAttributeValue("rule"));
                    mprmm.applied.add(mrr);
                }
                this.MRMPRule.add(mprmm);
                this.minMetrics = att - aad;
                aad = att;
            }
        }

        public boolean isShow() {
            return this.voice.isShow();
        }

        public Voices.Voice getVoice() {
            return this.voice;
        }

        public class MPRMetric
        implements Comparable {
            public double at;
            public int dot;
            public List<MetricRule> applied = new ArrayList<MetricRule>();

            public MPRMetric(double a, int d) {
                this.at = a;
                this.dot = d;
            }

            public int compareTo(Object obj) {
                MPRMetric n1 = (MPRMetric)obj;
                return (int)(this.at * 100000.0 - n1.at * 100000.0);
            }
        }

        public class MetricRule
        implements Comparable {
            public double level;
            public String rule;

            public MetricRule(double a, String d) {
                this.level = a;
                this.rule = d;
            }

            public int compareTo(Object o) {
                MetricRule n1 = (MetricRule)o;
                if (this.level == n1.level) {
                    return this.rule.compareTo(n1.rule);
                }
                return (int)((this.level - n1.level) * 100000.0);
            }
        }
    }
}

