/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.Voices;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class MRObject {
    private boolean show = true;
    protected static final Level logLevel = Level.FINEST;
    public static final Namespace xlinknamespace = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    Document MRDocument = null;
    Profile parent;
    URL MRURL;
    public Map anyToElement = new HashMap();
    public Map elementToAny = new HashMap();
    boolean edited = false;

    abstract String getRootTagName();

    public abstract void setupMRObject() throws Exception;

    public abstract void createXMLDocument();

    public MRObject() {
    }

    public MRObject(MRObject source, Profile pr) throws Exception {
        this.MRURL = new URL(Long.toHexString(this.hashCode()));
        this.parent = pr;
    }

    public MRObject(URL myUrl, Profile pr) throws Exception {
        this.MRURL = myUrl;
        this.parent = pr;
        URLConnection urlConn = this.MRURL.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("GET");
        }
        urlConn.setDoInput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        builder.setValidation(false);
        this.MRDocument = builder.build(in);
        this.checkDocument(this.MRDocument.getRootElement().getName());
    }

    public MRObject(Reader aReader, Profile pr) throws Exception {
        this.MRURL = new URL("file://GTTM-" + Long.toHexString(this.hashCode()));
        this.parent = pr;
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        builder.setValidation(false);
        this.MRDocument = builder.build(aReader);
        this.checkDocument(this.MRDocument.getRootElement().getName());
    }

    public MRObject(Profile pr) throws Exception {
        this.MRURL = new URL("file://GTTM-" + Long.toHexString(this.hashCode()));
        this.parent = pr;
        this.MRDocument = new Document();
    }

    public Document getDocument() {
        return this.MRDocument;
    }

    public List getElements(String xpaths) throws Exception {
        JDOMXPath xpath = new JDOMXPath(xpaths);
        return xpath.selectNodes(this.MRDocument);
    }

    void checkDocument(String rootName) throws Exception {
        if (rootName.compareToIgnoreCase(this.getRootTagName()) != 0) {
            throw new UIException("The file is not of the expected type. (expected: '" + this.getRootTagName() + "'; found: '" + rootName + "')");
        }
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edit) {
        this.edited = edit;
    }

    public Profile getParent() {
        return this.parent;
    }

    protected String uploadXML(URL myUrl) throws Exception {
        if (this.MRDocument == null) {
            return null;
        }
        String boundary = "--------------------" + Long.toString(System.currentTimeMillis(), 16);
        URLConnection urlConn = myUrl.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("POST");
        }
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setDefaultUseCaches(false);
        urlConn.setRequestProperty("Accept", "*/*");
        urlConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        urlConn.setRequestProperty("Connection", "Keep-Alive");
        urlConn.setRequestProperty("Cache-Control", "no-cache");
        BufferedWriter aw = new BufferedWriter(new OutputStreamWriter(urlConn.getOutputStream()));
        aw.write("--");
        aw.write(boundary);
        aw.write("\r\n");
        aw.write("Content-Disposition: form-data; name=\"xml\" filename=\"temp.xml\"");
        aw.write("\r\n");
        aw.write("Content-Type: text/xml");
        aw.write("\r\n");
        aw.write("\r\n");
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(this.MRDocument, (Writer)aw);
        aw.write("\r\n");
        aw.write("--");
        aw.write(boundary);
        aw.write("--");
        aw.write("\r\n");
        ((Writer)aw).flush();
        ((Writer)aw).close();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        String line = "";
        StringBuffer sb = new StringBuffer();
        String line2 = "";
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public void exportXML(String filePath) throws Exception {
        MRObject.saveToFile(filePath, this.MRDocument);
    }

    public static void saveToFile(String filePath, Document doc) throws IOException {
        FileOutputStream fo = new FileOutputStream(filePath);
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(doc, (OutputStream)fo);
        fo.flush();
        fo.close();
    }

    public static void saveToWriter(Writer writer, Document doc) throws IOException {
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(doc, writer);
    }

    public static Vector<String> getVoiceNames(URL url) throws Exception {
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("GET");
        }
        urlConn.setDoInput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        builder.setValidation(false);
        Document tempDoc = builder.build(in);
        Element root = tempDoc.getRootElement();
        List children = root.getChildren("part");
        Vector<String> foundVoices = new Vector<String>();
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                Element v = (Element)children.get(i);
                foundVoices.add(v.getAttributeValue("id"));
            }
        }
        return foundVoices;
    }

    public boolean containsOnlyKnownVoices() {
        Iterator itr = this.MRDocument.getRootElement().getChildren("part").iterator();
        if (itr.hasNext()) {
            while (itr.hasNext()) {
                Element voice = (Element)itr.next();
                String voiceID = voice.getAttributeValue("id");
                Voices.Voice newVoice = this.parent.getVoices().getVoice(voiceID);
                if (newVoice != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }
}

