/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MusicXML.Attributes;
import com.dacreation.GTTM.Model.MusicXML.Measure;
import com.dacreation.GTTM.Model.MusicXML.MusicXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.Part;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.TSTree.TSNode;
import com.dacreation.GTTM.Model.UIException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.transform.JDOMResult;
import org.jdom.transform.JDOMSource;

public class MXML
extends MRObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    MusicXML content;

    public MXML() {
        this.prepareVector();
    }

    public MXML(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
        if (this.MRDocument.getRootElement().getName().compareToIgnoreCase("score-partwise") != 0 && this.MRDocument.getRootElement().getName().compareToIgnoreCase("score-timewise") != 0) {
            throw new UIException("The file is not of the expected type.");
        }
        this.prepareVector();
        if (this.MRDocument.getRootElement().getName().compareToIgnoreCase("score-timewise") == 0) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(this.getClass().getResourceAsStream("/com/dacreation/GTTM/Model/MusicXML/timepart.xsl")));
            JDOMResult out = new JDOMResult();
            transformer.transform(new JDOMSource(this.MRDocument), out);
            this.MRDocument = out.getDocument();
        }
        this.content = new MusicXML(this.MRDocument, this.parent.getVoices(), myURL);
        for (Note aii : this.content.getNoteStartTimeSet()) {
            String aiistring;
            String temp = aiistring = aii.getIdName();
            this.anyToElement.put(temp, aii);
        }
    }

    public MXML(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        this.prepareVector();
        MXML source = (MXML)sourcex;
        if (source != null) {
            this.content = new MusicXML(source.content);
            for (Note aii : this.content.getNoteStartTimeSet()) {
                this.anyToElement.put(aii.getIdName(), aii);
            }
        }
    }

    public MXML(Profile pr) throws Exception {
        super(pr);
        this.prepareVector();
        this.MRDocument.setRootElement(new Element("score-partwise"));
    }

    private void prepareVector() {
    }

    @Override
    String getRootTagName() {
        return "score-partwise";
    }

    public Note getNoteFromID(String id) {
        return (Note)this.anyToElement.get(id);
    }

    public void addAsVoice(URL url, Hashtable<String, String> choices) throws Exception {
        HttpURLConnection conno = (HttpURLConnection)url.openConnection();
        conno.setInstanceFollowRedirects(false);
        conno.setRequestMethod("GET");
        int status = conno.getResponseCode();
        if (status == 302) {
            String location = conno.getHeaderField("Location");
            url = new URL(location);
        }
        conno.disconnect();
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("GET");
        }
        urlConn.setDoInput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        builder.setValidation(false);
        Document tempDoc = builder.build(in);
        Element root = tempDoc.detachRootElement();
        List children = root.getChildren("part");
        if (children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                Element v = (Element)children.get(i);
                v.detach();
                v.setAttribute("src", url.toString());
                String oldID = v.getAttributeValue("id");
                v.setAttribute("id", choices.get(oldID));
                this.MRDocument.getRootElement().addContent(v);
                i = 0;
            }
        } else {
            root.setName("part");
            root.setAttribute("id", choices.get(""));
            root.setAttribute("src", url.toString());
            this.MRDocument.getRootElement().addContent(root);
        }
        this.prepareVector();
        this.setupMRObject();
    }

    @Override
    public void setupMRObject() throws Exception {
        this.content = new MusicXML(this.MRDocument, this.parent.getVoices(), null);
        for (Note aii : this.content.getNoteStartTimeSet()) {
            this.anyToElement.put(aii.getIdName(), aii);
        }
    }

    public MusicXML getContent() {
        return this.content;
    }

    public void removeNotes(Set selectedSet) {
        HashSet as = new HashSet(this.content.getNoteStartTimeSet());
        for (String idn : selectedSet) {
            Note anot = this.getNoteFromID(idn);
            this.anyToElement.remove(idn);
            as.remove(anot);
            anot.getParent().getNotes().remove(anot);
        }
        this.content.getNoteStartTimeSet().clear();
        this.content.getNoteEndTimeSet().clear();
        this.content.getNoteStartTimeSet().addAll(as);
        this.content.getNoteEndTimeSet().addAll(as);
    }

    public void removeRests() {
        Note fn = (Note)this.content.getNoteStartTimeSet().first();
        Note ln = (Note)this.content.getNoteEndTimeSet().last();
        HashSet<Measure> ms = new HashSet<Measure>();
        for (Measure misd : this.content.getMeasureSet()) {
            if (misd.getNumber() >= fn.getParent().getNumber() && misd.getNumber() <= ln.getParent().getNumber()) {
                ms.add(misd);
                continue;
            }
            misd.getParent().getMeasures().remove(misd);
        }
        this.content.getMeasureSet().clear();
        this.content.getMeasureSet().addAll(ms);
        int offn = fn.getParent().getNumber() - 1;
        double offs = fn.getParent().getAbsoluteTime();
        for (Measure smtm : this.content.getMeasureSet()) {
            smtm.setAbsoluteTime(smtm.getAbsoluteTime() - offs);
            smtm.setNumber(smtm.getNumber() - offn);
        }
        for (Note sitm : this.content.getNoteStartTimeSet()) {
            sitm.setAbsoluteTime(sitm.getAbsoluteTime() - offs);
        }
    }

    public void mixNotes(MXML source, double offset) {
        Enumeration sgpi = source.getContent().getParts().elements();
        while (sgpi.hasMoreElements()) {
            Part sop = (Part)sgpi.nextElement();
            Enumeration mgpi = this.content.getParts().elements();
            boolean partequal = false;
            while (mgpi.hasMoreElements()) {
                Part mop = (Part)mgpi.nextElement();
                if (mop.getPartID().compareToIgnoreCase(sop.getPartID()) != 0) continue;
                partequal = true;
                break;
            }
            if (partequal) continue;
            Part newPart = new Part((Part)this.content.getParts().get(0));
            newPart.setPartID(new String(sop.getPartID()));
            newPart.setMidiChannel(sop.getMidiChannel());
            newPart.setMidiProgram(sop.getMidiProgram());
            for (Measure ameasure : newPart.getMeasures()) {
                ameasure.getNotes().clear();
            }
            this.content.getMeasureSet().addAll(newPart.getMeasures());
            this.content.getParts().put(sop.getPartID(), newPart);
        }
        Measure clastMeasure = (Measure)this.content.getMeasureSet().last();
        Measure slastMeasure = (Measure)source.getContent().getMeasureSet().last();
        Note slastNote = (Note)source.getContent().getNoteEndTimeSet().last();
        Part sapip = (Part)source.getContent().getParts().get(0);
        for (Measure smop : sapip.getMeasures()) {
            Measure plastm;
            Part aparti;
            Enumeration cpipi;
            if (!(smop.getAbsoluteTime() + smop.getWidth() + offset >= clastMeasure.getAbsoluteTime() + clastMeasure.getWidth())) continue;
            if (smop.getAbsoluteTime() + offset < clastMeasure.getAbsoluteTime() + clastMeasure.getWidth()) {
                cpipi = this.content.getParts().elements();
                while (cpipi.hasMoreElements()) {
                    aparti = (Part)cpipi.nextElement();
                    plastm = (Measure)aparti.getMeasures().get(aparti.getMeasures().size() - 1);
                    plastm.setWidth(smop.getAbsoluteTime() + smop.getWidth() + offset - plastm.getAbsoluteTime());
                    plastm.getAttribute().setDivisions(48);
                    plastm.getAttribute().setTimeBeatType(16);
                    plastm.getAttribute().setTimeBeats((int)plastm.getWidth() * 16 / 4);
                }
                continue;
            }
            cpipi = this.content.getParts().elements();
            while (cpipi.hasMoreElements()) {
                aparti = (Part)cpipi.nextElement();
                plastm = (Measure)aparti.getMeasures().get(aparti.getMeasures().size() - 1);
                Measure nmm = new Measure();
                nmm.setAbsoluteTime(smop.getAbsoluteTime() + offset);
                nmm.setWidth(smop.getWidth());
                nmm.setParent(aparti);
                nmm.setAttribute(new Attributes(smop.getAttribute()));
                nmm.setNumber(plastm.getNumber() + 1);
                aparti.getMeasures().add(nmm);
                this.content.getMeasureSet().add(nmm);
            }
        }
        for (Note ain : source.getContent().getNoteStartTimeSet()) {
            Enumeration cpi = this.content.getParts().elements();
            block7: while (cpi.hasMoreElements()) {
                Part cpp = (Part)cpi.nextElement();
                if (cpp.getPartID().compareToIgnoreCase(ain.getParent().getParent().getPartID()) != 0) continue;
                Iterator cpmi = cpp.getMeasures().iterator();
                boolean inmeasure = false;
                while (cpmi.hasNext()) {
                    Measure cpmm = (Measure)cpmi.next();
                    if (!(cpmm.getAbsoluteTime() <= ain.getAbsoluteTime() + offset) || !(ain.getAbsoluteTime() + offset < cpmm.getAbsoluteTime() + cpmm.getWidth())) continue;
                    Note aaii = new Note(ain);
                    aaii.setAbsoluteTime(ain.getAbsoluteTime() + offset);
                    aaii.setAt(aaii.getAbsoluteTime() - cpmm.getAbsoluteTime());
                    aaii.setParent(cpmm);
                    aaii.setRoot(this.content);
                    TSNode sts = (TSNode)source.getParent().getTS().anyToElement.get(ain.getIdName());
                    aaii.setIdName(cpp.getPartID() + "-" + cpmm.getNumber() + "-" + Integer.toHexString(aaii.hashCode()));
                    if (sts != null) {
                        HashSet<Note> headset = new HashSet<Note>(sts.getHead());
                        headset.remove(ain);
                        headset.add(aaii);
                        sts.getHead().clear();
                        sts.getHead().addAll(headset);
                        sts.updateHeadAndDiscendantSet();
                        sts.updateDepth();
                        sts.updateAncestorSet();
                        this.getParent().getTS().anyToElement.put(aaii.getIdName(), sts);
                    }
                    this.anyToElement.put(aaii.getIdName(), aaii);
                    this.content.getNoteStartTimeSet().add(aaii);
                    this.content.getNoteEndTimeSet().add(aaii);
                    cpmm.getNotes().add(aaii);
                    continue block7;
                }
            }
        }
        for (Measure cpmm : this.content.getMeasureSet()) {
            TreeSet ns = new TreeSet(new StartTimeComparator());
            ns.addAll(cpmm.getNotes());
            cpmm.getNotes().clear();
            cpmm.getNotes().addAll(ns);
            HashMap<Note, TSNode> notetsmap = new HashMap<Note, TSNode>();
            for (Note an : cpmm.getNotes()) {
                this.anyToElement.remove(an.getIdName());
                TSNode anode = (TSNode)this.getParent().getTS().anyToElement.get(an.getIdName());
                if (anode == null) continue;
                notetsmap.put(an, anode);
                this.getParent().getTS().anyToElement.remove(an.getIdName());
            }
            Iterator cnai = cpmm.getNotes().iterator();
            int notec = 0;
            while (cnai.hasNext()) {
                Note an = (Note)cnai.next();
                an.setIdName(cpmm.getParent().getPartID() + "-" + cpmm.getNumber() + "-" + ++notec);
                this.anyToElement.put(an.getIdName(), an);
                TSNode anode = (TSNode)notetsmap.get(an);
                if (anode == null) continue;
                this.getParent().getTS().anyToElement.put(an.getIdName(), anode);
            }
        }
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = this.content.exportMusicXmlDocument();
    }

    public void exportXMLDocumentToFile(String filename, boolean allVoices) throws IOException {
        Document doc = this.content.exportMusicXmlDocument(allVoices, null);
        MXML.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToWriter(Writer writer, boolean allVoices) throws IOException {
        Document doc = this.content.exportMusicXmlDocument(allVoices, null);
        MXML.saveToWriter(writer, doc);
    }

    public Enumeration getVoiceEnumeration() {
        return this.content.getParts().elements();
    }

    public URL getURL() throws MalformedURLException {
        if (this.parent.getVoices().getEditVoice() != null) {
            return new URL(this.parent.getVoices().getEditVoice().getMXMLFilename());
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return new URL(this.parent.getVoices().getDefaultVoice().getMXMLFilename());
        }
        return null;
    }

    public String getURLString() {
        if (this.parent.getVoices().getEditVoice() != null) {
            return this.parent.getVoices().getEditVoice().getMXMLFilename();
        }
        if (this.parent.getVoices().getDefaultVoice() != null) {
            return this.parent.getVoices().getDefaultVoice().getMXMLFilename();
        }
        return null;
    }

    public void exportXMLDocumentToFile(String filename, Hashtable<String, String> choices) throws IOException {
        Document doc = this.content.exportMusicXmlDocument(true, choices);
        MXML.saveToFile(filename, doc);
    }

    public void exportXMLDocumentToWriter(Writer writer, Hashtable<String, String> choices) throws IOException {
        Document doc = this.content.exportMusicXmlDocument(true, choices);
        MXML.saveToWriter(writer, doc);
    }

    public void unregisterVoices() {
        Enumeration e = this.getVoiceEnumeration();
        while (e.hasMoreElements()) {
            Part part = (Part)e.nextElement();
            this.parent.getVoices().unregisterVoice(part.getVoice());
        }
    }
}

