/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model.MusicXML;

import com.dacreation.GTTM.Model.MusicXML.Attributes;
import com.dacreation.GTTM.Model.MusicXML.EndTimeComparator;
import com.dacreation.GTTM.Model.MusicXML.Measure;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.Part;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.gttmeditor.Voices;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;

public class MusicXML
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Hashtable<String, Part> parts = new Hashtable();
    private TreeSet noteStartTimeSet = new TreeSet(new StartTimeComparator());
    private TreeSet noteEndTimeSet = new TreeSet(new EndTimeComparator());
    private TreeSet measureSet = new TreeSet();

    protected void finalize() throws Throwable {
        this.getParts().clear();
        this.getNoteStartTimeSet().clear();
        this.getNoteEndTimeSet().clear();
        this.getMeasureSet().clear();
        this.setParts(null);
        this.setNoteStartTimeSet(null);
        this.setNoteEndTimeSet(null);
        this.setMeasureSet(null);
        super.finalize();
    }

    public MusicXML(MusicXML source) {
        this.parts = (Hashtable)source.parts.clone();
        Enumeration<String> keys = this.parts.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Part napa = this.parts.get(key);
            this.getMeasureSet().addAll(napa.getMeasures());
            for (Measure mesa : napa.getMeasures()) {
                this.getNoteStartTimeSet().addAll(mesa.getNotes());
                this.getNoteEndTimeSet().addAll(mesa.getNotes());
                for (Note nasa : mesa.getNotes()) {
                    nasa.setRoot(this);
                }
            }
        }
    }

    public MusicXML(Document partwiseMusicXML, Voices voices, URL url) throws Exception {
        List domParts = partwiseMusicXML.getRootElement().getChildren("part");
        if (domParts == null) {
            throw new Exception();
        }
        Attributes currentAttr = new Attributes();
        ArrayList allNotes = new ArrayList();
        ArrayList temptie = new ArrayList();
        boolean tie_index = false;
        Note tieStartNote = new Note();
        Iterator domParti = domParts.iterator();
        while (domParti.hasNext()) {
            Element result2;
            HashMap tieTemp = new HashMap();
            double absTimeCounter = 0.0;
            Element aDomPart = (Element)domParti.next();
            Part mxPart = new Part();
            String voiceID = aDomPart.getAttributeValue("id");
            Voices.Voice newVoice = voices.registerVoice(voiceID);
            mxPart.setVoice(newVoice);
            String source = aDomPart.getAttributeValue("src");
            if (source != null) {
                newVoice.setMXMLfilename(source);
            } else if (url != null) {
                newVoice.setMXMLfilename(url.toString());
            } else {
                newVoice.setMXMLfilename("unknown");
            }
            this.getParts().put(voiceID, mxPart);
            JDOMXPath xpath = new JDOMXPath("//score-part[@id='" + aDomPart.getAttributeValue("id") + "']");
            Element result = (Element)xpath.selectSingleNode(partwiseMusicXML);
            if (result != null && (result2 = result.getChild("midi-instrument")) != null) {
                mxPart.setMidiChannel(Integer.valueOf(result2.getChildTextTrim("midi-channel")));
                mxPart.setMidiProgram(Integer.valueOf(result2.getChildTextTrim("midi-program")));
            }
            mxPart.setPartID(aDomPart.getAttributeValue("id"));
            ArrayList<Note> partNotes = new ArrayList<Note>();
            List domMeasures = aDomPart.getChildren("measure");
            Iterator domMeai = domMeasures.iterator();
            double lastAdded = 0.0;
            Note lastNote = null;
            while (domMeai.hasNext()) {
                double counterInMeasure = 0.0;
                Note lastRest = null;
                Element aDomMeasure = (Element)domMeai.next();
                Measure mxMeasure = new Measure();
                mxPart.getMeasures().add(mxMeasure);
                mxPart.getMeasureSet().add(mxMeasure);
                mxMeasure.setParent(mxPart);
                mxMeasure.setAbsoluteTime(absTimeCounter);
                this.getMeasureSet().add(mxMeasure);
                mxMeasure.setNumber(Integer.valueOf(aDomMeasure.getAttributeValue("number")));
                mxMeasure.setWidth(currentAttr.getBeats());
                String implicit = aDomMeasure.getAttributeValue("implicit");
                mxMeasure.setImplicit(aDomMeasure.getAttributeValue("implicit"));
                List domContainsInMeasure = aDomMeasure.getChildren();
                Iterator domConi = domContainsInMeasure.iterator();
                boolean chromatic = false;
                int notec = 0;
                while (domConi.hasNext()) {
                    Element aDomContain = (Element)domConi.next();
                    String aDomName = aDomContain.getName();
                    if (aDomName.compareToIgnoreCase("attributes") == 0 || aDomName.compareToIgnoreCase("direction") == 0) {
                        currentAttr = new Attributes(currentAttr);
                    }
                    if (aDomName.compareToIgnoreCase("attributes") == 0) {
                        Element aDomAttrTrans;
                        if (aDomContain.getChild("divisions") != null) {
                            currentAttr.setDivisions(Integer.valueOf(aDomContain.getChildTextTrim("divisions")));
                        }
                        if (aDomContain.getChild("key") != null) {
                            Element aDomAttrKey = aDomContain.getChild("key");
                            if (aDomAttrKey.getChild("fifth") != null) {
                                currentAttr.setKeyFifth(Integer.valueOf(aDomAttrKey.getChildTextTrim("fifths")));
                            }
                            if (aDomAttrKey.getChild("mode") != null) {
                                currentAttr.setKeyMode(aDomAttrKey.getChildTextTrim("mode").compareToIgnoreCase("major") == 0);
                            }
                        }
                        if (aDomContain.getChild("time") != null) {
                            Element aDomAttrTime = aDomContain.getChild("time");
                            if (aDomAttrTime.getChild("beats") != null) {
                                currentAttr.setTimeBeats(Integer.valueOf(aDomAttrTime.getChildTextTrim("beats")));
                            }
                            if (aDomAttrTime.getChild("beat-type") != null) {
                                currentAttr.setTimeBeatType(Integer.valueOf(aDomAttrTime.getChildTextTrim("beat-type")));
                            }
                            mxMeasure.setWidth(currentAttr.getBeats());
                        }
                        if (aDomContain.getChild("transpose") == null || (aDomAttrTrans = aDomContain.getChild("transpose")).getChild("chromatic") == null) continue;
                        currentAttr.setChromatic(Integer.valueOf(aDomAttrTrans.getChildTextTrim("chromatic")));
                        continue;
                    }
                    if (aDomName.compareToIgnoreCase("direction") == 0) {
                        Element aDomDirSound;
                        if (aDomContain.getChild("sound") == null || (aDomDirSound = aDomContain.getChild("sound")).getAttributeValue("tempo") == null) continue;
                        currentAttr.setTempo(Integer.valueOf(aDomDirSound.getAttributeValue("tempo")));
                        continue;
                    }
                    if (aDomName.compareToIgnoreCase("backup") == 0) {
                        if (aDomContain.getChild("duration") == null) continue;
                        counterInMeasure -= Double.valueOf(aDomContain.getChildTextTrim("duration")) / (double)currentAttr.getDivisions();
                        continue;
                    }
                    if (aDomName.compareToIgnoreCase("forward") == 0) {
                        if (aDomContain.getChild("duration") == null) continue;
                        counterInMeasure += Double.valueOf(aDomContain.getChildTextTrim("duration")) / (double)currentAttr.getDivisions();
                        continue;
                    }
                    if (aDomName.compareToIgnoreCase("note") != 0 || aDomContain.getChild("grace") != null) continue;
                    ++notec;
                    if (aDomContain.getChild("chord") != null) {
                        counterInMeasure -= lastAdded;
                    }
                    Note mxNote = new Note();
                    mxNote.setRoot(this);
                    mxNote.setVoice(newVoice);
                    if (aDomContain.getChild("pitch") != null) {
                        List l;
                        mxMeasure.getNotes().add(mxNote);
                        partNotes.add(mxNote);
                        lastRest = null;
                        mxNote.setParent(mxMeasure);
                        mxNote.setAt(counterInMeasure);
                        mxNote.setAbsoluteTime(absTimeCounter + counterInMeasure);
                        mxNote.setIdName(mxPart.getPartID() + "-" + mxMeasure.getNumber() + "-" + notec);
                        if (aDomContain.getChild("chord") != null) {
                            // empty if block
                        }
                        Element aDomPitch = aDomContain.getChild("pitch");
                        String aStep = aDomPitch.getChildTextTrim("step").toUpperCase();
                        String[] chrom = new String[]{"C", "C", "D", "D", "E", "F", "F", "G", "G", "A", "A", "B"};
                        int chromIndex = 0;
                        int octavebyChrom = 0;
                        boolean altbyChrom = false;
                        int currentChromatic = currentAttr.getChromatic();
                        int currentAlter = 0;
                        if (currentChromatic != 0) {
                            for (int i = 0; i < chrom.length; ++i) {
                                if (!aStep.equalsIgnoreCase(chrom[i])) continue;
                                chromIndex = i;
                                break;
                            }
                            if (aDomPitch.getChildTextTrim("alter") != null) {
                                currentAlter = Integer.valueOf(aDomPitch.getChildTextTrim("alter"));
                            }
                            if ((chromIndex = chromIndex + currentChromatic + currentAlter) < 0) {
                                chromIndex += 12;
                                --octavebyChrom;
                            }
                            if (11 < chromIndex) {
                                chromIndex -= 12;
                                ++octavebyChrom;
                            }
                            aStep = chrom[chromIndex];
                        }
                        int octave = Integer.valueOf(aDomPitch.getChildTextTrim("octave")) + octavebyChrom;
                        int alter = 0;
                        if (currentAttr.getChromatic() == 0) {
                            if (aDomPitch.getChild("alter") != null) {
                                alter = Integer.valueOf(aDomPitch.getChildTextTrim("alter"));
                            }
                        } else if (chromIndex == 1 || chromIndex == 3 || chromIndex == 6 || chromIndex == 8 || chromIndex == 10) {
                            alter = 1;
                        }
                        mxNote.setOctave_base(octave);
                        mxNote.setOctave_width(0);
                        mxNote.setAlter(alter);
                        mxNote.setStep(new String(aStep));
                        if (aDomContain.getChild("accidental") != null) {
                            mxNote.setAccidental(aDomContain.getChildTextTrim("accidental"));
                        }
                        if (aDomContain.getChild("stem") != null) {
                            mxNote.setStem(aDomContain.getChildTextTrim("stem"));
                        }
                        if (!(l = aDomContain.getChildren("beam")).isEmpty()) {
                            for (Element e : l) {
                                if (e.getAttributeValue("number") == "1") {
                                    mxNote.setBeam1(e.getTextTrim());
                                }
                                if (e.getAttributeValue("number") != "2") continue;
                                mxNote.setBeam2(e.getTextTrim());
                            }
                        }
                    } else if (aDomContain.getChild("rest") != null) {
                        mxNote.setRest(true);
                        if (lastRest != null) {
                            if (lastRest.rest) {
                                --notec;
                            }
                        } else if (aDomMeasure.getChild("attributes") != null && lastAdded != 0.0 && lastNote != null) {
                            --notec;
                        }
                        lastRest = mxNote;
                    } else {
                        lastRest = null;
                    }
                    if (aDomContain.getChild("duration") != null) {
                        lastAdded = Double.valueOf(aDomContain.getChildTextTrim("duration")) / (double)currentAttr.getDivisions();
                        mxNote.setDuration(lastAdded);
                        counterInMeasure += lastAdded;
                    }
                    if (aDomContain.getChild("voice") != null) {
                        mxNote.setVoiceTag(aDomContain.getChildTextTrim("voice"));
                    }
                    if (aDomContain.getChild("type") != null) {
                        mxNote.setType(aDomContain.getChildTextTrim("type"));
                    }
                    if (aDomContain.getChild("tie") == null) continue;
                    mxNote.setTie(aDomContain.getChild("tie").getAttributeValue("type"));
                    if (mxNote.getTie().equals("stop")) continue;
                    lastNote = mxNote;
                }
                absTimeCounter = aDomMeasure.getAttributeValue("implicit") != null ? (aDomMeasure.getAttributeValue("implicit").compareToIgnoreCase("yes") == 0 ? (absTimeCounter += counterInMeasure) : (absTimeCounter += (double)currentAttr.getTimeBeats() * 4.0 / (double)currentAttr.getTimeBeatType())) : (absTimeCounter += (double)currentAttr.getTimeBeats() * 4.0 / (double)currentAttr.getTimeBeatType());
                mxMeasure.setAttribute(currentAttr);
            }
            mxPart.getNoteStartTimeSet().addAll(partNotes);
            mxPart.getNoteEndTimeSet().addAll(partNotes);
            currentAttr.setChromatic(0);
            allNotes.addAll(partNotes);
        }
        this.getNoteStartTimeSet().addAll(allNotes);
        this.getNoteEndTimeSet().addAll(allNotes);
    }

    public Set getNotesInRange(double startAbsTime, double endAbsTime) {
        Note anns = new Note();
        Note anne = new Note();
        anns.setAbsoluteTime(startAbsTime);
        anne.setAbsoluteTime(endAbsTime);
        HashSet aSet = new HashSet(this.getNoteStartTimeSet());
        aSet.removeAll(this.getNoteStartTimeSet().tailSet(anne));
        aSet.removeAll(this.getNoteEndTimeSet().headSet(anns));
        return aSet;
    }

    public Set getMeasuresInRange(double startAbsTime, double endAbsTime) {
        Measure amms = new Measure();
        Measure amme = new Measure();
        amms.setAbsoluteTime(startAbsTime);
        amme.setAbsoluteTime(endAbsTime);
        return this.getMeasureSet().subSet(amms, amme);
    }

    public int getHighestNoteNumber() {
        TreeSet notenumberOrder = new TreeSet(this.getNoteStartTimeSet());
        return ((Note)notenumberOrder.last()).getNoteNumber() % 1200;
    }

    public int getLowestNoteNumber() {
        TreeSet notenumberOrder = new TreeSet(this.getNoteStartTimeSet());
        return ((Note)notenumberOrder.first()).getNoteNumber() % 1200;
    }

    public double getAverageNoteNumber() {
        Iterator nsi = this.getNoteStartTimeSet().iterator();
        double nnn = 0.0;
        while (nsi.hasNext()) {
            Note ndd = (Note)nsi.next();
            nnn += (double)(ndd.getNoteNumber() % 1200);
        }
        return nnn / (double)this.getNoteStartTimeSet().size();
    }

    public int getNumberOfNotes() {
        return this.getNoteStartTimeSet().size();
    }

    public double getLastNoteTime() {
        return ((Note)this.getNoteStartTimeSet().last()).getAbsoluteTime();
    }

    public double getLastMeasureNumber() {
        return ((Measure)this.getMeasureSet().last()).getNumber();
    }

    public Document exportMusicXmlDocument() {
        return this.exportMusicXmlDocument(true, null);
    }

    public Document exportMusicXmlDocument(boolean allParts, Hashtable<String, String> choices) {
        String newID;
        String oldID;
        boolean exportThisPart;
        Part apar;
        Element rootElement = new Element("score-partwise");
        Element identification = new Element("identification");
        Element encoding = new Element("encoding");
        Element software = new Element("software");
        software.addContent("Music Resonator");
        encoding.addContent(software);
        identification.addContent(encoding);
        rootElement.addContent(identification);
        Element partList = new Element("part-list");
        Enumeration<Part> parts = this.parts.elements();
        while (parts.hasMoreElements()) {
            apar = parts.nextElement();
            exportThisPart = allParts || apar.getVoice().isEdit();
            newID = oldID = apar.getPartID();
            if (choices != null) {
                newID = choices.get(oldID);
                boolean bl = exportThisPart = newID != null;
            }
            if (!exportThisPart) continue;
            Element scorePart = new Element("score-part");
            scorePart.setAttribute("id", newID);
            Element partName = new Element("part-name");
            partName.addContent("MusicXML Part");
            scorePart.addContent(partName);
            Element scoreInstrument = new Element("score-instrument");
            scoreInstrument.setAttribute("id", newID + "-I1");
            Element instrumentName = new Element("instrument-name");
            instrumentName.addContent("instrument 1");
            scoreInstrument.addContent(instrumentName);
            scorePart.addContent(scoreInstrument);
            Element midiInstrument = new Element("midi-instrument");
            midiInstrument.setAttribute("id", newID + "-I1");
            Element midiChannel = new Element("midi-channel");
            midiChannel.addContent("" + apar.getMidiChannel());
            midiInstrument.addContent(midiChannel);
            Element midiProgram = new Element("midi-program");
            midiProgram.addContent("" + apar.getMidiProgram());
            midiInstrument.addContent(midiProgram);
            scorePart.addContent(midiInstrument);
            partList.addContent(scorePart);
        }
        rootElement.addContent(partList);
        parts = this.parts.elements();
        while (parts.hasMoreElements()) {
            apar = parts.nextElement();
            exportThisPart = allParts || apar.getVoice().isEdit();
            newID = oldID = apar.getPartID();
            if (choices != null) {
                newID = choices.get(oldID);
                boolean bl = exportThisPart = newID != null;
            }
            if (!exportThisPart) continue;
            Element part = new Element("part");
            part.setAttribute("id", newID);
            Attributes lastAttr = null;
            Iterator meii = apar.getMeasures().iterator();
            double absoluteTime = 0.0;
            Element lastMeasure = null;
            while (meii.hasNext()) {
                double restTime;
                Measure ameas = (Measure)meii.next();
                Element measure = new Element("measure");
                measure.setAttribute("number", "" + ameas.getNumber());
                if (ameas.getImplicit() != null && !ameas.getImplicit().isEmpty()) {
                    measure.setAttribute("implicit", "yes");
                }
                if (!ameas.getAttribute().equals(lastAttr)) {
                    lastAttr = ameas.getAttribute();
                    Element attributes = new Element("attributes");
                    Element divisions = new Element("divisions");
                    divisions.addContent("" + lastAttr.getDivisions());
                    attributes.addContent(divisions);
                    Element key = new Element("key");
                    Element fifths = new Element("fifths");
                    fifths.addContent("" + lastAttr.getKeyFifth());
                    key.addContent(fifths);
                    Element mode = new Element("mode");
                    mode.addContent(lastAttr.isKeyMode() ? "major" : "minor");
                    key.addContent(mode);
                    attributes.addContent(key);
                    Element time = new Element("time");
                    Element beats = new Element("beats");
                    beats.addContent("" + lastAttr.getTimeBeats());
                    time.addContent(beats);
                    Element beatType = new Element("beat-type");
                    beatType.addContent("" + lastAttr.getTimeBeatType());
                    time.addContent(beatType);
                    attributes.addContent(time);
                    Element clef = new Element("clef");
                    Element sign = new Element("sign");
                    sign.addContent("G");
                    clef.addContent(sign);
                    Element line = new Element("line");
                    line.addContent("2");
                    clef.addContent(line);
                    attributes.addContent(clef);
                    measure.addContent(attributes);
                }
                Iterator noiii = ameas.getNotes().iterator();
                if (lastMeasure != null && absoluteTime != ameas.getAbsoluteTime() && (restTime = ameas.getAbsoluteTime() - absoluteTime) > 1.0E-13) {
                    Element rest = new Element("note");
                    rest.addContent(new Element("rest"));
                    Element duration = new Element("duration");
                    double cleanRestTime = (double)Math.round(restTime * (double)lastAttr.getDivisions() * 32.0) / 32.0;
                    duration.addContent("" + cleanRestTime);
                    rest.addContent(duration);
                    lastMeasure.addContent(rest);
                }
                absoluteTime = ameas.getAbsoluteTime();
                while (noiii.hasNext()) {
                    Note anot = (Note)noiii.next();
                    if (absoluteTime != anot.getAbsoluteTime()) {
                        double restTime2 = anot.getAbsoluteTime() - absoluteTime;
                        if (restTime2 > 1.0E-13) {
                            Element rest = new Element("note");
                            rest.addContent(new Element("rest"));
                            Element duration = new Element("duration");
                            double cleanRestTime = (double)Math.round(restTime2 * (double)lastAttr.getDivisions() * 32.0) / 32.0;
                            duration.addContent("" + cleanRestTime);
                            rest.addContent(duration);
                            measure.addContent(rest);
                        }
                        absoluteTime += restTime2;
                    }
                    Element note = new Element("note");
                    if (!anot.getRest()) {
                        Element pitch = new Element("pitch");
                        Element step = new Element("step");
                        step.addContent(anot.getStep());
                        pitch.addContent(step);
                        if (anot.getAlter() != 0) {
                            Element alter = new Element("alter");
                            alter.addContent("" + anot.getAlter());
                            pitch.addContent(alter);
                        }
                        Element octave = new Element("octave");
                        octave.addContent("" + anot.getOctave_base());
                        pitch.addContent(octave);
                        note.addContent(pitch);
                    } else {
                        note.addContent(new Element("rest"));
                    }
                    Element duration = new Element("duration");
                    duration.addContent("" + anot.getDuration() * (double)lastAttr.getDivisions());
                    note.addContent(duration);
                    if (anot.getVoiceTag() != null) {
                        Element voice = new Element("voice");
                        voice.addContent(anot.getVoiceTag());
                        note.addContent(voice);
                    }
                    if (anot.getType() != null) {
                        Element type = new Element("type");
                        type.addContent(anot.getType());
                        note.addContent(type);
                    }
                    if (!anot.getRest()) {
                        Element beam;
                        if (anot.getAccidental() != null) {
                            Element accidental = new Element("accidental");
                            accidental.addContent(anot.getAccidental());
                            note.addContent(accidental);
                        }
                        if (anot.getStem() != null) {
                            Element stem = new Element("stem");
                            stem.addContent(anot.getStem());
                            note.addContent(stem);
                        }
                        if (anot.getTie() != null) {
                            Element tie = new Element("tie");
                            tie.setAttribute("type", "" + anot.getTie());
                            note.addContent(tie);
                        }
                        if (anot.getBeam1() != null) {
                            beam = new Element("beam");
                            beam.getAttributeValue("number", "1");
                            beam.addContent(anot.getBeam1());
                            note.addContent(beam);
                        }
                        if (anot.getBeam2() != null) {
                            beam = new Element("beam");
                            beam.getAttributeValue("number", "2");
                            beam.addContent(anot.getBeam2());
                            note.addContent(beam);
                        }
                    }
                    measure.addContent(note);
                    absoluteTime += anot.getDuration();
                }
                part.addContent(measure);
                lastMeasure = measure;
            }
            rootElement.addContent(part);
        }
        return new Document(rootElement);
    }

    public void setParts(Hashtable parts) {
        this.parts = parts;
    }

    public Hashtable getParts() {
        return this.parts;
    }

    public void setNoteStartTimeSet(TreeSet noteStartTimeSet) {
        this.noteStartTimeSet = noteStartTimeSet;
    }

    public TreeSet getNoteStartTimeSet() {
        return this.noteStartTimeSet;
    }

    public void setNoteEndTimeSet(TreeSet noteEndTimeSet) {
        this.noteEndTimeSet = noteEndTimeSet;
    }

    public TreeSet getNoteEndTimeSet() {
        return this.noteEndTimeSet;
    }

    public void setMeasureSet(TreeSet measureSet) {
        this.measureSet = measureSet;
    }

    public TreeSet getMeasureSet() {
        return this.measureSet;
    }

    public TreeSet getNoteStartTimeSet(String voiceID) {
        if (this.parts.get(voiceID) == null) {
            return null;
        }
        return this.parts.get(voiceID).getNoteStartTimeSet();
    }

    public TreeSet getNoteEndTimeSet(String voiceID) {
        if (this.parts.get(voiceID) == null) {
            return null;
        }
        return this.parts.get(voiceID).getNoteEndTimeSet();
    }

    public TreeSet getMeasureSet(String voiceID) {
        if (this.parts.get(voiceID) == null) {
            return null;
        }
        return this.parts.get(voiceID).getMeasureSet();
    }
}

