/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model.MusicXML;

import com.dacreation.GTTM.Model.MusicXML.Measure;
import com.dacreation.GTTM.Model.MusicXML.MusicXML;
import com.dacreation.GTTM.Model.MusicXML.TimeInterface;
import com.dacreation.gttmeditor.Voices;
import java.io.Serializable;

public class Note
implements Comparable,
Serializable,
TimeInterface {
    private static final long serialVersionUID = 1L;
    static final String[] stepArray = new String[]{"C", "C", "D", "D", "E", "F", "F", "G", "G", "A", "A", "B"};
    public static final int NOTE_OCTAVE_TOP = 100;
    private String idName;
    private Measure parent;
    private double at;
    private double absoluteTime;
    private int octave_base;
    private int octave_width;
    private int alter;
    private String step;
    private String tie;
    private double duration = 0.0;
    private int velocity = 90;
    private Voices.Voice voice;
    boolean rest;
    String voiceTag;
    String type;
    String accidental;
    String stem;
    String beam1;
    String beam2;
    private MusicXML root;

    public Voices.Voice getVoice() {
        return this.voice;
    }

    public void setVoice(Voices.Voice voice) {
        this.voice = voice;
    }

    protected void finalize() throws Throwable {
        this.setParent(null);
        this.setIdName(null);
        super.finalize();
    }

    public void setByNoteNumber(int nn) {
        this.setOctave_base(nn % 1200 / 12 - 1);
        this.setOctave_width(nn / 1200);
        int stepNumber = nn % 12;
        this.setStep(stepArray[stepNumber]);
        this.setAlter(stepNumber == 1 || stepNumber == 3 || stepNumber == 6 || stepNumber == 8 || stepNumber == 10 ? 1 : 0);
    }

    public int getNoteNumber() {
        if (this.getStep() == null) {
            return 0;
        }
        if (this.getOctave_width() == 0) {
            return (this.getOctave_base() + 1) * 12 + this.getStepArrayIndex(this.getStep()) + this.getAlter();
        }
        return (this.getOctave_base() + 1) * 12 + this.getStepArrayIndex(this.getStep()) + this.getAlter() + 1200 * this.getOctave_width();
    }

    private int getStepArrayIndex(String str) {
        int length = stepArray.length;
        for (int i = 0; i < length; ++i) {
            if (!stepArray[i].equals(str)) continue;
            return i;
        }
        return -1;
    }

    public int compareTo(Object obj) {
        Note n1 = (Note)obj;
        return this.getNoteNumber() % 1200 - n1.getNoteNumber() % 1200 == 0 ? -1 : this.getNoteNumber() % 1200 - n1.getNoteNumber() % 1200;
    }

    public Note() {
    }

    public Note(Note source) {
        this.setAt(source.getAt());
        this.setAbsoluteTime(source.getAbsoluteTime());
        this.setOctave_base(source.getOctave_base());
        this.setOctave_width(source.getOctave_width());
        this.setAlter(source.getAlter());
        this.setStep(new String(source.getStep()));
        this.setDuration(source.getDuration());
        this.setVelocity(source.getVelocity());
        this.setIdName(new String(source.getIdName()));
        this.setVoice(source.getVoice());
    }

    public Note getConcreteNote(Note aNote) {
        int bnn;
        Note mcNote = null;
        int ann = this.getNoteNumber();
        if (ann == (bnn = aNote.getNoteNumber())) {
            mcNote = new Note();
            mcNote.setStep(new String(this.getStep()));
            mcNote.setAlter(this.alter);
            mcNote.setOctave_base(this.octave_base);
            mcNote.setOctave_width(this.octave_width);
        } else if (ann % 12 == bnn % 12) {
            if (this.getOctave_width() <= aNote.getOctave_width()) {
                if (aNote.getOctave_base() <= this.getOctave_base() && this.getOctave_base() + this.getOctave_width() <= aNote.getOctave_base() + aNote.getOctave_width() || aNote.getOctave_width() == 100) {
                    mcNote = new Note();
                    mcNote.setStep(new String(this.getStep()));
                    mcNote.setAlter(this.alter);
                    mcNote.setOctave_base(this.octave_base);
                    mcNote.setOctave_width(this.octave_width);
                }
            } else if (this.getOctave_width() > aNote.getOctave_width() && (this.getOctave_base() <= aNote.getOctave_base() && aNote.getOctave_base() + aNote.getOctave_width() <= this.getOctave_base() + this.getOctave_width() || this.getOctave_width() == 100)) {
                mcNote = new Note();
                mcNote.setStep(new String(this.getStep()));
                mcNote.setAlter(this.alter);
                mcNote.setOctave_base(aNote.getOctave_base());
                mcNote.setOctave_width(aNote.getOctave_width());
            }
        }
        if (mcNote != null) {
            mcNote.setDuration(this.getDuration() > aNote.getDuration() ? this.getDuration() : aNote.getDuration());
            mcNote.setVelocity(this.getVelocity() > aNote.getVelocity() ? this.getVelocity() : aNote.getVelocity());
        }
        return mcNote;
    }

    public Note lubNote(Note aNote) {
        int bnn;
        Note lubNote = null;
        int ann = this.getNoteNumber();
        if (ann == (bnn = aNote.getNoteNumber())) {
            lubNote = new Note();
            lubNote.setStep(new String(this.getStep()));
            lubNote.setAlter(this.alter);
            lubNote.setOctave_base(this.octave_base);
            lubNote.setOctave_width(this.octave_width);
        } else if (ann % 12 == bnn % 12) {
            lubNote = new Note();
            lubNote.setStep(new String(this.getStep()));
            lubNote.setAlter(this.alter);
            if (this.getOctave_width() == 100 || aNote.getOctave_width() == 100) {
                lubNote.setOctave_base(4);
                lubNote.setOctave_width(100);
            } else if (this.getOctave_base() - 1 <= aNote.getOctave_base() && aNote.getOctave_base() <= this.getOctave_base() + this.getOctave_width() + 1 || aNote.getOctave_base() - 1 <= this.getOctave_base() && this.getOctave_base() <= aNote.getOctave_base() + aNote.getOctave_width() + 1) {
                lubNote.setOctave_base(this.getOctave_base() < aNote.getOctave_base() ? this.getOctave_base() : aNote.getOctave_base());
                lubNote.setOctave_width(this.getOctave_base() + this.getOctave_width() > aNote.getOctave_base() + aNote.getOctave_width() ? this.getOctave_base() + this.getOctave_width() - lubNote.getOctave_base() : aNote.getOctave_base() + aNote.getOctave_width() - lubNote.getOctave_base());
            } else {
                lubNote.setOctave_base(4);
                lubNote.setOctave_width(100);
            }
        }
        if (lubNote != null) {
            lubNote.setDuration(this.getDuration() < aNote.getDuration() ? this.getDuration() : aNote.getDuration());
            lubNote.setVelocity(this.getVelocity() > aNote.getVelocity() ? this.getVelocity() : aNote.getVelocity());
        }
        return lubNote;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setParent(Measure parent) {
        this.parent = parent;
    }

    public Measure getParent() {
        return this.parent;
    }

    public void setAt(double at) {
        this.at = at;
    }

    public double getAt() {
        return this.at;
    }

    public void setAbsoluteTime(double absoluteTime) {
        this.absoluteTime = absoluteTime;
    }

    @Override
    public double getAbsoluteTime() {
        return this.absoluteTime;
    }

    public void setOctave_base(int octave_base) {
        this.octave_base = octave_base;
    }

    public int getOctave_base() {
        return this.octave_base;
    }

    public void setOctave_width(int octave_width) {
        this.octave_width = octave_width;
    }

    public int getOctave_width() {
        return this.octave_width;
    }

    public void setAlter(int alter) {
        this.alter = alter;
    }

    public int getAlter() {
        return this.alter;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public String getStep() {
        return this.step;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setRoot(MusicXML root) {
        this.root = root;
    }

    public MusicXML getRoot() {
        return this.root;
    }

    boolean getRest() {
        return this.rest;
    }

    String getVoiceTag() {
        return this.voiceTag;
    }

    String getType() {
        return this.type;
    }

    public String getTie() {
        return this.tie;
    }

    String getAccidental() {
        return this.accidental;
    }

    String getStem() {
        return this.stem;
    }

    String getBeam1() {
        return this.beam1;
    }

    String getBeam2() {
        return this.beam2;
    }

    public void setAccidental(String accidental) {
        this.accidental = accidental;
    }

    public void setBeam1(String beam1) {
        this.beam1 = beam1;
    }

    public void setBeam2(String beam2) {
        this.beam2 = beam2;
    }

    public void setRest(boolean rest) {
        this.rest = rest;
    }

    public void setStem(String stem) {
        this.stem = stem;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVoiceTag(String voiceTag) {
        this.voiceTag = voiceTag;
    }

    public void setTie(String tie) {
        this.tie = tie;
    }
}

