/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model.MusicXML;

import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class NotePlayer {
    Sequencer mySequencer;
    MidiDevice asm;

    protected void finalize() throws Throwable {
        if (this.mySequencer != null) {
            this.mySequencer.close();
        }
        this.mySequencer = null;
        super.finalize();
    }

    public NotePlayer() {
        try {
            this.mySequencer = MidiSystem.getSequencer();
            this.asm = MidiSystem.getSynthesizer();
        }
        catch (Exception ex) {
            this.mySequencer = null;
        }
    }

    public List getDeviceList() {
        ArrayList<MidiDevice.Info> al = new ArrayList<MidiDevice.Info>();
        MidiDevice.Info[] a = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < a.length; ++i) {
            try {
                MidiSystem.getMidiDevice(a[i]).getReceiver();
                al.add(a[i]);
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
        return al;
    }

    public void setDevice(Object o) {
        this.stop();
        try {
            this.mySequencer = MidiSystem.getSequencer();
            this.asm = MidiSystem.getMidiDevice((MidiDevice.Info)o);
            this.mySequencer.getTransmitter().setReceiver(this.asm.getReceiver());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Sequence buildSequence(Set noteSet, int tempo) throws Exception {
        if (noteSet == null) {
            return null;
        }
        if (noteSet.size() == 0) {
            return null;
        }
        TreeSet noteListStartOrder = new TreeSet(new StartTimeComparator());
        noteListStartOrder.addAll(noteSet);
        Sequence aseq = new Sequence(0.0f, 960);
        Track aTrack = aseq.createTrack();
        Iterator ani = noteListStartOrder.iterator();
        double startTime = ((Note)ani.next()).getAbsoluteTime();
        for (Note ann : noteListStartOrder) {
            ShortMessage mySm;
            tempo = ann.getParent().getAttribute().getTempo();
            if (ann.getNoteNumber() < 1200) {
                mySm = new ShortMessage();
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, ann.getVelocity());
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
                mySm = new ShortMessage();
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
                continue;
            }
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, ann.getVelocity());
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200 + 12, ann.getVelocity());
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200 + 12, 0);
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
        }
        return aseq;
    }

    private Sequence buildSpecialSequence(Set noteSet, int tempo, double delay) throws Exception {
        if (noteSet == null) {
            return null;
        }
        if (noteSet.size() == 0) {
            return null;
        }
        TreeSet noteListStartOrder = new TreeSet(new StartTimeComparator());
        noteListStartOrder.addAll(noteSet);
        Sequence aseq = new Sequence(0.0f, 960);
        Track aTrack = aseq.createTrack();
        Iterator ani = noteListStartOrder.iterator();
        double startTime = ((Note)ani.next()).getAbsoluteTime();
        for (Note ann : noteListStartOrder) {
            ShortMessage mySm;
            tempo = ann.getParent().getAttribute().getTempo();
            if (ann.getNoteNumber() < 1200) {
                mySm = new ShortMessage();
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, ann.getVelocity());
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
                mySm = new ShortMessage();
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
                if ((int)((double)ann.getVelocity() * 0.4) > 0) {
                    mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, (int)((double)ann.getVelocity() * 0.3));
                    aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime + delay) * 960.0)));
                    mySm = new ShortMessage();
                    mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
                    aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime + delay) * 960.0)));
                }
                if ((int)((double)ann.getVelocity() * 0.3) <= 0) continue;
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, (int)((double)ann.getVelocity() * 0.2));
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime + delay * 2.0) * 960.0)));
                mySm = new ShortMessage();
                mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
                aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime + delay * 2.0) * 960.0)));
                continue;
            }
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, ann.getVelocity());
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200 + 12, ann.getVelocity());
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200, 0);
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
            mySm = new ShortMessage();
            mySm.setMessage(144, 1, ann.getNoteNumber() % 1200 + 12, 0);
            aTrack.add(new MidiEvent(mySm, (long)((ann.getAbsoluteTime() + ann.getDuration() - startTime) * 960.0)));
        }
        return aseq;
    }

    public void playNoteSet(Set noteSet) {
        try {
            this.stop();
            this.mySequencer = MidiSystem.getSequencer();
            this.mySequencer.getTransmitter().setReceiver(this.asm.getReceiver());
            if (!this.mySequencer.isOpen()) {
                this.mySequencer.open();
            }
            if (!this.asm.isOpen()) {
                this.asm.open();
            }
            if (this.mySequencer == null) {
                return;
            }
            this.mySequencer.getTransmitter().setReceiver(this.asm.getReceiver());
            Sequence aseq = this.buildSequence(noteSet, 120);
            if (aseq == null) {
                return;
            }
            this.mySequencer.setSequence(aseq);
            this.mySequencer.setMasterSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
            this.mySequencer.setSlaveSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
            this.mySequencer.setTempoInBPM(120.0f);
            this.mySequencer.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void playNoteSetSuper(Set noteSet, int tempo, double delay) {
        try {
            this.mySequencer = MidiSystem.getSequencer();
            this.mySequencer.getTransmitter().setReceiver(this.asm.getReceiver());
            if (!this.mySequencer.isOpen()) {
                this.mySequencer.open();
            }
            if (!this.asm.isOpen()) {
                this.asm.open();
            }
            if (this.mySequencer == null) {
                return;
            }
            this.mySequencer.getTransmitter().setReceiver(this.asm.getReceiver());
            Sequence aseq = this.buildSpecialSequence(noteSet, tempo, delay);
            if (aseq == null) {
                return;
            }
            this.mySequencer.setSequence(aseq);
            this.mySequencer.setMasterSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
            this.mySequencer.setSlaveSyncMode(Sequencer.SyncMode.INTERNAL_CLOCK);
            this.mySequencer.setTempoInBPM(tempo);
            this.mySequencer.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void changeTempo(int tempo) {
        if (this.mySequencer != null) {
            this.mySequencer.setTempoInBPM(tempo);
        }
    }

    public void exportNoteSetToSMF(File aFile, Set noteSet, int tempo) {
        try {
            Sequence aseq = this.buildSequence(noteSet, tempo);
            if (aseq == null) {
                return;
            }
            MidiSystem.write(aseq, 0, aFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void stop() {
        if (this.mySequencer == null) {
            return;
        }
        if (this.mySequencer.isRunning()) {
            this.mySequencer.stop();
        }
        if (this.mySequencer.isOpen()) {
            this.mySequencer.close();
        }
        if (this.asm.isOpen()) {
            this.asm.close();
        }
        try {
            this.mySequencer.getTransmitter().setReceiver(null);
        }
        catch (MidiUnavailableException ex) {
            Logger.getLogger(NotePlayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

