/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MXML;
import com.dacreation.GTTM.Model.MusicXML.MusicXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.PRTree.PRNode;
import com.dacreation.GTTM.Model.Profile;
import java.io.Reader;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;

public class PR
extends MRObject {
    private PRNode rootPrNode;
    private boolean newDataAsBranch = false;

    public PR(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
    }

    public PR(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
    }

    public PR(Profile pr) throws Exception {
        super(pr);
        this.MRDocument.setRootElement(new Element("prtree"));
    }

    public PR(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        PR source = (PR)sourcex;
        if (source != null) {
            this.setRootPrNode(this.copyIntoPR(source.getRootPrNode()));
        } else {
            this.setRootPrNode(new PRNode());
            PRNode primary = new PRNode();
            PRNode secondary = new PRNode();
            MusicXML am = this.parent.getMXML().getContent();
            Note pn = (Note)am.getNoteStartTimeSet().last();
            primary.setHead(pn);
            this.anyToElement.put(pn.getIdName(), primary);
            Note sn = (Note)am.getNoteStartTimeSet().first();
            secondary.setHead(sn);
            this.anyToElement.put(sn.getIdName(), secondary);
            this.getRootPrNode().setChildren(primary, secondary, 0);
        }
    }

    @Override
    String getRootTagName() {
        return "prtree";
    }

    @Override
    public void setupMRObject() {
        this.setRootPrNode(this.parsePR(this.MRDocument.getRootElement().getChild("pr")));
        if (this.getRootPrNode() != null) {
            // empty if block
        }
    }

    public PRNode parsePR(Element anEl) {
        Element as;
        if (anEl == null) {
            return null;
        }
        Element aHead = anEl.getChild("head");
        PRNode pri = null;
        PRNode sec = null;
        Element ap = anEl.getChild("primary");
        if (ap != null) {
            pri = this.parsePR(ap.getChild("pr"));
        }
        if ((as = anEl.getChild("secondary")) != null) {
            sec = this.parsePR(as.getChild("pr"));
        }
        if (pri == null && sec == null) {
            if (aHead != null) {
                PRNode leafNode = new PRNode();
                for (Element nniiee : aHead.getChild("chord").getChildren("note")) {
                    String id = nniiee.getAttributeValue("id");
                    MXML am = this.parent.getMXML();
                    Note aNote = am.getNoteFromID(id);
                    if (aNote == null) continue;
                    leafNode.addHead(aNote);
                    this.anyToElement.put(aNote.getIdName(), leafNode);
                }
                return leafNode;
            }
        } else {
            PRNode aPr = new PRNode();
            String headRecipe = "";
            if (aHead != null) {
                headRecipe = aHead.getAttributeValue("recipe");
            }
            if (headRecipe == null) {
                headRecipe = "progression";
            }
            int recipe = 0;
            String[] recipeString = PRNode.getRecipeString();
            for (int a = 0; a < 3; ++a) {
                if (headRecipe.compareTo(recipeString[a]) != 0) continue;
                recipe = a;
                break;
            }
            aPr.setChildren(pri, sec, recipe);
            if (anEl.getAttributeValue("hide") != null) {
                aPr.setLock(true);
            }
            return aPr;
        }
        return null;
    }

    private PRNode copyIntoPR(PRNode source) {
        PRNode as;
        if (source == null) {
            return null;
        }
        PRNode pri = null;
        PRNode sec = null;
        PRNode ap = source.getPrimary();
        if (ap != null) {
            pri = this.copyIntoPR(ap);
        }
        if ((as = source.getSecondary()) != null) {
            sec = this.copyIntoPR(as);
        }
        if (pri == null && sec == null) {
            PRNode leafNode = new PRNode();
            for (Note aNote : source.getHead()) {
                MXML am = this.parent.getMXML();
                Note bNote = am.getNoteFromID(aNote.getIdName());
                leafNode.addHead(bNote);
                this.anyToElement.put(bNote.getIdName(), leafNode);
            }
            return leafNode;
        }
        PRNode aPr = new PRNode();
        int recipe = source.getHeadRecipe();
        aPr.setChildren(pri, sec, recipe);
        aPr.setLock(source.getDepth() == 1);
        return aPr;
    }

    public void addAsSecondaryBranch(PRNode source) {
        PRNode copy = this.copyIntoPR(source);
        this.getRootPrNode().setSecondaryChild(copy, 0);
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = new Document();
        Element rpr = new Element("prtree");
        rpr.setContent(this.getRootPrNode().makeJDOMElement());
        this.MRDocument.setRootElement(rpr);
    }

    public void setRootPrNode(PRNode rootPrNode) {
        this.rootPrNode = rootPrNode;
    }

    public PRNode getRootPrNode() {
        return this.rootPrNode;
    }

    public URL getURL() {
        return this.MRURL;
    }

    public boolean isNewDataAsBranch() {
        return this.newDataAsBranch;
    }

    public void setNewDataAsBranch(boolean newDataAsBranch) {
        this.newDataAsBranch = newDataAsBranch;
    }

    public void shiftRoot() {
        PRNode root = this.getRootPrNode();
        PRNode newRoot = new PRNode();
        newRoot.setChildren(root, null, 0);
        this.setRootPrNode(newRoot);
    }
}

