/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model.PRTree;

import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Element;

public class PRNode {
    protected TreeSet head = new TreeSet(new StartTimeComparator());
    protected int headRecipe;
    public static final int PROGRESSION = 0;
    public static final int WEAK = 1;
    public static final int STRONG = 2;
    private static final String[] recipeString = new String[]{"progression", "weak", "strong"};
    public static final PRNode PLNode_TOP = new PRNode();
    protected PRNode primary;
    protected PRNode secondary;
    protected PRNode parent;
    int priSec;
    int depth;
    protected Set ancestor = new HashSet();
    protected TreeSet discendantNotes = new TreeSet(new StartTimeComparator());
    protected Note theHead;

    protected void finalize() throws Throwable {
        this.parent = null;
        this.primary = null;
        this.secondary = null;
        this.head = null;
        this.ancestor = null;
        this.discendantNotes = null;
        super.finalize();
    }

    public PRNode lub(PRNode targetNode) {
        PRNode newNode = this.getLUB(targetNode);
        return newNode;
    }

    /*
     * WARNING - void declaration
     */
    private PRNode getLUB(PRNode targetNode) {
        void var8_13;
        PRNode lubNode = new PRNode();
        Set aaHeads = this.getHead();
        Set bHeads = targetNode.getHead();
        Set<Note> tempHeads = new HashSet();
        for (Note aNote : aaHeads) {
            for (Note bNote : bHeads) {
                Note lNote = aNote.lubNote(bNote);
                if (lNote == null) continue;
                tempHeads.add(lNote);
            }
        }
        tempHeads = this.concreteChord(tempHeads);
        lubNode.head.clear();
        lubNode.head.addAll(tempHeads);
        for (Note note : tempHeads) {
        }
        Object var8_11 = null;
        PRNode tmpsec = null;
        if (this.primary != null && targetNode.getPrimary() != null) {
            PRNode pRNode = this.primary.getLUB(targetNode.getPrimary());
        }
        if (this.secondary != null && targetNode.getSecondary() != null) {
            tmpsec = this.secondary.getLUB(targetNode.getSecondary());
        }
        lubNode.setChildren((PRNode)var8_13, tmpsec, this.headRecipe < targetNode.headRecipe ? this.headRecipe : targetNode.headRecipe);
        return lubNode;
    }

    private Set concreteChord(Collection tempHeads) {
        int i = tempHeads.size();
        while (i > 0) {
            if (tempHeads.size() < 2) {
                return new HashSet(tempHeads);
            }
            ArrayList tempHeads2 = new ArrayList(tempHeads);
            ArrayList<Note> tempHeads3 = new ArrayList<Note>();
            Iterator thi2 = tempHeads2.iterator();
            Note aNote = (Note)thi2.next();
            tempHeads2.remove(aNote);
            thi2 = tempHeads2.iterator();
            boolean concretedANote = false;
            while (thi2.hasNext()) {
                Note tNote = (Note)thi2.next();
                Note cNote = aNote.getConcreteNote(tNote);
                if (cNote != null) {
                    tempHeads3.add(cNote);
                    concretedANote = true;
                    continue;
                }
                tempHeads3.add(tNote);
            }
            if (!concretedANote) {
                tempHeads3.add(aNote);
                --i;
            } else {
                i = tempHeads3.size();
            }
            tempHeads = tempHeads3;
        }
        return new HashSet(tempHeads);
    }

    public int countNodes() {
        int counter = 1;
        if (this.primary != null) {
            counter += this.primary.countNodes();
        }
        if (this.secondary != null) {
            counter += this.secondary.countNodes();
        }
        return counter;
    }

    public int countValidHeads() {
        int counter = 0;
        if (this.head.size() > 0) {
            ++counter;
        } else {
            return counter;
        }
        if (this.primary != null) {
            counter += this.primary.countValidHeads();
        }
        if (this.secondary != null) {
            counter += this.secondary.countValidHeads();
        }
        return counter;
    }

    public Set getHead() {
        return this.head;
    }

    public boolean isPrimary() {
        return this.priSec == 1;
    }

    public boolean isSecondary() {
        return this.priSec == 2;
    }

    public boolean isLeaf() {
        return this.primary == null && this.secondary == null;
    }

    public PRNode getPrimary() {
        return this.primary;
    }

    public PRNode getSecondary() {
        return this.secondary;
    }

    public int getHeadRecipe() {
        return this.headRecipe;
    }

    public void setChildren(PRNode pri, PRNode sec, int recipe) {
        this.primary = pri;
        this.secondary = sec;
        this.headRecipe = recipe;
        if (this.primary != null) {
            this.primary.setParent(this);
            this.primary.setPriSec(1);
        }
        if (this.secondary != null) {
            this.secondary.setParent(this);
            this.secondary.setPriSec(2);
        }
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void setSecondaryChild(PRNode sec, int recipe) {
        this.secondary = sec;
        this.headRecipe = recipe;
        if (this.secondary != null) {
            this.secondary.setParent(this);
            this.secondary.setPriSec(2);
        }
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void setHead(Note aNote) {
        this.head.clear();
        this.head.add(aNote);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void setHeads(Set noteSet) {
        this.head.clear();
        this.head.addAll(noteSet);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void addHead(Note aNote) {
        this.head.add(aNote);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void addHeads(Set noteSet) {
        this.head.addAll(noteSet);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public void removeHead(Note aNote) {
        HashSet as = new HashSet(this.head);
        as.remove(aNote);
        this.head.clear();
        this.head.addAll(as);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
    }

    public PRNode removeNode() {
        if (this.parent != null) {
            PRNode granpa = this.parent.getParent();
            if (granpa != null) {
                PRNode nsLeaf = null;
                if (this.isPrimary()) {
                    nsLeaf = this.parent.getSecondary().getPrimaryLeaf();
                    if (this.parent.isPrimary()) {
                        granpa.setChildren(this.parent.getSecondary(), granpa.getSecondary(), granpa.getHeadRecipe());
                    } else if (this.parent.isSecondary()) {
                        granpa.setChildren(granpa.getPrimary(), this.parent.getSecondary(), granpa.getHeadRecipe());
                    }
                } else {
                    nsLeaf = this.parent.getPrimary().getPrimaryLeaf();
                    if (this.parent.isPrimary()) {
                        granpa.setChildren(this.parent.getPrimary(), granpa.getSecondary(), granpa.getHeadRecipe());
                    } else if (this.parent.isSecondary()) {
                        granpa.setChildren(granpa.getPrimary(), this.parent.getPrimary(), granpa.getHeadRecipe());
                    }
                }
                return granpa.getRootNode();
            }
            PRNode rtnd = null;
            if (this.isPrimary()) {
                this.parent.getSecondary().setAsRoot();
                this.parent.getSecondary().updateHeadAndDiscendantSet();
                this.parent.getSecondary().updateDepth();
                this.parent.getSecondary().updateAncestorSet();
                rtnd = this.parent.getSecondary();
            } else if (this.isSecondary()) {
                this.parent.getPrimary().setAsRoot();
                this.parent.getPrimary().updateHeadAndDiscendantSet();
                this.parent.getPrimary().updateDepth();
                this.parent.getPrimary().updateAncestorSet();
                rtnd = this.parent.getPrimary();
            }
            return rtnd;
        }
        this.setAsRoot();
        return this;
    }

    public PRNode getRootNode() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootNode();
    }

    public PRNode getParent() {
        return this.parent;
    }

    public void setParent(PRNode par) {
        this.parent = par;
    }

    public Set getAncestor() {
        return this.ancestor;
    }

    public boolean isAncestorOf(PRNode aPr) {
        if (aPr == null) {
            return false;
        }
        return aPr.getAncestor().contains(this);
    }

    public Set getDescendantNotes() {
        return new HashSet(this.discendantNotes);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setLock(boolean aKey) {
        if (aKey) {
            this.depth = 1;
            if (this.parent != null && this.parent.getDepth() != 1) {
                this.parent.updateDepth();
            }
        } else {
            this.updateDepth();
        }
    }

    public void toggleLock() {
        if (this.depth == 1) {
            this.setLock(false);
        } else {
            this.setLock(true);
        }
    }

    public boolean isLocked() {
        return this.depth == 1;
    }

    public Note getTheHead() {
        return this.theHead;
    }

    public Note getFirstHead() {
        if (this.head.isEmpty()) {
            return null;
        }
        return (Note)this.head.first();
    }

    public boolean intersects(double lm, double rm) {
        return lm <= this.getRightMost() && this.getLeftMost() <= rm;
    }

    public String getPath(PRNode target) {
        if (target == null) {
            return null;
        }
        PRNode sharedAncestor = this.getSharedAncestor(target);
        if (sharedAncestor == null) {
            return null;
        }
        String aPath = ".";
        PRNode tmpNode = this;
        while (tmpNode != sharedAncestor) {
            aPath = aPath + "/..";
            tmpNode = tmpNode.parent;
        }
        String bPath = "";
        tmpNode = target;
        while (tmpNode != sharedAncestor) {
            if (tmpNode.isPrimary()) {
                bPath = "/p" + bPath;
            } else if (tmpNode.isSecondary()) {
                bPath = "/s" + bPath;
            } else {
                return null;
            }
            tmpNode = tmpNode.parent;
        }
        return aPath + bPath;
    }

    public PRNode getPrFromPath(String aPath, boolean mode) {
        PRNode tmpoNode = this;
        if (aPath == null) {
            return null;
        }
        if (aPath.length() == 0) {
            return null;
        }
        StringTokenizer stt = new StringTokenizer(aPath, "/");
        while (stt.hasMoreTokens()) {
            PRNode tmpNode = null;
            String adi = stt.nextToken();
            if (adi.compareTo(".") == 0) {
                tmpNode = tmpoNode;
            } else if (adi.compareTo("..") == 0) {
                tmpNode = tmpoNode.getParent();
            } else if (adi.compareTo("p") == 0) {
                tmpNode = tmpoNode.getPrimary();
            } else if (adi.compareTo("s") == 0) {
                tmpNode = tmpoNode.getSecondary();
            }
            if (tmpNode == null) {
                if (mode) {
                    return tmpoNode;
                }
                return null;
            }
            tmpoNode = tmpNode;
        }
        return tmpoNode;
    }

    public int getScore() {
        if (this.parent == null) {
            return 0;
        }
        return (this.getPriSec() - 1) * this.getAncestor().size() + this.parent.getScore();
    }

    public PRNode getSharedAncestor(PRNode target) {
        if (target == null) {
            return null;
        }
        HashSet<PRNode> ancSet = new HashSet<PRNode>();
        ancSet.add(this);
        ancSet.addAll(this.getAncestor());
        HashSet<PRNode> tgtAncSet = new HashSet<PRNode>();
        tgtAncSet.add(target);
        tgtAncSet.addAll(target.getAncestor());
        ancSet.retainAll(tgtAncSet);
        if (ancSet.isEmpty()) {
            return null;
        }
        PRNode sharedAncestor = null;
        int level = 0;
        for (PRNode aPr : ancSet) {
            int aLevel = aPr.getAncestor().size() + 1;
            if (level >= aLevel) continue;
            sharedAncestor = aPr;
            level = aLevel;
        }
        return sharedAncestor;
    }

    public Element makeJDOMElement() {
        Element prElement = new Element("pr");
        ArrayList<Attribute> prAttrList = new ArrayList<Attribute>();
        if (this.depth == 1 && (this.primary != null || this.secondary != null)) {
            prAttrList.add(new Attribute("hide", "true"));
        }
        prElement.setAttributes(prAttrList);
        Element headElement = new Element("head");
        headElement.setAttribute("recipe", recipeString[this.headRecipe]);
        if (this.head != null) {
            Element chordElement = new Element("chord");
            int velocity = 0;
            for (Note aNote : this.head) {
                Element noteElement = new Element("note");
                noteElement.setAttribute("id", aNote.getIdName());
                chordElement.addContent(noteElement);
                velocity = aNote.getVelocity() > velocity ? aNote.getVelocity() : velocity;
            }
            headElement.addContent(chordElement);
        }
        prElement.addContent(headElement);
        if (this.primary != null) {
            Element priElement = new Element("primary");
            priElement.addContent(this.primary.makeJDOMElement());
            prElement.addContent(priElement);
        }
        if (this.secondary != null) {
            Element secElement = new Element("secondary");
            secElement.addContent(this.secondary.makeJDOMElement());
            prElement.addContent(secElement);
        }
        return prElement;
    }

    public void setAsRoot() {
        this.setPriSec(0);
        this.setParent(null);
    }

    private void setPriSec(int i) {
        this.priSec = i;
    }

    private int getPriSec() {
        return this.priSec;
    }

    public double getLeftMost() {
        Note aNote = (Note)this.discendantNotes.first();
        return aNote.getAbsoluteTime();
    }

    public double getRightMost() {
        Note aNote = (Note)this.discendantNotes.last();
        return aNote.getAbsoluteTime() + aNote.getDuration();
    }

    public void updateAncestorSet() {
        this.ancestor.clear();
        if (this.parent != null) {
            this.ancestor.add(this.parent);
            this.ancestor.addAll(this.parent.ancestor);
        }
        if (this.primary != null) {
            this.primary.updateAncestorSet();
        }
        if (this.secondary != null) {
            this.secondary.updateAncestorSet();
        }
    }

    public void updateDepth() {
        this.depth = 0;
        if (this.primary != null) {
            this.depth = this.primary.depth;
        }
        if (this.secondary != null) {
            this.depth = this.depth > this.secondary.depth ? this.depth : this.secondary.depth;
        }
        ++this.depth;
        if (this.parent != null && this.parent.getDepth() != 1) {
            this.parent.updateDepth();
        }
    }

    public void updateHeadAndDiscendantSet() {
        this.discendantNotes.clear();
        this.theHead = null;
        if (this.isLeaf()) {
            this.discendantNotes.addAll(this.head);
            this.theHead = this.head.size() != 0 ? (Note)this.head.first() : null;
        } else {
            this.head.clear();
            if (this.primary != null) {
                this.head.addAll(this.primary.head);
                this.discendantNotes.addAll(this.primary.discendantNotes);
                this.theHead = this.primary.getTheHead();
            }
            if (this.secondary != null) {
                this.discendantNotes.addAll(this.secondary.discendantNotes);
            }
        }
        if (this.parent != null) {
            this.parent.updateHeadAndDiscendantSet();
        }
    }

    public Set getLeafSet() {
        HashSet<PRNode> as = new HashSet<PRNode>();
        if (this.isLeaf()) {
            as.add(this);
            return as;
        }
        as.addAll(this.primary.getLeafSet());
        as.addAll(this.secondary.getLeafSet());
        return as;
    }

    protected PRNode getPrimaryLeaf() {
        if (this.isLeaf()) {
            return this;
        }
        return this.primary.getPrimaryLeaf();
    }

    public static String[] getRecipeString() {
        if (recipeString == null) {
            return new String[0];
        }
        int len = recipeString.length;
        String[] copyRecipeStrings = new String[len];
        System.arraycopy(recipeString, 0, copyRecipeStrings, 0, len);
        return copyRecipeStrings;
    }
}

