/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.UIException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public abstract class PolyphonicMRObject
extends MRObject {
    public PolyphonicMRObject(MRObject source, Profile pr) throws Exception {
        super(source, pr);
    }

    public PolyphonicMRObject(URL myUrl, Profile pr) throws Exception {
        super(myUrl, pr);
    }

    public PolyphonicMRObject(Reader aReader, Profile pr) throws Exception {
        super(aReader, pr);
    }

    public PolyphonicMRObject(Profile pr) throws Exception {
        super(pr);
    }

    public void addAsVoice(URL url, Hashtable<String, String> choices) throws Exception {
        HttpURLConnection conno = (HttpURLConnection)url.openConnection();
        conno.setInstanceFollowRedirects(false);
        conno.setRequestMethod("GET");
        int status = conno.getResponseCode();
        if (status == 302) {
            String location = conno.getHeaderField("Location");
            url = new URL(location);
        }
        conno.disconnect();
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)urlConn;
            httpConn.setRequestMethod("GET");
        }
        urlConn.setDoInput(true);
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        this.addAsVoice((Reader)in, url.toString(), choices);
    }

    public void addAsVoice(Reader in, String url, String asVoice) throws Exception {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("", asVoice);
        this.addAsVoice(in, url, t);
    }

    public void addAsVoice(Reader in, String url, Hashtable<String, String> choices) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(true);
        builder.setValidation(false);
        Document tempDoc = builder.build(in);
        Element root = tempDoc.detachRootElement();
        if (root.getName().compareToIgnoreCase(this.getRootTagName()) != 0) {
            throw new UIException("The file is not of the expected type.");
        }
        List parts = root.getChildren("part");
        if (parts.size() > 0) {
            int i = 0;
            while (i < parts.size()) {
                String oldID;
                Element v = (Element)parts.get(i);
                v.detach();
                v.setAttribute("src", url);
                String partID = v.getAttributeValue("id");
                if (choices != null && (partID = choices.get(oldID = partID)) != null) {
                    v.setAttribute("id", partID);
                }
                if (partID != null) {
                    this.removeVoice(partID);
                    this.MRDocument.getRootElement().addContent(v);
                }
                i = 0;
            }
        } else {
            root.setName("part");
            String voiceID = choices != null ? choices.get("") : (this.parent.getVoices().getEditVoice() != null ? this.parent.getVoices().getEditVoice().getId() : this.parent.getVoices().getDefaultVoice().getId());
            root.setAttribute("id", voiceID);
            this.removeVoice(voiceID);
            root.setAttribute("src", url);
            this.MRDocument.getRootElement().addContent(root);
        }
        this.prepareVectors();
        this.setupMRObject();
    }

    protected void removeVoice(String voiceID) {
        List originalParts = this.MRDocument.getRootElement().getChildren("part");
        this.MRDocument.getRootElement().removeChildren("part");
        if (originalParts.size() > 0) {
            for (int j = 0; j < originalParts.size(); ++j) {
                Element ov = (Element)originalParts.get(j);
                String origPartID = ov.getAttributeValue("id");
                if (!origPartID.equals(voiceID)) continue;
                int n = originalParts.indexOf(ov);
            }
        }
    }

    protected abstract void prepareVectors();
}

