/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model;

import com.dacreation.GTTM.Model.MRObject;
import com.dacreation.GTTM.Model.MXML;
import com.dacreation.GTTM.Model.MusicXML.MusicXML;
import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.GTTM.Model.TSTree.TSNode;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;

public class TS
extends MRObject {
    private TSNode rootTsNode;
    private boolean newDataAsBranch = false;

    public TS(URL myURL, Profile pr) throws Exception {
        super(myURL, pr);
    }

    public TS(Reader ar, Profile pr) throws Exception {
        super(ar, pr);
    }

    public TS(Profile pr) throws Exception {
        super(pr);
        this.MRDocument.setRootElement(new Element("tstree"));
    }

    public TS(MRObject sourcex, Profile pr) throws Exception {
        super(sourcex, pr);
        TS source = (TS)sourcex;
        if (source != null) {
            this.setRootTsNode(this.copyIntoTS(source.getRootTsNode()));
            this.getRootTsNode().updateTemporalStructureSet();
            this.getRootTsNode().copyNonStable(source.getRootTsNode());
            this.getRootTsNode().updateTemporalStructureSet();
        } else {
            this.setRootTsNode(new TSNode());
            TSNode primary = new TSNode();
            TSNode secondary = new TSNode();
            MusicXML am = this.parent.getMXML().getContent();
            Note pn = (Note)am.getNoteStartTimeSet().last();
            primary.setHead(pn);
            this.anyToElement.put(pn.getIdName(), primary);
            Note sn = (Note)am.getNoteStartTimeSet().first();
            secondary.setHead(sn);
            this.anyToElement.put(sn.getIdName(), secondary);
            this.getRootTsNode().setChildren(primary, secondary, 0);
            this.getRootTsNode().updateTemporalStructureSet();
        }
    }

    @Override
    String getRootTagName() {
        return "tstree";
    }

    @Override
    public void setupMRObject() {
        this.setRootTsNode(this.parseTS(this.MRDocument.getRootElement().getChild("ts")));
        System.out.print(this.MRDocument.getDocument());
        if (this.getRootTsNode() != null) {
            this.getRootTsNode().updateTemporalStructureSet();
            this.getRootTsNode().setupNonStable(this.MRDocument.getRootElement());
            this.getRootTsNode().updateTemporalStructureSet();
        }
    }

    public TSNode getTSRoot() {
        return this.getRootTsNode();
    }

    public TSNode parseTS(Element anEl) {
        Element as;
        if (anEl == null) {
            return null;
        }
        Element aHead = anEl.getChild("head");
        TSNode pri = null;
        TSNode sec = null;
        Element ap = anEl.getChild("primary");
        if (ap != null) {
            pri = this.parseTS(ap.getChild("ts"));
        }
        if ((as = anEl.getChild("secondary")) != null) {
            sec = this.parseTS(as.getChild("ts"));
        }
        if (pri == null && sec == null) {
            if (aHead != null) {
                TSNode leafNode = new TSNode();
                for (Element nniiee : aHead.getChild("chord").getChildren("note")) {
                    String id = nniiee.getAttributeValue("id");
                    MXML am = this.parent.getMXML();
                    Note aNote = am.getNoteFromID(id);
                    if (aNote == null) continue;
                    leafNode.addHead(aNote);
                    this.anyToElement.put(aNote.getIdName(), leafNode);
                }
                return leafNode;
            }
        } else {
            TSNode aTs = new TSNode();
            String headRecipe = "";
            if (aHead != null) {
                headRecipe = aHead.getAttributeValue("recipe");
            }
            int recipe = 0;
            if (headRecipe == null) {
                headRecipe = "ordinary";
            }
            String[] recipeString = TSNode.getRecipeString();
            for (int a = 0; a < 4; ++a) {
                if (headRecipe.compareTo(recipeString[a]) != 0) continue;
                recipe = a;
                break;
            }
            aTs.setChildren(pri, sec, recipe);
            if (anEl.getAttributeValue("hide") != null) {
                aTs.setLock(true);
            }
            return aTs;
        }
        return null;
    }

    private TSNode copyIntoTS(TSNode source) {
        TSNode as;
        if (source == null) {
            return null;
        }
        TSNode pri = null;
        TSNode sec = null;
        TSNode ap = source.getPrimary();
        if (ap != null) {
            pri = this.copyIntoTS(ap);
        }
        if ((as = source.getSecondary()) != null) {
            sec = this.copyIntoTS(as);
        }
        if (pri == null && sec == null) {
            TSNode leafNode = new TSNode();
            for (Note aNote : source.getHead()) {
                MXML am = this.parent.getMXML();
                Note bNote = am.getNoteFromID(aNote.getIdName());
                leafNode.addHead(bNote);
                this.anyToElement.put(bNote.getIdName(), leafNode);
            }
            return leafNode;
        }
        TSNode aTs = new TSNode();
        int recipe = source.getHeadRecipe();
        aTs.setChildren(pri, sec, recipe);
        aTs.setLock(source.getDepth() == 1);
        return aTs;
    }

    public void addAsSecondaryBranch(TSNode source) {
        TSNode copy = this.copyIntoTS(source);
        this.getRootTsNode().setSecondaryChild(copy, 0);
    }

    @Override
    public void createXMLDocument() {
        this.MRDocument = this.exportXmlDocument();
    }

    public void setRootTsNode(TSNode rTsNode) {
        this.rootTsNode = rTsNode;
    }

    public TSNode getRootTsNode() {
        return this.rootTsNode;
    }

    public URL getURL() {
        return this.MRURL;
    }

    public boolean isNewDataAsBranch() {
        return this.newDataAsBranch;
    }

    public void setNewDataAsBranch(boolean newDataAsBranch) {
        this.newDataAsBranch = newDataAsBranch;
    }

    public void shiftRoot() {
        TSNode root = this.getRootTsNode();
        TSNode newRoot = new TSNode();
        newRoot.setChildren(root, null, 0);
        this.setRootTsNode(newRoot);
    }

    public void exportXMLDocumentToWriter(Writer writer) throws IOException {
        Document doc = this.exportXmlDocument();
        TS.saveToWriter(writer, doc);
    }

    private Document exportXmlDocument() {
        Document doc = new Document();
        Element rts = new Element("tstree");
        rts.setContent(this.getRootTsNode().makeJDOMElement());
        doc.setRootElement(rts);
        return doc;
    }
}

