/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.GTTM.Model.TSTree;

import com.dacreation.GTTM.Model.MusicXML.Note;
import com.dacreation.GTTM.Model.MusicXML.StartTimeComparator;
import com.dacreation.GTTM.Model.TSTree.Temp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Element;

public class TSNode {
    protected TreeSet head = new TreeSet(new StartTimeComparator());
    protected int headRecipe;
    public static final int ORDINARY = 0;
    public static final int FUSION = 1;
    public static final int TRANSFORMATION = 2;
    public static final int CADENTIAL_RETAIN = 3;
    private static final String[] recipeString = new String[]{"ordinary", "fusion", "transformation", "cadential retain", ""};
    public static final TSNode TSNode_TOP = new TSNode();
    protected Temp at;
    protected TSNode primary;
    protected TSNode secondary;
    protected TSNode parent;
    int priSec;
    int depth;
    protected Set ancestor = new HashSet();
    protected TreeSet discendantNotes = new TreeSet(new StartTimeComparator());
    protected Note theHead;

    public void setupNonStableforCloning(TSNode newNode) {
        TSNode nonstaow;
        String nspath;
        TSNode newnsOwner;
        Temp newAt = newNode.getAt();
        Temp nons = this.at.getNonStable();
        if (nons != null && !nons.equals(Temp.INF) && (newnsOwner = newNode.getTsFromPath(nspath = this.getPath(nonstaow = nons.getOwner()), false)) != null) {
            newAt.setNonStable(newnsOwner.getAt());
        }
        if (this.primary != null) {
            this.primary.setupNonStableforCloning(newNode.primary);
        }
        if (this.secondary != null) {
            this.secondary.setupNonStableforCloning(newNode.secondary);
        }
    }

    protected void finalize() throws Throwable {
        this.parent = null;
        this.primary = null;
        this.secondary = null;
        this.head = null;
        this.ancestor = null;
        this.discendantNotes = null;
        this.at = null;
        super.finalize();
    }

    public TSNode() {
        this.at = new Temp(this);
    }

    public TSNode lub(TSNode targetNode) {
        TSNode newNode = this.getLUB(targetNode);
        return newNode;
    }

    private Temp lubTemp(TSNode aNode, TSNode newNode) {
        Temp aAt = this.at;
        Temp bAt = aNode.at;
        Temp lubAt = newNode.at;
        if (aAt.getStableDirection() == bAt.getStableDirection()) {
            // empty if block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private TSNode getLUB(TSNode targetNode) {
        void var8_13;
        TSNode lubNode = new TSNode();
        Set aaHeads = this.getHead();
        Set bHeads = targetNode.getHead();
        Set<Note> tempHeads = new HashSet();
        for (Note aNote : aaHeads) {
            for (Note bNote : bHeads) {
                Note lNote = aNote.lubNote(bNote);
                if (lNote == null) continue;
                tempHeads.add(lNote);
            }
        }
        tempHeads = this.concreteChord(tempHeads);
        lubNode.head.clear();
        lubNode.head.addAll(tempHeads);
        for (Note note : tempHeads) {
        }
        Object var8_11 = null;
        TSNode tmpsec = null;
        if (this.primary != null && targetNode.getPrimary() != null) {
            TSNode tSNode = this.primary.getLUB(targetNode.getPrimary());
        }
        if (this.secondary != null && targetNode.getSecondary() != null) {
            tmpsec = this.secondary.getLUB(targetNode.getSecondary());
        }
        lubNode.setChildren((TSNode)var8_13, tmpsec, this.headRecipe < targetNode.headRecipe ? this.headRecipe : targetNode.headRecipe);
        return lubNode;
    }

    private Set concreteChord(Collection tempHeads) {
        int i = tempHeads.size();
        while (i > 0) {
            if (tempHeads.size() < 2) {
                return new HashSet(tempHeads);
            }
            ArrayList tempHeads2 = new ArrayList(tempHeads);
            ArrayList<Note> tempHeads3 = new ArrayList<Note>();
            Iterator thi2 = tempHeads2.iterator();
            Note aNote = (Note)thi2.next();
            tempHeads2.remove(aNote);
            thi2 = tempHeads2.iterator();
            boolean concretedANote = false;
            while (thi2.hasNext()) {
                Note tNote = (Note)thi2.next();
                Note cNote = aNote.getConcreteNote(tNote);
                if (cNote != null) {
                    tempHeads3.add(cNote);
                    concretedANote = true;
                    continue;
                }
                tempHeads3.add(tNote);
            }
            if (!concretedANote) {
                tempHeads3.add(aNote);
                --i;
            } else {
                i = tempHeads3.size();
            }
            tempHeads = tempHeads3;
        }
        return new HashSet(tempHeads);
    }

    public int countNodes() {
        int counter = 1;
        if (this.primary != null) {
            counter += this.primary.countNodes();
        }
        if (this.secondary != null) {
            counter += this.secondary.countNodes();
        }
        return counter;
    }

    public int countValidHeads() {
        int counter = 0;
        if (this.head.size() > 0) {
            ++counter;
        } else {
            return counter;
        }
        if (this.primary != null) {
            counter += this.primary.countValidHeads();
        }
        if (this.secondary != null) {
            counter += this.secondary.countValidHeads();
        }
        return counter;
    }

    public Set getHead() {
        return this.head;
    }

    public Temp getAt() {
        return this.at;
    }

    public boolean isPrimary() {
        return this.priSec == 1;
    }

    public boolean isSecondary() {
        return this.priSec == 2;
    }

    public boolean isLeaf() {
        return this.primary == null && this.secondary == null;
    }

    public TSNode getPrimary() {
        return this.primary;
    }

    public TSNode getSecondary() {
        return this.secondary;
    }

    public int getHeadRecipe() {
        return this.headRecipe;
    }

    public void setChildren(TSNode pri, TSNode sec, int recipe) {
        this.primary = pri;
        this.secondary = sec;
        this.headRecipe = recipe;
        if (this.primary != null) {
            this.primary.setParent(this);
            this.primary.setPriSec(1);
        }
        if (this.secondary != null) {
            this.secondary.setParent(this);
            this.secondary.setPriSec(2);
        }
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void setSecondaryChild(TSNode sec, int recipe) {
        this.secondary = sec;
        this.headRecipe = recipe;
        if (this.secondary != null) {
            this.secondary.setParent(this);
            this.secondary.setPriSec(2);
        }
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void setHead(Note aNote) {
        this.head.clear();
        this.head.add(aNote);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void setHeads(Set noteSet) {
        this.head.clear();
        this.head.addAll(noteSet);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void addHead(Note aNote) {
        this.head.add(aNote);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void addHeads(Set noteSet) {
        this.head.addAll(noteSet);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public void removeHead(Note aNote) {
        HashSet as = new HashSet(this.head);
        as.remove(aNote);
        this.head.clear();
        this.head.addAll(as);
        this.updateHeadAndDiscendantSet();
        this.updateDepth();
        this.updateAncestorSet();
        this.getRootNode().updateTemporalStructureSet();
    }

    public TSNode removeNode() {
        if (this.parent != null) {
            TSNode granpa = this.parent.getParent();
            if (granpa != null) {
                TSNode nsLeaf = null;
                if (this.isPrimary()) {
                    nsLeaf = this.parent.getSecondary().getPrimaryLeaf();
                    if (this.parent.isPrimary()) {
                        granpa.setChildren(this.parent.getSecondary(), granpa.getSecondary(), granpa.getHeadRecipe());
                    } else if (this.parent.isSecondary()) {
                        granpa.setChildren(granpa.getPrimary(), this.parent.getSecondary(), granpa.getHeadRecipe());
                    }
                } else {
                    nsLeaf = this.parent.getPrimary().getPrimaryLeaf();
                    if (this.parent.isPrimary()) {
                        granpa.setChildren(this.parent.getPrimary(), granpa.getSecondary(), granpa.getHeadRecipe());
                    } else if (this.parent.isSecondary()) {
                        granpa.setChildren(granpa.getPrimary(), this.parent.getPrimary(), granpa.getHeadRecipe());
                    }
                }
                for (TSNode aLeaf : this.getLeafSet()) {
                    Temp atl = aLeaf.getAt();
                    atl.setNonStable(Temp.INF);
                    for (Temp nsst : atl.getNonStableSource()) {
                        nsst.setNonStable(nsLeaf.getAt());
                    }
                }
                granpa.updateTemporalStructureSet();
                return granpa.getRootNode();
            }
            TSNode rtnd = null;
            if (this.isPrimary()) {
                this.parent.getSecondary().setAsRoot();
                this.parent.getSecondary().updateHeadAndDiscendantSet();
                this.parent.getSecondary().updateDepth();
                this.parent.getSecondary().updateAncestorSet();
                rtnd = this.parent.getSecondary();
            } else if (this.isSecondary()) {
                this.parent.getPrimary().setAsRoot();
                this.parent.getPrimary().updateHeadAndDiscendantSet();
                this.parent.getPrimary().updateDepth();
                this.parent.getPrimary().updateAncestorSet();
                rtnd = this.parent.getPrimary();
            }
            TSNode nsLeaf = rtnd.getPrimaryLeaf();
            for (TSNode aLeaf : this.getLeafSet()) {
                Temp atl = aLeaf.getAt();
                for (Temp nsst : atl.getNonStableSource()) {
                    nsst.setNonStable(nsLeaf.getAt());
                }
            }
            rtnd.updateTemporalStructureSet();
            return rtnd;
        }
        this.setAsRoot();
        return this;
    }

    public TSNode getRootNode() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRootNode();
    }

    public TSNode getParent() {
        return this.parent;
    }

    public void setParent(TSNode par) {
        this.parent = par;
    }

    public Set getAncestor() {
        return this.ancestor;
    }

    public boolean isAncestorOf(TSNode aTs) {
        if (aTs == null) {
            return false;
        }
        return aTs.getAncestor().contains(this);
    }

    public Set getDescendantNotes() {
        return new HashSet(this.discendantNotes);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setLock(boolean aKey) {
        if (aKey) {
            this.depth = 1;
            if (this.parent != null && this.parent.getDepth() != 1) {
                this.parent.updateDepth();
            }
        } else {
            this.updateDepth();
        }
    }

    public void toggleLock() {
        if (this.depth == 1) {
            this.setLock(false);
        } else {
            this.setLock(true);
        }
    }

    public boolean isLocked() {
        return this.depth == 1;
    }

    public Note getTheHead() {
        return this.theHead;
    }

    public Note getFirstHead() {
        if (this.head.isEmpty()) {
            return null;
        }
        return (Note)this.head.first();
    }

    public boolean intersects(double lm, double rm) {
        return lm <= this.getRightMost() && this.getLeftMost() <= rm;
    }

    public String getPath(TSNode target) {
        if (target == null) {
            return null;
        }
        TSNode sharedAncestor = this.getSharedAncestor(target);
        if (sharedAncestor == null) {
            return null;
        }
        String aPath = ".";
        TSNode tmpNode = this;
        while (tmpNode != sharedAncestor) {
            aPath = aPath + "/..";
            tmpNode = tmpNode.parent;
        }
        String bPath = "";
        tmpNode = target;
        while (tmpNode != sharedAncestor) {
            if (tmpNode.isPrimary()) {
                bPath = "/p" + bPath;
            } else if (tmpNode.isSecondary()) {
                bPath = "/s" + bPath;
            } else {
                return null;
            }
            tmpNode = tmpNode.parent;
        }
        return aPath + bPath;
    }

    public TSNode getTsFromPath(String aPath, boolean mode) {
        TSNode tmpoNode = this;
        if (aPath == null) {
            return null;
        }
        if (aPath.length() == 0) {
            return null;
        }
        StringTokenizer stt = new StringTokenizer(aPath, "/");
        while (stt.hasMoreTokens()) {
            TSNode tmpNode = null;
            String adi = stt.nextToken();
            if (adi.compareTo(".") == 0) {
                tmpNode = tmpoNode;
            } else if (adi.compareTo("..") == 0) {
                tmpNode = tmpoNode.getParent();
            } else if (adi.compareTo("p") == 0) {
                tmpNode = tmpoNode.getPrimary();
            } else if (adi.compareTo("s") == 0) {
                tmpNode = tmpoNode.getSecondary();
            }
            if (tmpNode == null) {
                if (mode) {
                    return tmpoNode;
                }
                return null;
            }
            tmpoNode = tmpNode;
        }
        return tmpoNode;
    }

    public int getScore() {
        if (this.parent == null) {
            return 0;
        }
        return (this.getPriSec() - 1) * this.getAncestor().size() + this.parent.getScore();
    }

    public TSNode getSharedAncestor(TSNode target) {
        if (target == null) {
            return null;
        }
        HashSet<TSNode> ancSet = new HashSet<TSNode>();
        ancSet.add(this);
        ancSet.addAll(this.getAncestor());
        HashSet<TSNode> tgtAncSet = new HashSet<TSNode>();
        tgtAncSet.add(target);
        tgtAncSet.addAll(target.getAncestor());
        ancSet.retainAll(tgtAncSet);
        if (ancSet.isEmpty()) {
            return null;
        }
        TSNode sharedAncestor = null;
        int level = 0;
        for (TSNode aTs : ancSet) {
            int aLevel = aTs.getAncestor().size() + 1;
            if (level >= aLevel) continue;
            sharedAncestor = aTs;
            level = aLevel;
        }
        return sharedAncestor;
    }

    public Element makeJDOMElement() {
        Element tsElement = new Element("ts");
        ArrayList<Attribute> tsAttrList = new ArrayList<Attribute>();
        tsAttrList.add(new Attribute("timespan", "" + (this.getRightMost() - this.getLeftMost())));
        tsAttrList.add(new Attribute("leftend", "" + this.getLeftMost()));
        tsAttrList.add(new Attribute("rightend", "" + this.getRightMost()));
        if (this.depth == 1 && (this.primary != null || this.secondary != null)) {
            tsAttrList.add(new Attribute("hide", "true"));
        }
        tsElement.setAttributes(tsAttrList);
        Element headElement = new Element("head");
        if (this.headRecipe != 0) {
            headElement.setAttribute("recipe", recipeString[this.headRecipe]);
        }
        if (this.head != null) {
            Element chordElement = new Element("chord");
            int velocity = 0;
            for (Note aNote : this.head) {
                Element noteElement = new Element("note");
                noteElement.setAttribute("id", aNote.getIdName());
                chordElement.addContent(noteElement);
                velocity = aNote.getVelocity() > velocity ? aNote.getVelocity() : velocity;
            }
            if (this.head.size() > 0) {
                ArrayList<Attribute> chordTimeAttr = new ArrayList<Attribute>();
                Note aNotex = (Note)this.head.last();
                chordTimeAttr.add(new Attribute("duration", "" + (aNotex.getAbsoluteTime() + aNotex.getDuration() - ((Note)this.head.first()).getAbsoluteTime())));
                chordTimeAttr.add(new Attribute("velocity", "" + velocity));
                chordElement.setAttributes(chordTimeAttr);
            }
            headElement.addContent(chordElement);
        }
        tsElement.addContent(headElement);
        if (this.at != null) {
            String aPath;
            Element atElement = new Element("at");
            Element tempElement = new Element("temp");
            ArrayList<Attribute> tempAttrList = new ArrayList<Attribute>();
            tempAttrList.add(new Attribute("difference", "" + this.at.getDifference()));
            if (this.at.getStable() == null || !this.at.getStatus()) {
                tempAttrList.add(new Attribute("stable", "unknown"));
            } else if (!this.at.getStable().getStatus()) {
                tempAttrList.add(new Attribute("stable", "0"));
            } else if (this.at.getStable() == Temp.INF) {
                tempAttrList.add(new Attribute("stable", "+-inf"));
            } else {
                String aPath2 = this.getPath(this.at.getStable().getOwner());
                if (aPath2 != null) {
                    tempAttrList.add(new Attribute("stable", aPath2));
                }
            }
            tempElement.setAttributes(tempAttrList);
            Element predElement = new Element("pred");
            Element succElement = new Element("succ");
            Temp pred = null;
            Temp succ = null;
            if (this.at.getStableDirection() == -1) {
                pred = this.at.getStable();
                succ = this.at.getNonStable();
            } else if (this.at.getStableDirection() == 1) {
                succ = this.at.getStable();
                pred = this.at.getNonStable();
            }
            if (pred != null) {
                if (pred == Temp.INF) {
                    predElement.setAttribute("temp", "-inf");
                } else if (!pred.getStatus()) {
                    predElement.setAttribute("temp", "0");
                } else {
                    aPath = this.getPath(pred.getOwner());
                    if (aPath != null) {
                        predElement.setAttribute("temp", aPath);
                    }
                }
            }
            if (succ != null) {
                if (succ == Temp.INF) {
                    succElement.setAttribute("temp", "+inf");
                } else if (!succ.getStatus()) {
                    succElement.setAttribute("temp", "0");
                } else {
                    aPath = this.getPath(succ.getOwner());
                    if (aPath != null) {
                        succElement.setAttribute("temp", aPath);
                    }
                }
            }
            tempElement.addContent(predElement);
            tempElement.addContent(succElement);
            atElement.addContent(tempElement);
            tsElement.addContent(atElement);
        }
        if (this.primary != null) {
            Element priElement = new Element("primary");
            priElement.addContent(this.primary.makeJDOMElement());
            tsElement.addContent(priElement);
        }
        if (this.secondary != null) {
            Element secElement = new Element("secondary");
            secElement.addContent(this.secondary.makeJDOMElement());
            tsElement.addContent(secElement);
        }
        return tsElement;
    }

    public void setupNonStable(Element anEl) {
        Element secEl;
        Element priEl;
        if (anEl == null) {
            return;
        }
        if (this.primary != null && (priEl = anEl.getChild("primary")) != null) {
            this.primary.setupNonStable(priEl.getChild("ts"));
        }
        if (this.secondary != null && (secEl = anEl.getChild("secondary")) != null) {
            this.secondary.setupNonStable(secEl.getChild("ts"));
        }
        if (this.isLeaf()) {
            Element anAt = anEl.getChild("at");
            if (anAt == null) {
                return;
            }
            Element aTemp = anAt.getChild("temp");
            if (aTemp == null) {
                return;
            }
            Temp atemp = this.getAt();
            if (atemp.getStableDirection() == -1) {
                String aPath;
                Element succEl = aTemp.getChild("succ");
                if (succEl != null && (aPath = succEl.getAttributeValue("temp")) != null) {
                    if (aPath.endsWith("inf")) {
                        atemp.setNonStable(Temp.INF);
                    } else {
                        TSNode target = this.getTsFromPath(aPath, true);
                        if (target != null) {
                            atemp.setNonStable(target.getAt());
                        }
                    }
                }
            } else {
                String aPath;
                Element predEl = aTemp.getChild("pred");
                if (predEl != null && (aPath = predEl.getAttributeValue("temp")) != null) {
                    if (aPath.endsWith("inf")) {
                        atemp.setNonStable(Temp.INF);
                    } else {
                        TSNode target = this.getTsFromPath(aPath, true);
                        if (target != null) {
                            atemp.setNonStable(target.getAt());
                        }
                    }
                }
            }
        }
    }

    public void copyNonStable(TSNode source) {
        TSNode sec;
        TSNode pri;
        if (source == null) {
            return;
        }
        if (this.primary != null && (pri = source.primary) != null) {
            this.primary.copyNonStable(pri);
        }
        if (this.secondary != null && (sec = source.secondary) != null) {
            this.secondary.copyNonStable(sec);
        }
        if (this.isLeaf()) {
            Temp atemp = this.getAt();
            Temp nsTemp = source.at.getNonStable();
            if (nsTemp == Temp.INF) {
                atemp.setNonStable(Temp.INF);
            } else {
                String aPath = source.getPath(nsTemp.getOwner());
                if (aPath != null) {
                    atemp.setNonStable(this.getTsFromPath(aPath, true).getAt());
                }
            }
        }
    }

    public void setAsRoot() {
        this.setPriSec(0);
        this.setParent(null);
    }

    private void setPriSec(int i) {
        this.priSec = i;
    }

    private int getPriSec() {
        return this.priSec;
    }

    public double getLeftMost() {
        Note aNote = (Note)this.discendantNotes.first();
        return aNote.getAbsoluteTime();
    }

    public double getRightMost() {
        try {
            Note aNote = (Note)this.discendantNotes.last();
            return aNote.getAbsoluteTime() + aNote.getDuration();
        }
        catch (Exception e) {
            e.printStackTrace();
            double taxPrice = 0.01;
            return taxPrice;
        }
    }

    public void updateAncestorSet() {
        this.ancestor.clear();
        if (this.parent != null) {
            this.ancestor.add(this.parent);
            this.ancestor.addAll(this.parent.ancestor);
        }
        if (this.primary != null) {
            this.primary.updateAncestorSet();
        }
        if (this.secondary != null) {
            this.secondary.updateAncestorSet();
        }
    }

    public void updateTemporalStructureSet() {
        this.updateTemporalStructureSet2();
        this.updateTemporalStructureNonStable();
    }

    protected void updateTemporalStructureNonStable() {
        if (this.primary != null) {
            this.primary.updateTemporalStructureNonStable();
        }
        if (this.secondary != null) {
            this.secondary.updateTemporalStructureNonStable();
        }
        if (this.isLeaf()) {
            this.at.setNonStable(this.at.getNonStable());
        } else {
            this.at.setNonStable(this.getPrimaryLeaf().at.getNonStable());
        }
    }

    protected void updateTemporalStructureSet2() {
        if (this.parent == null || this.parent.getAt() == null || this.getTheHead() == null || this.parent.getTheHead() == null) {
            this.at.setStable(Temp.INF, 0.0);
            this.at.setNonStable(Temp.INF);
            this.at.setStatus(false);
        } else if (this.isSecondary()) {
            this.at.setStable(this.parent.getAt(), this.getTheHead().getAbsoluteTime() - this.parent.getTheHead().getAbsoluteTime());
            this.at.setStatus(true);
        } else if (this.isPrimary()) {
            this.at.inheritParent(this.parent.getAt());
        }
        if (this.primary != null) {
            this.primary.updateTemporalStructureSet2();
        }
        if (this.secondary != null) {
            this.secondary.updateTemporalStructureSet2();
        }
    }

    public void updateDepth() {
        this.depth = 0;
        if (this.primary != null) {
            this.depth = this.primary.depth;
        }
        if (this.secondary != null) {
            this.depth = this.depth > this.secondary.depth ? this.depth : this.secondary.depth;
        }
        ++this.depth;
        if (this.parent != null && this.parent.getDepth() != 1) {
            this.parent.updateDepth();
        }
    }

    public void updateHeadAndDiscendantSet() {
        this.discendantNotes.clear();
        this.theHead = null;
        if (this.isLeaf()) {
            this.discendantNotes.addAll(this.head);
            this.theHead = this.head.size() != 0 ? (Note)this.head.first() : null;
        } else {
            HashSet tmpH = new HashSet(this.head);
            this.head.clear();
            if (this.primary != null) {
                this.head.addAll(this.primary.head);
                this.discendantNotes.addAll(this.primary.discendantNotes);
                this.theHead = this.primary.getTheHead();
            }
            if (this.secondary != null) {
                if (this.headRecipe == 1) {
                    this.head.addAll(this.secondary.head);
                }
                this.discendantNotes.addAll(this.secondary.discendantNotes);
            }
        }
        if (this.parent != null) {
            this.parent.updateHeadAndDiscendantSet();
        }
    }

    public Set getLeafSet() {
        HashSet<TSNode> as = new HashSet<TSNode>();
        if (this.isLeaf()) {
            as.add(this);
            return as;
        }
        as.addAll(this.primary.getLeafSet());
        as.addAll(this.secondary.getLeafSet());
        return as;
    }

    protected TSNode getPrimaryLeaf() {
        if (this.isLeaf()) {
            return this;
        }
        return this.primary.getPrimaryLeaf();
    }

    public static String[] getRecipeString() {
        if (recipeString == null) {
            return new String[0];
        }
        int len = recipeString.length;
        String[] copyRecipeStrings = new String[len];
        System.arraycopy(recipeString, 0, copyRecipeStrings, 0, len);
        return copyRecipeStrings;
    }
}

