/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.InteractiveGTTMAnalyzer;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class ExportVoicesDialog
extends JDialog {
    Vector<JCheckBox> checkboxes;
    JCheckBox additionalCheckBox;
    Vector<JLabel> labels;
    Vector<JTextField> textfields;
    Hashtable<String, String> choice = null;
    int nvoices;
    Vector<String> voicesToExport;
    private JButton button1;
    private JButton button2;

    public ExportVoicesDialog(Frame parent, Vector<String> voicesToExport) {
        this(parent, voicesToExport, true, "Export Voices", "export ", "Choose the voices to export:", "");
    }

    public ExportVoicesDialog(Frame parent, Vector<String> voicesToExport, boolean showRenameOption, String title, String exportString, String introText, String additionalOption) {
        super(parent, true);
        this.voicesToExport = voicesToExport;
        this.setTitle(title);
        this.button1 = new JButton();
        this.button2 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                ExportVoicesDialog.this.button1.requestFocusInWindow();
            }
        });
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportVoicesDialog.this.okButtonPressed(evt);
            }
        });
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportVoicesDialog.this.abortButtonPressed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(InteractiveGTTMAnalyzer.class).getContext().getResourceMap(ExportVoicesDialog.class);
        this.button1.setText("OK");
        this.button1.setName("okbutton");
        this.button2.setText("Abort");
        this.button2.setName("Abort");
        this.getRootPane().setDefaultButton(this.button1);
        Collections.sort(this.voicesToExport);
        this.nvoices = this.voicesToExport.size();
        if (this.nvoices == 0) {
            this.voicesToExport.add("");
            this.nvoices = 1;
        }
        this.checkboxes = new Vector();
        this.labels = new Vector();
        this.textfields = new Vector();
        for (int i = 0; i < this.nvoices; ++i) {
            this.checkboxes.add(new JCheckBox(exportString + this.voicesToExport.elementAt(i), true));
            this.labels.add(new JLabel("as"));
            this.textfields.add(new JTextField(this.voicesToExport.elementAt(i)));
        }
        JLabel intro = new JLabel(introText);
        if (!additionalOption.isEmpty()) {
            this.additionalCheckBox = new JCheckBox(additionalOption, true);
        }
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.ParallelGroup horizontalParallelGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup verticalSequentialGroup = layout.createSequentialGroup();
        horizontalParallelGroup.addComponent(intro);
        verticalSequentialGroup.addComponent(intro);
        for (int i = 0; i < this.nvoices; ++i) {
            if (showRenameOption) {
                horizontalParallelGroup.addGroup(layout.createSequentialGroup().addComponent(this.checkboxes.elementAt(i)).addComponent(this.labels.elementAt(i)).addComponent(this.textfields.elementAt(i)));
                verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkboxes.elementAt(i)).addComponent(this.labels.elementAt(i)).addComponent(this.textfields.elementAt(i)));
                continue;
            }
            horizontalParallelGroup.addGroup(layout.createSequentialGroup().addComponent(this.checkboxes.elementAt(i)));
            verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkboxes.elementAt(i)));
        }
        if (this.additionalCheckBox != null) {
            horizontalParallelGroup.addComponent(this.additionalCheckBox);
            verticalSequentialGroup.addComponent(this.additionalCheckBox);
        }
        horizontalParallelGroup.addGroup(layout.createSequentialGroup().addComponent(this.button2).addComponent(this.button1));
        verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button2).addComponent(this.button1));
        layout.setHorizontalGroup(horizontalParallelGroup);
        layout.setVerticalGroup(verticalSequentialGroup);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(0, 347, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonPressed(ActionEvent evt) {
        int i;
        for (i = 0; i < this.nvoices; ++i) {
            if (!this.checkboxes.elementAt(i).isSelected()) continue;
            if (this.textfields.elementAt(i).getText() == null || this.textfields.elementAt(i).getText().trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "You have not specified a name for a voice you want to export.", "Error", 0);
                return;
            }
            for (int j = i + 1; j < this.nvoices; ++j) {
                if (!this.checkboxes.elementAt(j).isSelected() || !this.textfields.elementAt(i).getText().equals(this.textfields.elementAt(j).getText())) continue;
                JOptionPane.showMessageDialog(null, "You can not export two voices with the same name.", "Error", 0);
                return;
            }
        }
        this.choice = new Hashtable();
        for (i = 0; i < this.nvoices; ++i) {
            if (!this.checkboxes.elementAt(i).isSelected()) continue;
            this.choice.put(this.voicesToExport.elementAt(i), this.textfields.elementAt(i).getText());
        }
        this.closeDialog();
    }

    private void abortButtonPressed(ActionEvent evt) {
        this.closeDialog();
    }

    Hashtable<String, String> showDialog() {
        this.setVisible(true);
        return this.choice;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void selectOnlyVoice(String id) {
        for (int i = 0; i < this.nvoices; ++i) {
            if (this.voicesToExport.elementAt(i).equals(id)) {
                this.checkboxes.elementAt(i).setSelected(true);
                continue;
            }
            this.checkboxes.elementAt(i).setSelected(false);
        }
    }

    void setSelectionCompulsory() {
        for (int i = 0; i < this.nvoices; ++i) {
            if (!this.checkboxes.elementAt(i).isSelected()) continue;
            this.checkboxes.elementAt(i).setEnabled(false);
        }
    }

    public boolean getAdditonalOption() {
        if (this.additionalCheckBox != null) {
            return this.additionalCheckBox.isSelected();
        }
        return false;
    }
}

