/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.GTTM.Model.GPR;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.GTTMEditorView;
import com.dacreation.gttmeditor.ParamsDialog;
import com.dacreation.gttmeditor.Voices;
import com.serverConnection.HTTPPostRequest;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;

public class GPRParamsDialog
extends ParamsDialog {
    static Hashtable<String, Double> values;
    GPR oldGPR;

    public GPRParamsDialog(GTTMEditorView editor, boolean modal) throws UIException {
        super(editor, modal);
        if (editor.gpr != null) {
            try {
                this.oldGPR = editor.gpr;
            }
            catch (Exception exception) {}
        } else {
            this.oldGPR = null;
        }
        String[] params = new String[]{"w_GPR2a", "w_GPR2b", "w_GPR3a", "w_GPR3b", "w_GPR3c", "w_GPR3d", "w_GPR4", "w_GPR5", "w_GPR6", "w_GPR7T", "w_GPR7P", "w_GPR6_rithm_register", "w_GPR6_start_end", "w_GPR6_length", "t_GPR4", "t_GPR6", "w_GPRSum", "w_GPR236", "w_sigma"};
        double[] scales = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 100.0};
        if (values == null) {
            values = new Hashtable();
            for (int i = 0; i < params.length; ++i) {
                values.put(params[i], 5.0 / scales[i]);
            }
        }
        this.addComponents(params, scales, values);
        this.setTitle("Parameters for GPR analysis");
    }

    @Override
    protected void prepareAnalysis() throws UIException {
        this.requestSessionID();
        this.postMXMLData();
        this.requestGPRAnalysis(this.createCompleteParamString(values));
    }

    @Override
    public void paramChange(String param, double value) throws UIException {
        values.put(param, value);
        this.requestGPRAnalysis(param + "=" + Double.toString(value));
    }

    private void requestGPRAnalysis(String command) throws UIException {
        try {
            this.setStatusText("requesting analysis...");
            URL url = new URL(this.serverScriptPath + "GPRanalysis.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&" + command);
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            Reader r = postRequest.getResultReader();
            Voices.Voice v = this.editor.voices.getEditVoice() == null ? this.editor.voices.getDefaultVoice() : this.editor.voices.getEditVoice();
            this.editor.newGPR(r, v.getId());
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when requesting GPR analysis: " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void abortOperation() {
        try {
            this.editor.setGPR(this.oldGPR);
            this.editor.updatePianoRoll();
            this.editor.updateInterface();
        }
        catch (UIException uIException) {
            // empty catch block
        }
    }
}

