/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.InteractiveGTTMAnalyzer;
import com.dacreation.gttmeditor.Voices;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class ImportVoicesDialog
extends JDialog {
    Vector<JCheckBox> checkboxes;
    Vector<JLabel> labels;
    Vector<JComboBox> comboboxes;
    Hashtable<String, String> choice = null;
    int nvoices;
    Vector<String> voicesInFile;
    private JButton button1;
    private JButton button2;

    public ImportVoicesDialog(Frame parent, Vector<String> voicesToImport, Voices voices, boolean editable) {
        super(parent, true);
        this.voicesInFile = voicesToImport;
        this.setTitle("Import voices");
        this.button1 = new JButton();
        this.button2 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                ImportVoicesDialog.this.button1.requestFocusInWindow();
            }
        });
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportVoicesDialog.this.okButtonPressed(evt);
            }
        });
        this.button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportVoicesDialog.this.abortButtonPressed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(InteractiveGTTMAnalyzer.class).getContext().getResourceMap(ImportVoicesDialog.class);
        this.button1.setText("OK");
        this.button1.setName("okbutton");
        this.button2.setText("Abort");
        this.button2.setName("Abort");
        this.getRootPane().setDefaultButton(this.button1);
        this.nvoices = this.voicesInFile.size();
        if (this.nvoices == 0) {
            this.voicesInFile.add("");
            this.nvoices = 1;
        }
        this.checkboxes = new Vector();
        this.labels = new Vector();
        this.comboboxes = new Vector();
        Vector<String> voiceIDs = voices.getIdVector();
        for (int i = 0; i < this.nvoices; ++i) {
            this.checkboxes.add(new JCheckBox("import " + this.voicesInFile.elementAt(i), true));
            this.labels.add(new JLabel("as"));
            this.comboboxes.add(new JComboBox<String>(voiceIDs));
            this.comboboxes.elementAt(i).setEditable(editable);
            this.comboboxes.elementAt(i).setSelectedItem(this.voicesInFile.elementAt(i));
        }
        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.ParallelGroup horizontalParallelGroup = layout.createParallelGroup();
        GroupLayout.SequentialGroup verticalSequentialGroup = layout.createSequentialGroup();
        for (int i = 0; i < this.nvoices; ++i) {
            horizontalParallelGroup.addGroup(layout.createSequentialGroup().addComponent(this.checkboxes.elementAt(i)).addComponent(this.labels.elementAt(i)).addComponent(this.comboboxes.elementAt(i)));
            verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkboxes.elementAt(i)).addComponent(this.labels.elementAt(i)).addComponent(this.comboboxes.elementAt(i)));
        }
        horizontalParallelGroup.addGroup(layout.createSequentialGroup().addComponent(this.button2).addComponent(this.button1));
        verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button2).addComponent(this.button1));
        layout.setHorizontalGroup(horizontalParallelGroup);
        layout.setVerticalGroup(verticalSequentialGroup);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(0, 347, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(0, 300, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonPressed(ActionEvent evt) {
        int i;
        for (i = 0; i < this.nvoices; ++i) {
            if (!this.checkboxes.elementAt(i).isSelected()) continue;
            if (this.comboboxes.elementAt(i).getSelectedItem() == null || ((String)this.comboboxes.elementAt(i).getSelectedItem()).trim().isEmpty()) {
                JOptionPane.showMessageDialog(null, "You have not specified to which voice you want to add " + this.voicesInFile.elementAt(i) + ".", "Error", 0);
                return;
            }
            for (int j = i + 1; j < this.nvoices; ++j) {
                if (!this.checkboxes.elementAt(j).isSelected() || !this.comboboxes.elementAt(i).getSelectedItem().equals(this.comboboxes.elementAt(j).getSelectedItem())) continue;
                JOptionPane.showMessageDialog(null, "You can not add two voices of the file to one voice.", "Error", 0);
                return;
            }
        }
        this.choice = new Hashtable();
        for (i = 0; i < this.nvoices; ++i) {
            if (!this.checkboxes.elementAt(i).isSelected()) continue;
            this.choice.put(this.voicesInFile.elementAt(i), (String)this.comboboxes.elementAt(i).getSelectedItem());
        }
        this.closeDialog();
    }

    private void abortButtonPressed(ActionEvent evt) {
        this.closeDialog();
    }

    Hashtable<String, String> showDialog() {
        this.setVisible(true);
        return this.choice;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

