/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.gttmeditor.Voices;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class JPanelVoices
extends JPanel {
    int NvoiceButtons = 0;
    Hashtable<Voices.Voice, VoiceButton> voiceButtons = new Hashtable();

    public void addVoice(Voices.Voice voice, Color color) {
        VoiceButton vb = new VoiceButton(voice, color, new Color(0.5f, 0.5f, 0.5f));
        this.voiceButtons.put(voice, vb);
        this.add(vb);
        this.setLayout(new BoxLayout(this, 0));
        this.revalidate();
        this.repaint();
    }

    public void removeVoice(Voices.Voice voice) {
        VoiceButton vb = this.voiceButtons.get(voice);
        if (vb != null) {
            this.remove(vb);
            this.voiceButtons.remove(voice);
            this.setLayout(new BoxLayout(this, 0));
            this.revalidate();
            this.repaint();
        }
    }

    class CustomButtonUI
    extends BasicToggleButtonUI {
        private Color _selectedColor;

        public CustomButtonUI(Color selectedColor) {
            this._selectedColor = selectedColor;
        }

        @Override
        public void paintButtonPressed(Graphics g, AbstractButton b) {
            if (b.getBackground() != this.getSelectedColor()) {
                b.setBackground(this.getSelectedColor());
            }
        }

        public Color getSelectedColor() {
            return this._selectedColor;
        }
    }

    public class VoiceButton
    extends JButton
    implements MouseListener {
        protected Voices.Voice voice;
        protected Color showBgColor;
        protected Color hideBgColor;
        protected Color overlayColor;
        protected LineBorder editBorder;
        protected LineBorder hideBorder;
        protected LineBorder showBorder;
        protected int state;
        public static final int STATE_HIDDEN = 0;
        public static final int STATE_SHOWN = 1;
        public static final int STATE_EDIT = 2;

        public VoiceButton(Voices.Voice v, Color activatedColor, Color deactivatedColor) {
            super(v.getId());
            this.voice = v;
            v.setButton(this);
            this.showBgColor = new Color(activatedColor.getRed(), activatedColor.getGreen(), activatedColor.getBlue(), 175);
            this.hideBgColor = null;
            this.setSelected(false);
            this.overlayColor = this.hideBgColor;
            this.setContentAreaFilled(false);
            this.hideBorder = new LineBorder(this.showBgColor, 2);
            this.showBorder = new LineBorder(this.showBgColor, 2);
            this.editBorder = new LineBorder(new Color(0.0f, 0.0f, 0.0f), 2);
            this.addMouseListener(this);
            this.setMinimumSize(new Dimension(20, 20));
            this.setPreferredSize(new Dimension(20, 20));
            this.setMaximumSize(new Dimension(32, 32));
            this.setBackground(activatedColor);
            this.state = 1;
            this.showState();
        }

        public Color getActivatedColor() {
            return this.showBgColor;
        }

        public Color getDeactivatedColor() {
            return this.hideBgColor;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.overlayColor != null) {
                Graphics2D g2 = (Graphics2D)g;
                int w = this.getWidth();
                int h = this.getHeight();
                g2.setPaint(this.overlayColor);
                g2.fillRect(0, 0, w, h);
            }
        }

        public void showState() {
            switch (this.state) {
                case 0: {
                    this.setBorder(this.hideBorder);
                    this.overlayColor = this.hideBgColor;
                    break;
                }
                case 1: {
                    this.setBorder(this.showBorder);
                    this.overlayColor = this.showBgColor;
                    break;
                }
                case 2: {
                    this.setBorder(this.editBorder);
                    this.overlayColor = this.showBgColor;
                }
            }
        }

        public void updateVoiceState() {
            switch (this.state) {
                case 0: {
                    this.voice.setEdit(false);
                    this.voice.setShow(false);
                    break;
                }
                case 1: {
                    this.voice.setEdit(false);
                    this.voice.setShow(true);
                    break;
                }
                case 2: {
                    this.voice.setEdit(true);
                    this.voice.setShow(true);
                }
            }
        }

        public void dontEdit() {
            if (this.state == 2) {
                this.state = 1;
                this.showState();
                this.updateVoiceState();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            block5: {
                block4: {
                    if (me.getButton() == 1) {
                        this.toggleShow();
                    }
                    if (me.getButton() == 2) break block4;
                    if (me.getButton() != 3) break block5;
                }
                this.setToEdit();
            }
        }

        public void toggleShow() {
            this.state = this.state == 2 ? 0 : (this.state + 1) % 2;
            this.showState();
            this.updateVoiceState();
        }

        public void setToEdit() {
            this.state = 2;
            this.showState();
            this.updateVoiceState();
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseReleased(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }
    }
}

