/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.GTTM.Model.MPR;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.GTTMEditorView;
import com.dacreation.gttmeditor.ParamsDialog;
import com.dacreation.gttmeditor.Voices;
import com.serverConnection.HTTPPostRequest;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;

public class MPRParamsDialog
extends ParamsDialog {
    static Hashtable<String, Double> values;
    MPR oldMPR;

    public MPRParamsDialog(GTTMEditorView editor, boolean modal) throws UIException {
        super(editor, modal);
        if (editor.mpr != null) {
            try {
                this.oldMPR = editor.mpr;
            }
            catch (Exception exception) {}
        } else {
            this.oldMPR = null;
        }
        String[] params = new String[]{"w_MPR1", "w_MPR2", "w_MPR3", "w_MPR4", "w_MPR5a", "w_MPR5b", "w_MPR5c", "w_MPR5d", "w_MPR5e", "w_MPR6", "w_MPR7", "w_MPR8", "w_MPR9", "w_MPR10", "t_MPR1", "t_MPR4", "t_MPR5a", "t_MPR5b", "t_MPR5c", "w_MPR1_rithm_register", "w_MPR1_start_end", "w_MPR1_length"};
        double[] scales = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        if (values == null) {
            values = new Hashtable();
            for (int i = 0; i < params.length; ++i) {
                values.put(params[i], 5.0 / scales[i]);
            }
        }
        this.addComponents(params, scales, values);
        this.setTitle("Parameters for MPR analysis");
    }

    @Override
    protected void prepareAnalysis() throws UIException {
        this.requestSessionID();
        this.postMXMLData();
        this.postMonophonicGPRData();
        this.requestMPRAnalysis(this.createCompleteParamString(values));
    }

    @Override
    public void paramChange(String param, double value) throws UIException {
        values.put(param, value);
        this.requestMPRAnalysis(param + "=" + Double.toString(value));
    }

    private void requestMPRAnalysis(String command) throws UIException {
        try {
            this.setStatusText("requesting analysis...");
            URL url = new URL(this.serverScriptPath + "MPRanalysis.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&" + command);
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            Reader r = postRequest.getResultReader();
            Voices.Voice v = this.editor.voices.getEditVoice() == null ? this.editor.voices.getDefaultVoice() : this.editor.voices.getEditVoice();
            this.editor.newMPR(r, v.getId());
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when requesting MPR analysis: " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void abortOperation() {
        try {
            this.editor.setMPR(this.oldMPR);
            this.editor.updatePianoRoll();
            this.editor.updateInterface();
        }
        catch (UIException uIException) {
            // empty catch block
        }
    }
}

