/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.GTTM.Model.PR;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.GTTMEditorView;
import com.dacreation.gttmeditor.ParamsDialog;
import com.dacreation.gttmeditor.Voices;
import com.serverConnection.HTTPPostRequest;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;

public class PRParamsDialog
extends ParamsDialog {
    static Hashtable<String, Double> values;
    PR oldPR;

    public PRParamsDialog(GTTMEditorView editor, boolean modal, boolean addToExistingTree) throws UIException {
        super(editor, modal);
        if (editor.pr != null) {
            try {
                this.oldPR = editor.pr;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (addToExistingTree) {
                editor.pr.shiftRoot();
                editor.pr.setNewDataAsBranch(true);
            } else {
                editor.pr.setNewDataAsBranch(false);
            }
        } else {
            this.oldPR = null;
        }
        String[] params = new String[]{"w_PRPR1", "w_PRPR2", "w_PRPR3_1a", "w_PRPR3_1b", "w_PRPR3_2", "w_PRPR3_3a", "w_PRPR3_3b", "w_PRPR3_4a", "w_PRPR3_4b", "w_PRPR4", "w_PRPR5", "w_PRPR6a", "w_PRPR6b", "w_PRPR6c", "w_PRPR6d", "w_PRPR6e"};
        double[] scales = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        if (values == null) {
            values = new Hashtable();
            for (int i = 0; i < params.length; ++i) {
                values.put(params[i], 5.0 / scales[i]);
            }
        }
        this.addComponents(params, scales, values);
        this.setTitle("Parameters for PR analysis");
    }

    @Override
    protected void prepareAnalysis() throws UIException {
        this.requestSessionID();
        this.postMXMLData();
        this.postMonophonicGPRData();
        this.postMonophonicMPRData();
        this.postTSData();
        this.requestPRAnalysis(this.createCompleteParamString(values));
    }

    @Override
    public void paramChange(String param, double value) throws UIException {
        values.put(param, value);
        this.requestPRAnalysis(param + "=" + Double.toString(value));
    }

    private void requestPRAnalysis(String command) throws UIException {
        try {
            this.setStatusText("requesting analysis...");
            URL url = new URL(this.serverScriptPath + "PRanalysis.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&" + command);
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            Reader r = postRequest.getResultReader();
            Voices.Voice v = this.editor.voices.getEditVoice() == null ? this.editor.voices.getDefaultVoice() : this.editor.voices.getEditVoice();
            this.editor.newPR(r);
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when requesting PR analysis: " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void abortOperation() {
        this.editor.setPR(this.oldPR);
        this.editor.updatePianoRoll();
        this.editor.updateInterface();
    }
}

