/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.gttmeditor.ParamChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class ParameterEditField
extends JPanel {
    JScrollBar scrollbar;
    JLabel value;
    String paramName;
    double scale = 10.0;
    ParamChangeListener listener;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        if (scale != 0.0) {
            this.scale = scale;
            this.scrollbarAdjustmentValueChanged(null);
        }
    }

    public double getValue() {
        return (double)this.scrollbar.getValue() / this.scale;
    }

    public ParameterEditField(String paramName) {
        this.paramName = paramName;
        this.scrollbar = new JScrollBar(0);
        this.scrollbar.setModel(new DefaultBoundedRangeModel(5, 1, 0, 11));
        this.scrollbar.setUnitIncrement(1);
        this.scrollbar.setBlockIncrement(2);
        this.scrollbar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                ParameterEditField.this.scrollbarAdjustmentValueChanged(evt);
            }
        });
        this.value = new JLabel("0.0");
        this.value.setMinimumSize(new Dimension(20, 10));
        this.value.setPreferredSize(new Dimension(30, 20));
        this.value.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        layout.setVgap(5);
        this.setLayout(layout);
        this.add((Component)this.scrollbar, "Center");
        this.add((Component)this.value, "After");
        this.scrollbarAdjustmentValueChanged(null);
    }

    private void scrollbarAdjustmentValueChanged(AdjustmentEvent evt) {
        double d = this.getValue();
        this.value.setText(Double.toString(d));
        if (this.scrollbar.getValueIsAdjusting()) {
            return;
        }
        try {
            if (this.listener != null) {
                this.listener.paramChange(this.paramName, d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addChangeListener(ParamChangeListener listener) {
        this.listener = listener;
    }

    void setValue(Double get) {
        this.scrollbar.setValue((int)Math.round(get * this.scale));
    }
}

