/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.InteractiveGTTMAnalyzer;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.ExportVoicesDialog;
import com.dacreation.gttmeditor.GTTMEditorView;
import com.dacreation.gttmeditor.ParamChangeListener;
import com.dacreation.gttmeditor.ParameterEditField;
import com.serverConnection.HTTPGetRequest;
import com.serverConnection.HTTPPostRequest;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public abstract class ParamsDialog
extends JDialog
implements ParamChangeListener {
    protected String serverScriptPath = "http://gttm.jp/gttm_analysis_scripts/ver1_3/";
    private JButton button1;
    private Button button2;
    protected String sessionID;
    protected GTTMEditorView editor;
    Hashtable<String, String> mxmlVoices = null;
    Vector<JLabel> labels;
    Vector<ParameterEditField> edits;
    JLabel statusLabel;
    JPanel panel;

    public ParamsDialog(GTTMEditorView editor, boolean modal) {
        super((Frame)editor.getFrame(), modal);
        this.editor = editor;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                try {
                    ParamsDialog.this.formWindowActivated(evt);
                }
                catch (UIException e) {
                    ParamsDialog.this.closeDialog();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                }
            }
        });
    }

    public void setMXMLVoicesToExport(Hashtable<String, String> choices) {
        this.mxmlVoices = choices;
    }

    protected void setStatusIdle() {
        this.setStatusText("ready");
    }

    protected void setStatusText(String s) {
        this.statusLabel.setText("<html><I> " + s + "</I></html>");
        this.statusLabel.paintImmediately(this.statusLabel.getVisibleRect());
    }

    public void addComponents(String[] params, double[] scales, Hashtable<String, Double> values) {
        this.panel = new JPanel();
        this.statusLabel = new JLabel();
        this.getContentPane().add((Component)this.panel, "Center");
        this.statusLabel.setMinimumSize(new Dimension(100, 23));
        this.statusLabel.setPreferredSize(new Dimension(230, 23));
        this.statusLabel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.statusLabel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        this.getContentPane().add((Component)this.statusLabel, "Last");
        this.labels = new Vector();
        this.edits = new Vector();
        this.button1 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                ParamsDialog.this.button1.requestFocusInWindow();
            }
        });
        this.button1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParamsDialog.this.okButtonPressed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(InteractiveGTTMAnalyzer.class).getContext().getResourceMap(ExportVoicesDialog.class);
        this.button1.setText("OK");
        this.button1.setName("okbutton");
        this.getRootPane().setDefaultButton(this.button1);
        for (int i = 0; i < params.length; ++i) {
            JLabel label = new JLabel(params[i]);
            this.labels.add(label);
            ParameterEditField pe = new ParameterEditField(params[i]);
            pe.setScale(scales[i]);
            pe.setValue(values.get(params[i]));
            pe.addChangeListener(this);
            this.edits.add(pe);
        }
        GroupLayout layout = new GroupLayout(this.panel);
        this.panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        GroupLayout.ParallelGroup horizontalParallelGroup1 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        GroupLayout.ParallelGroup horizontalParallelGroup2 = layout.createParallelGroup();
        GroupLayout.SequentialGroup horizontalSequentialGroup = layout.createSequentialGroup();
        GroupLayout.SequentialGroup verticalSequentialGroup = layout.createSequentialGroup();
        for (int i = 0; i < params.length; ++i) {
            horizontalParallelGroup1.addComponent(this.labels.elementAt(i));
            horizontalParallelGroup2.addComponent(this.edits.elementAt(i), 100, 200, 200);
            verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labels.elementAt(i)).addComponent(this.edits.elementAt(i)));
        }
        horizontalParallelGroup2.addComponent(this.button1);
        horizontalSequentialGroup.addGroup(horizontalParallelGroup1);
        horizontalSequentialGroup.addGroup(horizontalParallelGroup2);
        verticalSequentialGroup.addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.button1));
        layout.setHorizontalGroup(horizontalSequentialGroup);
        layout.setVerticalGroup(verticalSequentialGroup);
        this.pack();
    }

    private void okButtonPressed(ActionEvent evt) {
        this.closeDialog();
    }

    private void abortButtonPressed(ActionEvent evt) {
        this.abortOperation();
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.pack();
    }

    private void formWindowActivated(WindowEvent evt) throws UIException {
        this.prepareAnalysis();
    }

    @Override
    public abstract void paramChange(String var1, double var2) throws UIException;

    protected abstract void prepareAnalysis() throws UIException;

    protected void requestSessionID() throws UIException {
        try {
            this.setStatusText("requesting session ID...");
            this.sessionID = HTTPGetRequest.sendGetRequest(this.serverScriptPath + "registerSession.php", "");
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when requesting session ID: " + e.getMessage());
        }
    }

    protected void postMXMLData() throws UIException {
        try {
            this.setStatusText("posting MXML data...");
            URL url = new URL(this.serverScriptPath + "submitMXML.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&");
            postDataWriter.write("mxmlData=");
            if (this.mxmlVoices == null) {
                if (this.editor.voices.getEditVoice() == null) {
                    this.editor.mxml.exportXMLDocumentToWriter(postDataWriter, true);
                } else {
                    this.editor.mxml.exportXMLDocumentToWriter(postDataWriter, false);
                }
            } else {
                this.editor.mxml.exportXMLDocumentToWriter(postDataWriter, this.mxmlVoices);
            }
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when sending MXML data to server: " + e.getLocalizedMessage());
        }
    }

    protected void postMonophonicGPRData() throws UIException {
        try {
            this.setStatusText("posting GPR XML data...");
            URL url = new URL(this.serverScriptPath + "submitGPR.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&");
            postDataWriter.write("gprData=");
            if (this.editor.voices.getEditVoice() == null) {
                this.editor.gpr.exportXMLDocumentToWriter(postDataWriter, true);
            } else {
                this.editor.gpr.exportXMLDocumentToWriter(postDataWriter, false);
            }
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when sending GPR data to server: " + e.getLocalizedMessage());
        }
    }

    protected void postMonophonicMPRData() throws UIException {
        try {
            this.setStatusText("posting MPR XML data...");
            URL url = new URL(this.serverScriptPath + "submitMPR.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&");
            postDataWriter.write("mprData=");
            if (this.editor.voices.getEditVoice() == null) {
                this.editor.mpr.exportXMLDocumentToWriter(postDataWriter, true);
            } else {
                this.editor.mpr.exportXMLDocumentToWriter(postDataWriter, false);
            }
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when sending MPR data to server: " + e.getLocalizedMessage());
        }
    }

    protected void postTSData() throws UIException {
        try {
            this.setStatusText("posting TS XML data...");
            URL url = new URL(this.serverScriptPath + "submitTS.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&");
            postDataWriter.write("tsData=");
            this.editor.ts.exportXMLDocumentToWriter(postDataWriter);
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when sending TS data to server: " + e.getLocalizedMessage());
        }
    }

    protected String createCompleteParamString(Hashtable<String, Double> values) {
        String paramString = "";
        for (String key : values.keySet()) {
            paramString = paramString + key + "=" + Double.toString(values.get(key)) + "&";
        }
        return paramString.substring(0, paramString.length() - 1);
    }

    protected void abortOperation() {
    }
}

