/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.GTTM.Model.TS;
import com.dacreation.GTTM.Model.UIException;
import com.dacreation.gttmeditor.GTTMEditorView;
import com.dacreation.gttmeditor.ParamsDialog;
import com.dacreation.gttmeditor.Voices;
import com.serverConnection.HTTPPostRequest;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;

public class TSParamsDialog
extends ParamsDialog {
    static Hashtable<String, Double> values;
    TS oldTS;

    public TSParamsDialog(GTTMEditorView editor, boolean modal, boolean addToExistingTree) throws UIException {
        super(editor, modal);
        if (editor.ts != null) {
            try {
                this.oldTS = editor.ts;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (addToExistingTree) {
                editor.ts.shiftRoot();
                editor.ts.setNewDataAsBranch(true);
            } else {
                editor.ts.setNewDataAsBranch(false);
            }
        } else {
            this.oldTS = null;
        }
        String[] params = new String[]{"w_TSRPR1", "w_TSRPR2", "w_TSRPR3a", "w_TSRPR3b", "w_TSRPR4", "w_TSRPR5", "w_TSRPR6", "w_TSRPR7", "w_TSRPR8", "w_TSRPR9"};
        double[] scales = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0};
        if (values == null) {
            values = new Hashtable();
            for (int i = 0; i < params.length; ++i) {
                values.put(params[i], 5.0 / scales[i]);
            }
        }
        this.addComponents(params, scales, values);
        this.setTitle("Parameters for TS analysis");
    }

    @Override
    protected void prepareAnalysis() throws UIException {
        this.requestSessionID();
        this.postMXMLData();
        this.postMonophonicGPRData();
        this.postMonophonicMPRData();
        this.requestTSAnalysis(this.createCompleteParamString(values));
    }

    @Override
    public void paramChange(String param, double value) throws UIException {
        values.put(param, value);
        this.requestTSAnalysis(param + "=" + Double.toString(value));
    }

    private void requestTSAnalysis(String command) throws UIException {
        try {
            this.setStatusText("requesting analysis...");
            URL url = new URL(this.serverScriptPath + "TSanalysis.php");
            HTTPPostRequest postRequest = new HTTPPostRequest(url);
            Writer postDataWriter = postRequest.getDataWriter();
            postDataWriter.write("sessionID=");
            postDataWriter.write(this.sessionID);
            postDataWriter.write("&" + command);
            postDataWriter.close();
            postRequest.closeInput();
            postRequest.submit();
            Reader r = postRequest.getResultReader();
            Voices.Voice v = this.editor.voices.getEditVoice() == null ? this.editor.voices.getDefaultVoice() : this.editor.voices.getEditVoice();
            this.editor.newTS(r);
            postRequest.close();
            this.setStatusIdle();
        }
        catch (Exception e) {
            throw new UIException("Error when requesting TS analysis: " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void abortOperation() {
        this.editor.setTS(this.oldTS);
        this.editor.updatePianoRoll();
        this.editor.updateInterface();
    }
}

