/*
 * Decompiled with CFR 0.152.
 */
package com.dacreation.gttmeditor;

import com.dacreation.GTTM.Model.GPR;
import com.dacreation.GTTM.Model.Profile;
import com.dacreation.gttmeditor.JPanelVoices;
import com.dacreation.gttmeditor.VoiceEditListener;
import java.awt.Color;
import java.util.Vector;

public class Voices {
    static Profile parent;
    public static final Color[] DEFAULT_COLORS;
    private Voice editVoice;
    private Voice oldEditVoice;
    private static VoiceEditListener listener;
    private static Vector<Voice> v;
    Object[] removedVoices;

    public Voices(VoiceEditListener listener, Profile p) {
        parent = p;
        v = new Vector();
        Voices.listener = listener;
        this.editVoice = null;
        this.removedVoices = null;
        this.oldEditVoice = null;
    }

    private void addVoice(String id) {
        Voice nv = new Voice(id, v.size());
        v.add(nv);
        listener.addVoice(nv, DEFAULT_COLORS[v.size() - 1]);
    }

    public Color getColor(int index) {
        return v.elementAt(index).getColor();
    }

    public Voice getVoiceNumber(int index) {
        if (index >= v.size()) {
            return null;
        }
        return v.elementAt(index);
    }

    private int getVoiceIndex(String id) {
        for (int i = 0; i < v.size(); ++i) {
            if (!v.elementAt(i).getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public Voice registerVoice(String id) {
        int ind = this.getVoiceIndex(id);
        if (ind == -1) {
            this.addVoice(id);
            ind = v.size() - 1;
        }
        Voice v = this.getVoiceNumber(ind);
        v.addReference();
        return v;
    }

    public Voice getVoice(String id) {
        for (int i = 0; i < v.size(); ++i) {
            if (!v.elementAt(i).getId().equals(id)) continue;
            return v.elementAt(i);
        }
        return null;
    }

    public void unregisterVoice(Voice voice) {
        voice.removeReference();
        if (voice.references < 1) {
            v.removeElement(voice);
            listener.removeVoice(voice);
        }
    }

    public Voice getEditVoice() {
        return this.editVoice;
    }

    public void setEditVoice(Voice voice) {
        this.editVoice = voice;
    }

    public boolean optionColorNotes() {
        return true;
    }

    public Vector<String> getIdVector() {
        Vector<String> idVector = new Vector<String>();
        for (int i = 0; i < v.size(); ++i) {
            idVector.add(v.elementAt(i).getId());
        }
        return idVector;
    }

    public int getNumberOfVoices() {
        return v.size();
    }

    public Voice getDefaultVoice() {
        if (v.isEmpty()) {
            return null;
        }
        return v.firstElement();
    }

    void removeAll() {
        for (int i = 0; i < v.size(); ++i) {
            listener.removeVoice(v.elementAt(i));
        }
        this.removedVoices = v.toArray();
        v.clear();
        this.oldEditVoice = this.editVoice;
        this.editVoice = null;
    }

    void undoRemoveAll() {
        if (this.removedVoices != null) {
            for (int i = 0; i < this.removedVoices.length; ++i) {
                listener.addVoice((Voice)this.removedVoices[i], ((Voice)this.removedVoices[i]).getColor());
                v.add((Voice)this.removedVoices[i]);
            }
            this.editVoice = this.oldEditVoice;
            if (this.editVoice != null) {
                this.editVoice.button.setToEdit();
            }
            this.oldEditVoice = null;
            this.removedVoices = null;
        }
    }

    static {
        DEFAULT_COLORS = new Color[]{new Color(0.8f, 0.1f, 0.4f), new Color(0.1f, 0.8f, 0.4f), new Color(0.8f, 0.4f, 0.1f), new Color(0.1f, 0.4f, 0.8f), new Color(1.0f, 1.0f, 0.4f), new Color(0.5f, 1.0f, 0.1f), new Color(0.1f, 0.0f, 0.8f), new Color(0.8f, 0.0f, 0.1f)};
    }

    public class Voice {
        String id;
        String MXMLfilename;
        String GPRfilename;
        String MPRfilename;
        boolean edit;
        boolean show;
        Color color;
        Color noteSelectedColor;
        private JPanelVoices.VoiceButton button;
        private int references;

        public Voice(String name, String MXMLfilename, String GPRfilename, boolean edit, boolean show) {
            this.id = name;
            this.MXMLfilename = MXMLfilename;
            this.MPRfilename = "";
            this.GPRfilename = GPRfilename;
            this.edit = edit;
            this.show = show;
            this.references = 0;
        }

        public Voice(int index) {
            this.id = "";
            this.MXMLfilename = "";
            this.MPRfilename = "";
            this.GPRfilename = "";
            this.edit = false;
            this.show = true;
            this.color = DEFAULT_COLORS[index % DEFAULT_COLORS.length];
            this.references = 0;
        }

        public Voice(String id, int index) {
            this.id = id;
            this.MXMLfilename = "";
            this.GPRfilename = "";
            this.edit = false;
            this.show = true;
            this.color = DEFAULT_COLORS[index % DEFAULT_COLORS.length];
            this.references = 0;
        }

        public String getGPRFilename() {
            if (this.GPRfilename == null) {
                return "";
            }
            return this.GPRfilename;
        }

        public void setGPRfilename(String GPRfilename) {
            this.GPRfilename = GPRfilename;
        }

        public String getMPRFilename() {
            if (this.MPRfilename == null) {
                return "";
            }
            return this.MPRfilename;
        }

        public void setMPRfilename(String MPRfilename) {
            this.MPRfilename = MPRfilename;
        }

        public String getMXMLFilename() {
            if (this.MXMLfilename == null) {
                return "";
            }
            return this.MXMLfilename;
        }

        public void setMXMLfilename(String MXMLfilename) {
            this.MXMLfilename = MXMLfilename;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public void setEdit(boolean edit) {
            this.edit = edit;
            if (this.edit) {
                if (Voices.this.editVoice != null && Voices.this.editVoice != this) {
                    ((Voices)Voices.this).editVoice.edit = false;
                    Voices.this.editVoice.updateButtonState();
                }
                Voices.this.editVoice = this;
                parent.editVoice(this);
            } else if (Voices.this.editVoice == this) {
                Voices.this.editVoice = null;
            }
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.id = name;
        }

        public boolean isShow() {
            return this.show;
        }

        public void setShow(boolean show) {
            GPR.GPRule gp;
            this.show = show;
            if (!this.show) {
                this.setEdit(false);
            }
            if (parent.getGPR() != null && (gp = parent.getGPR().getGPRule(this.id)) != null) {
                gp.contour.invalidateCurve();
            }
            parent.updatePianoRoll();
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
            this.noteSelectedColor = null;
        }

        public Color getNoteColor() {
            return this.color;
        }

        public Color getSelectedNoteColor() {
            if (this.noteSelectedColor == null) {
                this.noteSelectedColor = new Color(Math.round((this.color.getRed() + 209) / 2), Math.round((this.color.getGreen() + 183) / 2), Math.round((this.color.getBlue() + 94) / 2));
            }
            return this.noteSelectedColor;
        }

        private void addReference() {
            ++this.references;
        }

        private void removeReference() {
            --this.references;
        }

        public void updateButtonState() {
            this.button.state = this.edit ? 2 : (this.show ? 1 : 0);
            this.button.showState();
        }

        public void setButton(JPanelVoices.VoiceButton button) {
            this.button = button;
        }
    }
}

