/*
 * Decompiled with CFR 0.152.
 */
package com.serverConnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

public class HTTPPostRequest {
    HttpURLConnection urlc = null;
    InputStream in;
    Reader reader;
    Writer writer;
    OutputStream out;

    public HTTPPostRequest(URL endpoint) throws Exception {
        try {
            HttpURLConnection conno = (HttpURLConnection)endpoint.openConnection();
            conno.setInstanceFollowRedirects(false);
            conno.setRequestMethod("POST");
            int status = conno.getResponseCode();
            if (status == 302) {
                String location = conno.getHeaderField("Location");
                endpoint = new URL(location);
            }
            conno.disconnect();
            this.urlc = (HttpURLConnection)endpoint.openConnection();
            try {
                this.urlc.setRequestMethod("POST");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST??", e);
            }
            this.urlc.setDoOutput(true);
            this.urlc.setDoInput(true);
            this.urlc.setUseCaches(false);
            this.urlc.setAllowUserInteraction(false);
        }
        catch (IOException e) {
            if (this.urlc != null) {
                this.urlc.disconnect();
            }
            throw new Exception("Connection error (is server running at " + endpoint + " ?): " + e);
        }
    }

    public Writer getDataWriter() throws IOException {
        this.out = this.urlc.getOutputStream();
        this.writer = new OutputStreamWriter(this.out, "UTF-8");
        return this.writer;
    }

    public void closeInput() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public void submit() throws IOException {
        this.in = this.urlc.getInputStream();
        this.reader = new InputStreamReader(this.in);
        String s = "";
        char[] buf = new char[2];
        int read = this.reader.read(buf);
        if (read == 0) {
            throw new IOException("No data was returned.");
        }
        for (int c = 0; c < read; ++c) {
            s = s + buf[c];
        }
        if (!s.equalsIgnoreCase("ok")) {
            char[] buf2 = new char[1024];
            while ((read = this.reader.read(buf2)) >= 0) {
                for (int c = 0; c < read; ++c) {
                    s = s + buf2[c];
                }
            }
            throw new IOException("Server response: " + s);
        }
    }

    public Reader getResultReader() throws Exception {
        if (this.reader == null) {
            throw new Exception("URL input stream reader is null. Did you submit the request??");
        }
        return this.reader;
    }

    public String getResultAsString() throws Exception {
        Reader r = this.getResultReader();
        String s = "";
        char[] buf = new char[1024];
        int read = 0;
        while ((read = r.read(buf)) >= 0) {
            for (int c = 0; c < read; ++c) {
                s = s + buf[c];
            }
        }
        return s;
    }

    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.urlc != null) {
            this.urlc.disconnect();
        }
        if (this.in != null) {
            this.in.close();
        }
    }
}

