<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes" encoding="UTF-8"
	omit-xml-declaration="no" standalone="no"
	doctype-system="http://www.musicxml.org/dtds/partwise.dtd"
	doctype-public="-//Recordare//DTD MusicXML 2.0 Partwise//EN" />
  <xsl:template match="/">
    <xsl:apply-templates select="./score-partwise"/>
    <xsl:apply-templates select="./score-timewise"/>
  </xsl:template>
  <xsl:template match="score-partwise">
    <xsl:copy-of select="." />
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="." />
  </xsl:template>
  <xsl:template match="*|@*|comment()|processing-instruction()">
    <xsl:copy><xsl:apply-templates
		select="*|@*|comment()|processing-instruction()|text()"
	/></xsl:copy>
  </xsl:template>
  <xsl:template match="score-timewise">
    <xsl:element name="score-partwise">
      <xsl:apply-templates select="@version[.!='1.0']"/>
      <xsl:apply-templates select="work"/>
      <xsl:apply-templates select="movement-number"/>
      <xsl:apply-templates select="movement-title"/>
      <xsl:apply-templates select="identification"/>
      <xsl:apply-templates select="defaults"/>
      <xsl:apply-templates select="credit"/>
      <xsl:apply-templates select="part-list"/>
      <xsl:for-each select="measure[1]/part">
        <xsl:variable name="part-id">
          <xsl:value-of select="@id"/>
        </xsl:variable>
		<xsl:element name="part">
          <xsl:copy-of select="@id" />
          <xsl:for-each select="../../measure/part">
            <xsl:if test="@id=$part-id">
             <xsl:element name="measure">
               <xsl:attribute name="number">
                  <xsl:value-of select="parent::measure/@number"/>
                </xsl:attribute>
                <xsl:if test="parent::measure/@implicit[. = 'yes']">
                  <xsl:attribute name="implicit">
                    <xsl:value-of select="parent::measure/@implicit"/>
                  </xsl:attribute>
                </xsl:if>
                <xsl:if test="parent::measure/@non-controlling[. = 'yes']">
                  <xsl:attribute name="non-controlling">
                    <xsl:value-of
                      select="parent::measure/@non-controlling"/>
                  </xsl:attribute>
                </xsl:if>
                <xsl:if test="parent::measure/@width">
                  <xsl:attribute name="width">
                    <xsl:value-of
                      select="parent::measure/@width"/>
                  </xsl:attribute>
                </xsl:if>
              <xsl:apply-templates />
              </xsl:element>
            </xsl:if>
          </xsl:for-each>
					
        </xsl:element>
      </xsl:for-each>
    </xsl:element>       
  </xsl:template>
</xsl:stylesheet>