#!/usr/bin/perl
###########################################################################
#  ErrorCkeck.pl  ver. 0.01(Sample)                                       #
#                                Masatoshi Hamanaka (11th/Sept./2009)     #
###########################################################################

   use strict;
   use File::Copy;
   use XML::Twig;
   use IO;

   use XML::Simple;

   my $filename;
   my $filename2;
   my $gprfilename;
   my $gprfilename2;
   my $mprfilename;
   my $mprfilename2;
   my $tsfilename;
   my $tsfilename2;
   my $prfilename;
   my $prfilename2;
   my $hmfilename;
   my $hmfilename2;

   my $divisions;
   my $fifths;
   my $beats;
   my $beattype;
   my $step;
   my $octave;
   my $duration;
   my $voice;
   my $type;
   my $stem;
   my $tie;
   my $chordes;
   my $NoteArray;
   my $filename;
   my $NoteCount;
   my @Group_Start;
   my @Group_End;
   my @Group_Count;
   my $Group_layer;
   my $Now_layer;
   my $top;
   my $text;
#   my $g_level;
#   my $Max_level;
#   my $g_flg=0;
   my $g_start='<group>';
   my $applied='<applied rule';
   my $g_end='</group>';
   my $n_start='<note id=';
   my $j;
   my $start=0;
   my $id1='P1-1-1';
   my $id2='P1-1-1';
   my $id3='P1-1-1';
   my $id4='P1-1-1';

   my $in;
   my $structure=" ";
   my $out;
   my $Error=0;

   die "No filename" unless @ARGV;
   $filename=$ARGV[0]; 
   $gprfilename=$ARGV[1]; 
   $mprfilename=$ARGV[2]; 
   $tsfilename=$ARGV[3]; 
   $prfilename=$ARGV[4]; 
   $hmfilename=$ARGV[5];


   use XML::Parser;
   my $parser = XML::Parser->new ( Handlers =>
                                          {
                                           Start => \&handle_start,
                                           End   => \&handle_end,
                                           });
   $parser->parsefile ($gprfilename);
   if ($Error>0){
      unlink 'Temp.txt';
      open (OUT,">Temp.txt");
      close (OUT);
      exit 2;
    }

   my $twig_1=new XML::Twig(TwigHandlers=>{
                   "part"                      => \&part,
                   "measure"                   => \&measure,
                   "note"                      => \&note_1,
                   "divisions"                 => \&divisions,
                   "fifths"                    => \&fifths,
                   "beats"                     => \&beats,
                   "beat-type"                 => \&beattype,
                   "step"                      => \&step,
                   "alter"                     => \&alter,
                   "octave"                    => \&octave,
                   "rest"                      => \&rest,
                   "duration"                  => \&duration,
                   "voice"                     => \&voice,
                   "type"                      => \&type,
                   "stem"                      => \&stem,
                   "tie"                       => \&tie,
                   "chordes"                   => \&chordes
                                       });
   $twig_1->parsefile($filename);

   $NoteCount=-1;
   $Group_layer=-1;
   $Now_layer=-1;


   open (IN,"Temp.txt");
   $in=<IN>;
   if (index($in, "G")==0){
      $structure='Grouping Structure';
   }
   if (index($in, "M")==0){
      $structure='Metrical Structure';
   }
   if (index($in, "T")==0){
      $structure='Time-span Tree';
   }
   if (index($in, "P")==0){
      $structure='Prolongational Tree';
   }
   if (index($in, "H")==0){
      $structure='Harmony Analysis';
   }
   $Error=<IN>;
   close (IN);   
   if ($Error<1){exit 0;}

   if($structure eq " "){exit 0;}

   open (OUT,">Errorcheck.txt");
       $out="$structure has error(s)! 正式版ではここにエラーの理由が出力されるかも\n";
       print OUT $out;
       print $out;
       for (my $i=1;$i<$Error+1;$i++){
          $out="Possible Correction $i: 正式版ではここに修正の内容が出力されるかも\n";

          print OUT $out;
          print $out;
#          $filename2=$filename;
#          $filename2=~s/.xml//;
#          $filename2=$filename2.'_'.$i.'.xml';

   if (index($in, "G")==0){
            $gprfilename2=$gprfilename;
            $gprfilename2=~s/.xml//;
            $gprfilename2=$gprfilename2.'_'.$i.'.xml';
            copy("$gprfilename", "$gprfilename2");
            print "$gprfilename2\n";
          }

   if (index($in, "M")==0){
            $mprfilename2=$mprfilename;
            $mprfilename2=~s/.xml//;
            $mprfilename2=$mprfilename2.'_'.$i.'.xml';
            copy("$mprfilename", "$mprfilename2");
             print "$mprfilename2\n";
         }

   if (index($in, "T")==0){
            $tsfilename2=$tsfilename;
            $tsfilename2=~s/.xml//;
            $tsfilename2=$tsfilename2.'_'.$i.'.xml';
            copy("$tsfilename", "$tsfilename2");
             print "$tsfilename2\n";
         }

   if (index($in, "P")==0){
            $prfilename2=$prfilename;
            $prfilename2=~s/.xml//;
            $prfilename2=$prfilename2.'_'.$i.'.xml';
            copy("$prfilename", "$prfilename2");
            print "$prfilename2\n";
         }

   if (index($in, "H")==0){
            $hmfilename2=$hmfilename;
            $hmfilename2=~s/.xml//;
            $hmfilename2=$hmfilename2.'_'.$i.'.xml';
            copy("$hmfilename", "$hmfilename2");
            print "$hmfilename2\n";
          }
      }
   close (OUT);
   unlink 'Temp.txt';
   open (OUT,">Temp.txt");
   close (OUT);
   exit $Error;



#Parse Grouping#############################################################

   sub handle_start{
      if ($Error eq 0){
      my ($expat, $element, $attr1, $attr2, @attrs) = @_;
      my $line = $expat->current_line;
      if ($element eq 'group'){
         if ($start eq 1){
            if ($id1 ne $id2){
#error!
                open (OUT,">Errorcheck.txt");
                $out="Error(s)!  Violate the Grouping well-formedness rule 5.  Group $id1 - $id2\n";
                print OUT $out;
                print $out;


                    
                $out="Possible Correction 1: Create a new group $id1 - $id2\n";
                print OUT $out;
                print $out;

                my $gp_flg=0;
                my $i=1;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                if ($id1 ne ~/P/){$id1='P1-1-1';}
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);
                while (my $in=<IN>){
                   if ($gp_flg eq 1){
                      if ($in=~/$g_start/){
                         print OUT2 $g_end;
                         $gp_flg=2
                      }
                   }
                   if ($in=~/$id1/){
                      if ($gp_flg eq 0){
                         print OUT2 $g_start;
                         $gp_flg=1;
                       }
                   }
                   print OUT2 $in;
                }
                close (IN);
                close (OUT2);
                print "$gprfilename2\n";


                $out="Possible Correction 2: Deleate a group $id2 - \n";
                print OUT $out;
                print $out;

                $i=2;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                $gp_flg=0;
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);

                my $s_flg=0;

                while (my $in=<IN>){
                   if ($s_flg eq 3){
                         print OUT2 $in;
                   }
                   if ($s_flg eq 2){
                      if ($in=~/$g_start/){
                            $gp_flg++;
                      }
                      if ($in=~/$g_end/){
                            $gp_flg--;
                      }
                      if ($gp_flg eq -1){
                          $s_flg=3;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 1){

                      if ($in=~/$g_start/){
                          $s_flg=2;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 0){
                      if ($in=~/$id3/){
                         $s_flg=1;
                         print OUT2 $in;
                      }
                      else {
                          print OUT2 $in;
                      }
                   }

                }
                close (IN);
                close (OUT2);

                print "$gprfilename2\n";
                close (OUT);
                unlink 'Temp.txt';
                open (OUT,">Temp.txt");
                close (OUT);
                $Error=2;
            }

         }


         if ($start eq 2){
            if ($id3 ne $id2){
#error!
                open (OUT,">Errorcheck.txt");
                $out="Error(s)!  Violate the Grouping well-formedness rule 5.  Group $id3 - $id2\n";
                print OUT $out;
                print $out;

                $out="Possible Correction 1: Create a new group $id3 - $id2\n";
                print OUT $out;
                print $out;

                my $gp_flg=0;
                my $i=1;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                if ($id1 ne ~/P/){$id1='P1-1-1';}
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);
                while (my $in=<IN>){
                   if ($in=~/$g_start/){
                      if ($gp_flg eq 3){
                         print OUT2 $g_end;
                         $gp_flg=4;
                      }
                   }
                   if ($in=~/$n_start/){
                      if ($gp_flg eq 2){
                         print OUT2 $g_start;
                         $gp_flg=3;
                      }
                   }
                   if ($gp_flg eq 1){
                      if ($in=~/$g_end/){
                         $gp_flg=2
                      }
                   }
                   if ($in=~/$id3/){
                      if ($gp_flg eq 0){
                         #print OUT2 $g_start;
                         $gp_flg=1;
                       }
                   }
                   print OUT2 $in;
                }
                close (IN);
                close (OUT2);
                print "$gprfilename2\n";

                $out="Possible Correction 2: Deleate a group $id2 - \n";
                print OUT $out;
                print $out;

                $i=2;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                $gp_flg=0;
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);

                my $s_flg=0;

                while (my $in=<IN>){
                   if ($s_flg eq 3){
                         print OUT2 $in;
                   }
                   if ($s_flg eq 2){
                      #if ($in=~/$g_start/){
                      #      $gp_flg++;
                      #}
                      #if ($in=~/$g_end/){
                      #      $gp_flg--;
                      #}
                      #if ($gp_flg eq -1){
                      #    $s_flg=3;
                      #}
                      if ($in=~/$g_end/){
                          $s_flg=3;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 1){

                      if ($in=~/$g_start/){
                          $s_flg=2;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 0){
                      if ($in=~/$id2/){
                         $s_flg=1;
                         print OUT2 $in;
                      }
                      else {
                          print OUT2 $in;
                      }
                   }
                }
                close (IN);
                close (OUT2);

                print "$gprfilename2\n";
                close (OUT);
                unlink 'Temp.txt';
                open (OUT,">Temp.txt");
                close (OUT);
                $Error=2;



            }
         }
         $start=1;
         $id1=$id2;
      }
      if ($element eq 'note'){
         $id2=$attr2;
      }
   }
   }

   sub handle_end{
      my ($expat, $element) = @_;
      if ($Error eq 0){
      if ($element eq 'group'){
         if ($start eq 2){
            if ($id3 ne $id2){
#error!
                open (OUT,">Errorcheck.txt");
                $out="Error(s)!  Violate the Grouping well-formedness rule 5. Group $id3 - $id2\n";
                print OUT $out;
                print $out;

                $out="Possible Correction 1: Create a new group $id3 - $id2\n";
                print OUT $out;
                print $out;

                my $gp_flg=0;
                my $i=1;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                if ($id1 ne ~/P/){$id1='P1-1-1';}
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);
                while (my $in=<IN>){
                   if ($gp_flg eq 1){
                      if ($in=~/$n_start/){
                         print OUT2 $g_start;
                         $gp_flg=2
                      }
                   }
                   if ($in=~/$id3/){
                      if ($gp_flg eq 0){
                         #print OUT2 $g_start;
                         $gp_flg=1;
                       }
                   }
#                   if ($in=~/$n_start/){
#                      if ($gp_flg eq 1){
#                         print OUT2 $g_start;
#                         $gp_flg=2;
#                      }
#                   }
                   if ($in=~/$g_end/){
                      if ($gp_flg eq 2){
                         print OUT2 $g_end;
                         $gp_flg=3;
                      }
                   }
                   print OUT2 $in;
                }
                close (IN);
                close (OUT2);
                print "$gprfilename2\n";


                $out="Possible Correction 2: Deleate a group $id4 - $id3\n";
                print OUT $out;
                print $out;

                $i=2;
                $gprfilename2=$gprfilename;
                $gprfilename2=~s/.xml//;
                $gprfilename2=$gprfilename2.'_'.$i.'.xml';

                $gp_flg=0;
                open (OUT2,">$gprfilename2");
                open (IN,$gprfilename);

                my $s_flg=0;

                while (my $in=<IN>){
                   if ($s_flg eq 3){
                         print OUT2 $in;
                   }
                   if ($s_flg eq 2){
                      #if ($in=~/$g_start/){
                      #      $gp_flg++;
                      #}
                      #if ($in=~/$g_end/){
                      #      $gp_flg--;
                      #}
                      #if ($gp_flg eq -1){
                      #    $s_flg=3;
                      #}
                      if ($in=~/$g_end/){
                          $s_flg=3;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 1){
                      if ($in=~/$g_start/){
                          $s_flg=2;
                      }
                      else{
                         print OUT2 $in;
                      }
                   }
                   if ($s_flg eq 0){
                      if ($in=~/$id4/){
                         $s_flg=1;
                         print OUT2 $in;
                      }
                      else {
                          print OUT2 $in;
                      }
                   }
                }
                close (IN);
                close (OUT2);

                print "$gprfilename2\n";
                #$Error=3;

                close (OUT);
                unlink 'Temp.txt';
                open (OUT,">Temp.txt");
                close (OUT);
                $Error=2;
            }

         }
         $id4=$id3;
         $id3=$id2;
         $start=2;
         }
      }

   }







#Parse MusicXML##########################################################



   sub note_1{
       my ($tree,$elem)=@_;
       if($main::rest ne '1'){
          my $note={
              "Divisons" => $main::divisions,
              "Fifths"   => $main::fifths,
              "Beats"    => $main::beats,
              "Beattype" => $main::beattype,
              "Step"     => $main::step,
              "Alter"    => $main::alter,
              "Octave"   => $main::octave,
              "Rest"     => $main::rest,
              "Duration" => $main::duration,
              "Voice"    => $main::voice,
              "Type"     => $main::type,
              "Stem"     => $main::stem,
              "Tie"      => $main::tie,
              "Chordes"  => $main::chordes,
              "Note_on"  => $main::Time/$main::divisions,
              "Note_off" => ($main::Time+$main::duration)/$main::divisions,
              "Note_num" => 12*$main::octave+$main::alter+&ValStep($main::step),
                };
          push (@$NoteArray, $note);
          $main::tie='';
      }
      $main::rest=0;
      $main::Time=$main::Time+$main::duration;
   }

   sub measure{
      my ($tree,$elem)=@_;
      my $measure=$elem->att('number');
      foreach (@$NoteArray){
         if ($_->{Measure} eq ''){$_->{Measure}=$measure;}
      }
   }

   sub part{
      my ($tree,$elem)=@_;
      my $id=$elem->att('id');
      foreach (@$NoteArray){
         if ($_->{Part_id} eq ''){$_->{Part_id}=$id;}
      }
      $main::divisions='';
      $main::fifths='';
      $main::beats='';
      $main::beattype='';
      $main::Time=0;
   }

   sub divisions{
      my($tree,$elem)=@_;
      $main::divisions=$elem->text;
   }

   sub fifths{
      my($tree,$elem)=@_;
      $main::fifths=$elem->text;
   }

   sub beats{
      my($tree,$elem)=@_;
      $main::beats=$elem->text;
   }

   sub beattype{
      my($tree,$elem)=@_;
      $main::beattype=$elem->text;
   }

   sub step{
      my($tree,$elem)=@_;
      $main::step=$elem->text;
   }

   sub alter{
      my($tree,$elem)=@_;
      $main::alter=$elem->text;
   }

   sub octave{
      my($tree,$elem)=@_;
      $main::octave=$elem->text;
   }

   sub rest{
      my($tree,$elem)=@_;
      $main::rest=1;
   }

   sub duration{
      my($tree,$elem)=@_;
      $main::duration=$elem->text;
   }

   sub voice{
      my($tree,$elem)=@_;
      $main::voice=$elem->text;
   }

   sub type{
      my($tree,$elem)=@_;
      $main::type=$elem->text;
   }

   sub stem{
      my($tree,$elem)=@_;
      $main::stem=$elem->text;
   }
   sub tie{
      my($tree,$elem)=@_;
      $main::tie=$elem->att('type');
   }

   sub chords{
      my($tree,$elem)=@_;
      $main::chords=1;
   }

   sub ValStep{
      if ($_[0] eq 'A'){return 9;}
      if ($_[0] eq 'B'){return 11;}
      if ($_[0] eq 'C'){return 0;}
      if ($_[0] eq 'D'){return 2;}
      if ($_[0] eq 'E'){return 4;}
      if ($_[0] eq 'F'){return 5;}
      if ($_[0] eq 'G'){return 7;}
   }




#Copyright (c) 2003-2009 Masatoshi Hamanaka All rights reserved.