#!/usr/bin/perl
###########################################################################
#  Grouping.pl   ver. 1.04                                                #
#                                Masatoshi Hamanaka (10th/Mar./2005)      #
###########################################################################

   use strict;
   use Tk;
   use XML::Twig;
   use XML::Writer;
   use IO;
   my $divisions;
   my $fifths;
   my $beats;
   my $beattype;
   my $step;
   my $octave;
   my $duration;
   my $voice;
   my $type;
   my $stem;
   my $tie;
   my $chordes;
   my $slur;
   my $staccato;
   my $articulation=0.9;
   my $dynamics=0.8;
   my $NoteArray;
   my $Powerd;
   my @Group_Start;
   my @Group_End;
   my @Group_Count;
   my $Group_layer;
   my $weight_GPR2a=0.5;
   my $weight_GPR2b=0.5;
   my $weight_GPR3a=0.5;
   my $weight_GPR3b=0.5;
   my $weight_GPR3c=0.5;
   my $weight_GPR3d=0.5;
   my $weight_GPR4 =0.5;
   my $weight_GPR5 =0.5;
   my $weight_GPR6 =0.5;
   my $weight_GPR6_rithm_register=0.5;
   my $weight_GPR6_start_end=0.5;
   my $weight_GPR6_length=0.5;
   my $threshold_GPR4=0.5;
   my $threshold_GPR6=0.5;
   my $threshold_low=0.5;
   my $weight_sigma=0.05;
   my $filename;
   my $GPRfilename;
   my $BaseURL;
   my $top;
   my $f0;
   my $f1;
   my $f2; 
   my $f3;  
   my $f4;
   my $f5;
   my $f_GPR2a;
   my $f_GPR2b;
   my $f_GPR3a;
   my $f_GPR3b;
   my $f_GPR3c;
   my $f_GPR3d;
   my $f_GPR4;
   my $f_GPR5;
   my $f_GPR6;
   my $f_T4;
   my $f_T6;
   my $f_Tlow;
   my $f_Sigma;
   my $f_Wr;
   my $f_Ws;
   my $f_Wl;
   my @NoteMatrix;
   my @NoteinBeats;
   my @NMatrix_Notenum;
   my $NC=0;

   die "No filename" unless @ARGV;
   $filename=$ARGV[0];   
   my $twig=new XML::Twig(TwigHandlers=>{
                   "part"                 => \&part,
                   "measure"              => \&measure,
                   "note"                 => \&note_1,
                   "divisions"            => \&divisions,
                   "fifths"               => \&fifths,
                   "beats"                => \&beats,
                   "beat-type"            => \&beattype,
                   "step"                 => \&step,
                   "alter"                => \&alter,
                   "octave"               => \&octave,
                   "rest"                 => \&rest,
                   "duration"             => \&duration,
                   "voice"                => \&voice,
                   "type"                 => \&type,
                   "stem"                 => \&stem, 
                   "tie"                  => \&tie,
                   "chordes"              => \&chordes,
                   "staccato"             => \&staccato,
                   "slur"                 => \&slur,
                   "accent"               => \&accent
                                       });
   $twig->parsefile($filename);
   &GetPowerd;
   &GetNoteMatrix;

   if ($ARGV[1] eq ''){
      $GPRfilename='GPR-'.$filename;
   }
   else{
      $GPRfilename=$ARGV[1];
   }

   if ($ARGV[2] eq ''){
      my $URL=$filename;

      $URL=~/([0-9]+)/;
      $URL=$1;
      $URL=~s/\.xml//;

      $BaseURL=qq{doc/FMPRX/}.$URL.qq{/FRAGMENTS-}.$URL.'xml';
   }
   else{
      $BaseURL=$ARGV[2];
   }

   #MainWindow
   $top=MainWindow->new();
   $top->title("Grouping.pl 1.04    $filename");

   $f1=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f0=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f2=$f0->Scrolled("Text",'-width' => 100,
                            '-height'=> 90,
                            '-wrap'  =>'none',
                            '-font'  => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
                   )->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f3=$f1->Label (        '-text'   => 'The strength of each rule',
                           '-height' => 2
                   )->pack('-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both',
                           '-pady'   => '3');

   $f_GPR2a=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR2a->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR2a->Label (       '-text'   => "GPR2a  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR2a->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_GPR2a,    
               '-command'      => \&compute_weight_GPR2a
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_GPR2b=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR2b->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR2b->Label (       '-text'   => "GPR2b  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR2b->Scale('-orient'  => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR2b,  
               '-command'      => \&compute_weight_GPR2b   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_GPR3a=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR3a->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3a->Label (       '-text'   => "GPR3a  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3a->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300, 
               '-width'        => 5,              
               '-variable'     => \$weight_GPR3a,  
               '-command'      => \&compute_weight_GPR3a   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');


   $f_GPR3b=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR3b->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3b->Label (       '-text'   => "GPR3b  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3b->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300, 
               '-width'        => 5,              
               '-variable'     => \$weight_GPR3b,  
               '-command'      => \&compute_weight_GPR3b   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f_GPR3c=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR3c->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3c->Label (       '-text'   => "GPR3c  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3c->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300, 
               '-width'        => 5,              
               '-variable'     => \$weight_GPR3c,  
               '-command'      => \&compute_weight_GPR3c   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f_GPR3d=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR3d->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3d->Label (       '-text'   => "GPR3d  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR3d->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR3d,  
               '-command'      => \&compute_weight_GPR3d   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_GPR4=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR4->Label (        '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR4->Label (        '-text'   => 'GPR4    ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR4->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR4,  
               '-command'      => \&compute_weight_GPR4   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_GPR5=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR5->Label (        '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR5->Label (        '-text'   => 'GPR5    ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR5->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR5,  
               '-command'      => \&compute_weight_GPR5   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_GPR6=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_GPR6->Label (        '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR6->Label (        '-text'   => 'GPR6    ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_GPR6->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR6,  
               '-command'      => \&compute_weight_GPR6   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f4=$f1->Label     ('-text'   => 'Threshold Parameters',
                       '-height' => 2
               )->pack('-side'   => 'top',
                       '-anchor' => 'n',
                       '-fill'   => 'both',
                       '-anchor' => 'n',
                       '-pady'   => '2');

   $f_T4=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T4->Label (          '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T4->Label (          '-text'   => 'GPR4    ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T4->Scale('-orient'      => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$threshold_GPR4,  
               '-command'      => \&compute_threshold_GPR4   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_T6=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T6->Label (          '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T6->Label (          '-text'   => 'GPR6    ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T6->Scale('-orient'      => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$threshold_GPR6,  
               '-command'      => \&compute_threshold_GPR6   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');
   $f_Tlow=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Tlow->Label (        '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Tlow->Label (        '-text'   => 'low-level',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Tlow->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 250,  
               '-width'        => 5,             
               '-variable'     => \$threshold_low,  
               '-command'      => \&compute_weight_GPRSum   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f5=$f1->Label     ('-text'   => 'Other Parameters',
                       '-height' => 2
               )->pack('-side'   => 'top',
                       '-fill'   => 'both',
                       '-anchor' => 'n',
                       '-pady'   => '5');

   $f_Sigma=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Sigma->Label (        '-text'   => 'Sigma',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Sigma->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 0.1,  
               '-resolution'   => 0.01,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_sigma,  
               '-command'      => \&compute_weight_sigma   
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f_Wr=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Wr->Label (          '-text'   => 'W',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wr->Label (          '-text'   => 'r          ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wr->Scale('-orient'      => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR6_rithm_register,  
               '-command'      => \&compute_weight_GPR6_rithm_register
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

   $f_Ws=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Ws->Label (          '-text'   => 'W',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Ws->Label (          '-text'   => 's          ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Ws->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR6_start_end,  
               '-command'      => \&compute_weight_GPR6_start_end
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_Wl=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Wl->Label (          '-text'   => 'W',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wl->Label (          '-text'   => 'l          ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wl->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_GPR6_length,  
               '-command'      => \&compute_weight_GPR6_length
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   MainLoop();

   sub compute_weight_GPR2a {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR2b {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR3a {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR3b {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR3c {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR3d {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR4 {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR5 {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR6 {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_threshold_GPR4 {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_threshold_GPR6 {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR6_rithm_register {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR6_start_end {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPR6_length {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_GPRSum {
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

   sub compute_weight_sigma {
       if ($weight_sigma==0){$weight_sigma=0.01;}
       $Group_layer=&Grouping;
       &XMLOut_Grouping($Group_layer);
       &Print_Grouping($Group_layer);
   }

#Grouping structure#############################################################

   sub Grouping{
      my $i;
      my $j;
      my $Para;
      my $Layer=0;
      my $ArrayCount=@$NoteArray;
      foreach(@$NoteArray){
         $_->{GPR2a}='';
         $_->{GPR2b}='';
         $_->{GPR3a}='';
         $_->{GPR3d}='';
         $_->{GPR4}='';
         $_->{GPR5}='';
         $_->{GPR6}='';
         $_->{GPR6start}='';
         $_->{GPR6end}='';
         $_->{GPRSum}=0;
         $_->{GPRAll}='';
         $_->{LowLevelboundary}='';
      }

      $NoteArray->[0]{GPR2a}=1;
      for($i=0;$i<@$NoteArray-3;$i++){

          #GPR2a Slur/Rest
          my $Interval1=$NoteArray->[$i+1]{Note_on}-$NoteArray->[$i  ]{Note_off};
          my $Interval2=$NoteArray->[$i+2]{Note_on}-$NoteArray->[$i+1]{Note_off};
          my $Interval3=$NoteArray->[$i+3]{Note_on}-$NoteArray->[$i+2]{Note_off};
          if ($Interval1<$Interval2 && $Interval2>$Interval3){
             $NoteArray ->[$i+2]{GPR2a}=1;
          }
          if (($Interval1+$Interval2+$Interval3)*$threshold_GPR4<$Interval2){
             if ($NoteArray ->[$i+2]{GPR2a} eq 1){
                $NoteArray ->[$i+2]{GPR4}=1;
             }
          }
          if ($NoteArray->[$i+1]{Slur} eq 'stop'){
             $NoteArray ->[$i+2]{GPR2a}=1;
          }
      
          #GPR2b Attack-Point
          $Interval1=$NoteArray->[$i+1]{Note_on}-$NoteArray->[$i  ]{Note_on};
          $Interval2=$NoteArray->[$i+2]{Note_on}-$NoteArray->[$i+1]{Note_on};
          $Interval3=$NoteArray->[$i+3]{Note_on}-$NoteArray->[$i+2]{Note_on};
          if ($Interval1<$Interval2 && $Interval2>$Interval3){
             $NoteArray->[$i+2]{GPR2b}=1;
          }
          if (($Interval1+$Interval2+$Interval3)*$threshold_GPR4<$Interval2){
             if ($NoteArray ->[$i+2]{GPR2b} eq 1){
                $NoteArray ->[$i+2]{GPR4}=1;
             }
          }

          #GPR3a Register
          my $Register1=abs($NoteArray->[$i  ]{Note_num}-$NoteArray->[$i+1]{Note_num});
          my $Register2=abs($NoteArray->[$i+1]{Note_num}-$NoteArray->[$i+2]{Note_num});
          my $Register3=abs($NoteArray->[$i+2]{Note_num}-$NoteArray->[$i+3]{Note_num});
          if ($Register1<$Register2 && $Register2>$Register3){
             $NoteArray->[$i+2]{GPR3a}=1;
          }
          if (($Register1+$Register2+$Register3)*$threshold_GPR4<$Register2){
             if ($NoteArray ->[$i+2]{GPR3a} eq 1){
                $NoteArray ->[$i+2]{GPR4}=1;
             }
          }

          #GPR3b dynamics
          if (($NoteArray->[$i  ]{Dynamics} eq $NoteArray->[$i+1]{Dynamics})  &&
              ($NoteArray->[$i+2]{Dynamics} eq $NoteArray->[$i+3]{Dynamics})  &&
              ($NoteArray->[$i+1]{Dynamics} ne $NoteArray->[$i+2]{Dynamics})){
             $NoteArray->[$i+2]{GPR3b}=1;
          } 
          my $s_dyn=abs($NoteArray->[$i  ]{Dynamics}-$NoteArray->[$i+1]{Dynamics})
                   +abs($NoteArray->[$i+2]{Dynamics}-$NoteArray->[$i+3]{Dynamics})
                   +abs($NoteArray->[$i+1]{Dynamics}-$NoteArray->[$i+2]{Dynamics});
          if ($s_dyn>0){
             if ($s_dyn*$threshold_GPR4<abs($NoteArray->[$i+1]{Dynamics}
                                           -$NoteArray->[$i+2]{Dynamics})){
                $NoteArray ->[$i+2]{GPR4}=1;
             }

          }

          #GPR3c articulation
          if (($NoteArray->[$i  ]{Articulation} eq $NoteArray->[$i+1]{Articulation})  &&
              ($NoteArray->[$i+2]{Articulation} eq $NoteArray->[$i+3]{Articulation})  &&
              ($NoteArray->[$i+1]{Articulation} ne $NoteArray->[$i+2]{Articulation})){
             $NoteArray->[$i+2]{GPR3c}=1;
          } 
          my $s_arti=abs($NoteArray->[$i  ]{Articulation}-$NoteArray->[$i+1]{Articulation})
                    +abs($NoteArray->[$i+2]{Articulation}-$NoteArray->[$i+3]{Articulation})
                    +abs($NoteArray->[$i+1]{Articulation}-$NoteArray->[$i+2]{Articulation});
          if ($s_arti>0){
             if ($s_arti*$threshold_GPR4<abs($NoteArray->[$i+1]{Articulation}
                                            -$NoteArray->[$i+2]{Articulation})){
                $NoteArray ->[$i+2]{GPR4}=1;
             }
          }

          #GPR3d Length
          if (($NoteArray->[$i  ]{Type} eq $NoteArray->[$i+1]{Type})  &&
              ($NoteArray->[$i+2]{Type} eq $NoteArray->[$i+3]{Type})  &&
              ($NoteArray->[$i+1]{Type} ne $NoteArray->[$i+2]{Type})){
             $NoteArray->[$i+2]{GPR3d}=1;
          } 
      }
 
      #GPR6 Parallelism
      &GroupingParallelism;

      my $MaxGPRSum=0;
      foreach(@$NoteArray){
         $_->{GPRSum}=$_->{GPR2a}*$weight_GPR2a+$_->{GPR2b}*$weight_GPR2b
                     +$_->{GPR3a}*$weight_GPR3a+$_->{GPR3b}*$weight_GPR3b
                     +$_->{GPR3c}*$weight_GPR3c+$_->{GPR3d}*$weight_GPR3d
                     +$_->{GPR6} *$weight_GPR6;
         if ($MaxGPRSum < $_->{GPRSum}){
            $MaxGPRSum=$_->{GPRSum};
         }
      }
      foreach(@$NoteArray){
         if ($_->{GPRSum}>0){
            $_->{GPRSum}=$_->{GPRSum}/$MaxGPRSum;
         }
      }

      #low-level boundary (GPR2a,GPR2b,GPR3a,GPR3b,GPR3c,GPR3d,GPR6) 
      my $MaxGroup_Count=0;
      for ($i=2;$i<@$NoteArray-2;$i++){
         if ($NoteArray->[$i]{GPRSum}>$threshold_low 
          && $NoteArray->[$i-1]{GPRSum}<=$NoteArray->[$i]{GPRSum} 
          && $NoteArray->[$i]{GPRSum}>=$NoteArray->[$i+1]{GPRSum}){
            $MaxGroup_Count++;
            $NoteArray->[$i]{LowLevelboundary}=1;
            $i++;
         }
      }

      #High-level Grouping (GPR4,GPR5,GPR6)
      $Group_Count[0]=0;
      $Group_Start[0]->[0]=0;
      $Group_End[0]->[0]=@$NoteArray-1;

      $Layer=0;
      while ($Group_Count[$Layer]<$MaxGroup_Count){
         $Layer++;
         $Group_Count[$Layer]=-1;
         for ($i=0;$i<=$Group_Count[$Layer-1];$i++){
            my $Start=$Group_Start[$Layer-1]->[$i];
            my $End=$Group_End[$Layer-1]->[$i];
            my $G_Count=0;
            my @boundary;
            my $u=($NoteArray->[$Start]{Note_on}+$NoteArray->[$End]{Note_off})/2;
            my $s=$NoteArray->[$End]{Note_off}-$NoteArray->[$Start]{Note_on};
            for ($j=$Start+1;$j<=$End;$j++){
               if ($NoteArray->[$j]{LowLevelboundary}==1){
                  $NoteArray->[$j]{GPR5}=1/((2*3.14)**0.5*$weight_sigma*$s)
                     *exp(-($NoteArray->[$j]{Note_on}-$u)**2/(2*($weight_sigma*$s)**2));
                  $G_Count++;
                  $boundary[$G_Count]=$j;
                  $NoteArray->[$j]{GPRAll}=$NoteArray->[$j]{GPR2a}*$weight_GPR2a
                                          +$NoteArray->[$j]{GPR2b}*$weight_GPR2b
                                          +$NoteArray->[$j]{GPR3a}*$weight_GPR3a
                                          +$NoteArray->[$j]{GPR3d}*$weight_GPR3d
                                          +$NoteArray->[$j]{GPR4}*$weight_GPR4
                                          +$NoteArray->[$j]{GPR5}*$weight_GPR5;
                                          +$NoteArray->[$j]{GPR6} *$weight_GPR6
               }
            }
            if ($G_Count==0){
               $Group_Count[$Layer]++;
               $Group_Start[$Layer]->[$Group_Count[$Layer]]=$Start;
               $Group_End[$Layer]->[$Group_Count[$Layer]]=$End;   
            }
            elsif($G_Count==1){
               $Group_Count[$Layer]++;
               $Group_Start[$Layer]->[$Group_Count[$Layer]]=$Start;
               $Group_End[$Layer]->[$Group_Count[$Layer]]=$boundary[1]-1;
               $Group_Count[$Layer]++;
               $Group_Start[$Layer]->[$Group_Count[$Layer]]=$boundary[1];
               $Group_End[$Layer]->[$Group_Count[$Layer]]=$End;             
            }
            else{
               my $MaxGPRAll=0;
               my $MaxGPRAll_note=0;
               for($j=1;$j<=$G_Count;$j++){
                  if ($MaxGPRAll<$NoteArray->[$boundary[$j]]{GPRAll}){
                     $MaxGPRAll=$NoteArray->[$boundary[$j]]{GPRAll};
                     $MaxGPRAll_note=$j;
                  }
               }
               $Group_Count[$Layer]++;
               $Group_Start[$Layer]->[$Group_Count[$Layer]]=$Start;
               $Group_End[$Layer]->[$Group_Count[$Layer]]=$boundary[$MaxGPRAll_note]-1;
               $Group_Count[$Layer]++;
               $Group_Start[$Layer]->[$Group_Count[$Layer]]=$boundary[$MaxGPRAll_note];
               $Group_End[$Layer]->[$Group_Count[$Layer]]=$End;    
            }
         }
      }
      &Reverse_Group($Layer);
      return $Layer;
   }

   sub Reverse_Group{
      my @G_Start;
      my @G_End;
      my @G_Count;
      my $Layer=$_[0];
      for (my $i=0;$i<=$Layer;$i++){
         $G_Count[$i]=$Group_Count[$i];
         for (my $j=0;$j<=$G_Count[$i];$j++){
            $G_Start[$i]->[$j]=$Group_Start[$i]->[$j];
            $G_End[$i]->[$j]=$Group_End[$i]->[$j];
         }
      }
      for (my $i=0;$i<=$Layer;$i++){
         $Group_Count[$i]=$G_Count[$Layer-$i];
         for (my $j=0;$j<=$G_Count[$Layer-$i];$j++){
            $Group_Start[$i]->[$j]=$G_Start[$Layer-$i]->[$j];
            $Group_End[$i]->[$j]=$G_End[$Layer-$i]->[$j];
         }
      }
   }

   sub GroupingParallelism{
      my $NCount;
      my $NCount_2;
      my $NCount_3;
      my $register;
      my $register_2;
      my $i;
      my $GPR6;
      my $MaxGPR6;
      my $Maxbeat=int($NoteArray->[@$NoteArray-1]{Note_off});
      for (my $beatcount=1;$beatcount<=$Maxbeat/2;$beatcount++){
         for (my $start_1=0;$start_1<=$Maxbeat-2*$beatcount+1;$start_1++){
            for (my $start_2=$start_1+$beatcount;$start_2<=$Maxbeat-$beatcount+1;$start_2++){
               $NCount=0;
               for ($i=0;$i<$beatcount;$i++){
                  $NCount=$NCount+$NoteinBeats[$start_1+$i]+$NoteinBeats[$start_2+$i];
               }
               $NCount_2=0;
               $NCount_3=0;
               $register="";
               foreach(@$NoteArray){
                  if ($start_1<=int($_->{Note_on}) && 
                      int($_->{Note_on})<$start_1+$beatcount && $_->{Note_num}>0){
                     if ($NoteMatrix[($_->{Note_on}+($start_2-$start_1))*$Powerd]>0){
                        $NCount_2++;
                        $register_2=$NoteMatrix[$_->{Note_on}*$Powerd]
                                   -$NoteMatrix[($_->{Note_on}+($start_2-$start_1))*$Powerd];
                        if ($register==$register_2){
                           $NCount_3++;
                        }
                        $register=$register_2;
                     }
                  }                
               }
               if ($NCount_2>2){
                  $GPR6=(2*$NCount_2/$NCount*(1-$weight_GPR6_rithm_register)
                         +$NCount_3/($NCount_2-1)*$weight_GPR6_rithm_register)/2
                         *(1+$weight_GPR6_length)**$beatcount;
                  &GPR6start($start_1,$GPR6);
                  &GPR6end  ($start_1+$beatcount,$GPR6);
                  &GPR6start($start_2,$GPR6);
                  &GPR6end  ($start_2+$beatcount,$GPR6);
                  $start_2=$Maxbeat-$beatcount+2;

               }
            }
         }
      }
      $MaxGPR6=0;
      foreach(@$NoteArray){
         $_->{GPR6}=$_->{GPR6start}*(1-$weight_GPR6_start_end)+$_->{GPR6end}*$weight_GPR6_start_end;
         if ($MaxGPR6 < $_->{GPR6}){
            $MaxGPR6=$_->{GPR6};
         }
      }
      if ($MaxGPR6>0){
         foreach(@$NoteArray){
            $_->{GPR6}=$_->{GPR6}/$MaxGPR6;
         }
      }
   }

#XMLOut Grouping#############################################################

   sub XMLOut_Grouping{
      my $i;
      my $j;
      my $Count=0;
      my $Group_Count;
      my $Layer=$_[0];
      my $output=new IO::File(">$GPRfilename");
      my $writer = new XML::Writer(OUTPUT => $output,DATA_MODE => 'true',DATA_INDENT=>2);
      my $link1=qq{xmlns:GTTM};
      my $link2=qq{xmlns:mr};
      my $link3=qq{xmlns:xlink};
      my $link4=qq{xmlns:xsi};
      my $link5=qq{xsi:SchemaLocation};
      my $link6=qq{xml:base};

      $writer->xmlDecl( 'UTF-8' );
      $writer->startTag( 'GPR',$link1=> "http://www.dacreation.com/ns/GTTM",
                               $link2=> "http://www.dacreation.com/ns/MusicResonator",
                               $link3=> "http://www.w3.org/1999/xlink",
                               $link4=> "http://www.w3.org/2001/XMLSchema-instance",
                               $link5=> 
      "http://www.dacreation.com/ns/GTTM http://www.dacreation.com/ns/GTTM/ts.xsd",
                               $link6=> $BaseURL,);


      foreach (@$NoteArray){
          $Group_Count=0;
          unless ($Count==0){
             for ($i=0;$i<$Layer;$i++){
                for ($j=0;$j<=$Group_Count[$i];$j++){
                   if ($Group_Start[$i]->[$j]==$Count){
                      $Group_Count++;
                      last;
                   }
                }
             }
          }
          for ($i=0;$i<$Group_Count;$i++){
             $writer->endTag( 'group' );
          }
#          if (($_->{GPR2a}==1)||($_->{GPR2b}==1)||($_->{GPR3a}==1)||($_->{GPR3b}==1)
#            ||($_->{GPR3c}==1)||($_->{GPR3d}==1)||($_->{GPR4}==1 )||($_->{GPR6}>$threshold_GPR6)){
#             $writer->startTag( 'rule' );
#             if ($_->{GPR2a}==1){$writer->dataElement('applied','2a');}
#             if ($_->{GPR2b}==1){$writer->dataElement('applied','2b');}
#             if ($_->{GPR3a}==1){$writer->dataElement('applied','3a');}
#             if ($_->{GPR3b}==1){$writer->dataElement('applied','3b');}
#             if ($_->{GPR3c}==1){$writer->dataElement('applied','3c');}
#             if ($_->{GPR3d}==1){$writer->dataElement('applied','3d');}
#             if ($_->{GPR4}==1 ){$writer->dataElement('applied','4');}
#             if ($_->{GPR6}>$threshold_GPR6){$writer->dataElement('applied','6');}  
#             $writer->endTag( 'rule' );
#          }

          if ($_->{GPR2a}==1){$writer->emptyTag('applied','rule'=>'2a');}
          if ($_->{GPR2b}==1){$writer->emptyTag('applied','rule'=>'2b');}
          if ($_->{GPR3a}==1){$writer->emptyTag('applied','rule'=>'3a');}
          if ($_->{GPR3b}==1){$writer->emptyTag('applied','rule'=>'3b');}
          if ($_->{GPR3c}==1){$writer->emptyTag('applied','rule'=>'3c');}
          if ($_->{GPR3d}==1){$writer->emptyTag('applied','rule'=>'3d');}
          if ($_->{GPR4}==1 ){$writer->emptyTag('applied','rule'=>'4');}
          if ($_->{GPR6}>$threshold_GPR6){$writer->emptyTag('applied','rule'=>'6');}

          if ($_->{Note_on}==0){
             for ($i=0;$i<=$Layer;$i++){
                $writer->startTag( 'group' );
             }
          }
          for ($i=0;$i<$Group_Count;$i++){
             $writer->startTag( 'group' );
          }
#          $writer->emptyTag( 'mr:note',id=>"$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}" );

          my $link7=qq{xlink:herf};
          my $link8=qq{#xpointer(id('};
          my $link9=qq{'))};
          $link8=$link8."$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}".$link9;
#          $writer->emptyTag(qq{mr:fragment}, $link7=>$link8);
          $writer->emptyTag(qq{note},id=>qq{$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}}, $link7=>$link8);

          $Count++;
      }
      for ($i=0;$i<=$Layer;$i++){
         $writer->endTag( 'group' );
      }
      $writer->endTag('GPR');
      $writer->end();
   }

#Print Grouping#############################################################

   sub Print_Grouping{
      my $Layer=$_[0];     
      my $Count=0;
      my $j;
      my $n;
      open (OUT,">TempG");   
      foreach(@$NoteArray){
         print OUT "     ";
         for (my $L=0;$L<=$Layer;$L++){
            $n=0;
            for ($j=0;$j<=$Group_Count[$L];$j++){
               if ($Group_Start[$L]->[$j]==$Count){
                  $n++;
               }
            }
            if ($n>0){
               print OUT "\t--"
            }
            else{
               print OUT "\t |"
            }
         }
         print OUT "\t";
            if ($NoteArray->[$Count]{GPR2a}>0){print OUT " GPR2a";}
            if ($NoteArray->[$Count]{GPR2b}>0){print OUT " GPR2b";}
            if ($NoteArray->[$Count]{GPR3a}>0){print OUT " GPR3a";}
            if ($NoteArray->[$Count]{GPR3b}>0){print OUT " GPR3b";}
            if ($NoteArray->[$Count]{GPR3c}>0){print OUT " GPR3c";}
            if ($NoteArray->[$Count]{GPR3d}>0){print OUT " GPR3d";}
            if ($NoteArray->[$Count]{GPR4}>0){print OUT " GPR4";}
            if ($NoteArray->[$Count]{GPR6}>$threshold_GPR6){print OUT " GPR6";}  
            if ($NoteArray->[$Count]{GPRSum}>0){print OUT " \($NoteArray->[$Count]{GPRSum}\)";}        
            $Count++;
            print OUT "\nNote$Count";
            for ($j=0;$j<=$Layer;$j++){
               print OUT "\t |";
            }
            print OUT "\n";
      }
      print OUT "     \t";
      for ($j=0;$j<=$Layer;$j++){
          print OUT "--\t";
      }
      print OUT " GPR2a";
      if ($weight_GPR2a>$weight_GPR4){
         print OUT " GPR4";
      }
      print OUT "\n";
      close(OUT);
      (my $top,my $bottom)=$f2->yview();
      $f2->delete("1.0",'end');
      open (IN,"TempG");
      while (<IN>){
         $f2->insert("end",$_);
      }
      close(IN);
      $f2->yviewMoveto($top);
   }

   sub note_1{
       $main::NC++;
       my ($tree,$elem)=@_;
       if($main::tie ne 'stop'){
          if($main::rest ne '1'){
             my $note={
                 "Divisons" => $main::divisions,
                 "Fifths"   => $main::fifths,
                 "Beats"    => $main::beats,
                 "Beattype" => $main::beattype,
                 "Step"     => $main::step,
                 "Alter"    => $main::alter,
                 "Octave"   => $main::octave,
                 "Rest"     => $main::rest,
                 "Duration" => $main::duration,
                 "Voice"    => $main::voice,
                 "Type"     => $main::type,
                 "Stem"     => $main::stem,
                 "Tie"      => $main::tie,
                 "Chordes"  => $main::chordes,
                 "Note_on"  => $main::Time/$main::divisions,
                 "Note_off" => ($main::Time+$main::duration)/$main::divisions,
                 "Note_num" => 12*$main::octave+$main::alter+&ValStep($main::step),
                 "Note_Count"   => $main::NC,
                   };
             push (@$NoteArray, $note);
         }
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
      }
      else{
         $NoteArray->[@$NoteArray-1]{Note_off}=($main::Time+$main::duration)/$main::divisions;
         $NoteArray->[@$NoteArray-1]{Duration}=$NoteArray->[@$NoteArray-1]{Duration}+$main::duration;
         $NoteArray->[@$NoteArray-1]{Type}="$NoteArray->[@$NoteArray-1]{Type}$main::type";
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
         $main::tie='';
      }
   }


   sub measure{
         my ($tree,$elem)=@_;
         my $measure=$elem->att('number');
         foreach (@$NoteArray){
            if ($_->{Measure} eq ''){$_->{Measure}=$measure;}
         }
      $main::NC=0;
   }

   sub part{
      my ($tree,$elem)=@_;
      my $id=$elem->att('id');
      foreach (@$NoteArray){
         if ($_->{Part_id} eq ''){$_->{Part_id}=$id;}
      }
      $main::divisions='';
      $main::fifths='';
      $main::beats='';
      $main::beattype='';
      $main::Time=0;
   }

   sub divisions{
      my($tree,$elem)=@_;
      $main::divisions=$elem->text;
   }

   sub fifths{
      my($tree,$elem)=@_;
      $main::fifths=$elem->text;
   }

   sub beats{
      my($tree,$elem)=@_;
      $main::beats=$elem->text;
   }

   sub beattype{
      my($tree,$elem)=@_;
      $main::beattype=$elem->text;
   }

   sub step{
      my($tree,$elem)=@_;
      $main::step=$elem->text;
   }

   sub alter{
      my($tree,$elem)=@_;
      $main::alter=$elem->text;
   }

   sub octave{
      my($tree,$elem)=@_;
      $main::octave=$elem->text;
   }

   sub rest{
      my($tree,$elem)=@_;
      $main::rest=1;
   }

   sub duration{
      my($tree,$elem)=@_;
      $main::duration=$elem->text;
   }

   sub voice{
      my($tree,$elem)=@_;
      $main::voice=$elem->text;
   }

   sub type{
      my($tree,$elem)=@_; 
      $main::type=$elem->text;
   }

   sub stem{
      my($tree,$elem)=@_;
      $main::stem=$elem->text;
   }

   sub tie{
      my($tree,$elem)=@_;
      if ($main::tie ne 'stop'){
         $main::tie=$elem->att('type');
      }
   }

   sub chords{
      my($tree,$elem)=@_;
      $main::chords=1;
   }

   sub slur{
      my($tree,$elem)=@_;
      $main::slur=$elem->att('type');
      if ($main::slur eq 'start'){
         $main::articulation=1;
      }
      else{
         $main::articulation=0.8;
      }
   }

   sub staccato{
      $main::staccato="staccato";
      $main::articulation=0.5;
   }

   sub accent{
      $main::dynamics=1;
   }

   sub ValStep{
      if ($_[0] eq 'A'){return 9;}
      if ($_[0] eq 'B'){return 11;}
      if ($_[0] eq 'C'){return 0;}
      if ($_[0] eq 'D'){return 2;}
      if ($_[0] eq 'E'){return 4;}
      if ($_[0] eq 'F'){return 5;}
      if ($_[0] eq 'G'){return 7;}
   }

   sub GetPowerd{
      my $i=0;
      my $Non;
      my $Noff;
      $Powerd=1;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            $Powerd=$Powerd*210;
            $i=0;
         }
         else{
            last;
         }
      }
      $i=0;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/2;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*2;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/3;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*3;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/5;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*5;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/7;
            $i=0;
         }
      }
      $Powerd=$Powerd*7;
   }

   sub GetNoteMatrix{
      my $i=0;
      foreach(@$NoteArray){
         if ($_->{Note_num}>0){
            $NoteMatrix[$_->{Note_on}*$Powerd]=$_->{Note_num};
            $NoteinBeats[int($_->{Note_on})]++;
            $NMatrix_Notenum[$_->{Note_on}*$Powerd]=$i;
         }
         $i++;
      }
   }

   sub GPR6start{
      my $beat=$_[0];
      my $GPR6=$_[1];
      foreach(@$NoteArray){
         if (int($_->{Note_on})==$beat){
            $_->{GPR6start}=$_->{GPR6start}+$GPR6;
            return;
         }
      }
   }

   sub GPR6end{
      my $beat=$_[0];
      my $GPR6=$_[1];
      foreach(@$NoteArray){
         if (int($_->{Note_on})==$beat){
            $_->{GPR6end}=$_->{GPR6end}+$GPR6;
            return;
         }
      }
   }

#Copyright (c) 2003-2005 Masatoshi Hamanaka All rights reserved.