#!/usr/bin/perl
###########################################################################
#  Metrical  ver. 1.02                                                    #
#                                Masatoshi Hamanaka (11st/Mar./2004)      #
###########################################################################

   use strict;
   use Tk;
   use XML::Twig;
   use XML::Writer;
   use IO;
   my $divisions;
   my $fifths;
   my $beats;
   my $beattype;
   my $step;
   my $octave;
   my $duration;
   my $voice;
   my $type;
   my $stem;
   my $tie;
   my $chordes;
   my $slur;
   my $dynamics=0.8;
   my $NoteArray;
   my $MetArray;
   my $filename;
   my $GPRfilename;
   my $MPRfilename;
   my $BaseURL;
   my $top;
   my $f0;
   my $f1;
   my $f2;
   my $f3;
   my $f4; 
   my $f5;
   my $f_MPR1;
   my $f_MPR2;
   my $f_MPR3;
   my $f_MPR4;
   my $f_MPR5a;
   my $f_MPR5b;
   my $f_MPR5c;
   my $f_MPR5d;
   my $f_MPR5e;
   my $f_MPR10;
   my $f_T1;
   my $f_T4;
   my $f_T5a;
   my $f_T5b;
   my $f_T5c;
   my $f_Wr;
   my $NoteCount;
   my @Group_Start;
   my @Group_End;
   my @Group_Count;
   my $Group_layer;
   my $Now_layer;
   my $top;
   my $text;
   my $g_level;
   my $Max_level;
   my $g_flg=0;
   my $g_start='<group>';
   my $g_end='</group>';
   my @M2N;
   my $Metrical_level;
   my $weight_MPR1=0.5;
   my $weight_MPR2=0.5;
   my $weight_MPR3=0.5;
   my $weight_MPR4=0.5;
   my $weight_MPR5a=0.5;
   my $weight_MPR5b=0.5;
   my $weight_MPR5c=0.5;
   my $weight_MPR5d=0.5;
   my $weight_MPR5e=0.5;
   my $weight_MPR10=0.5;
   my $threshold_MPR1=0.5;
   my $threshold_MPR4=0.5;
   my $threshold_MPR5a=0.5;
   my $threshold_MPR5b=0.5;
   my $threshold_MPR5c=0.5;
   my $weight_MPR1_rithm_register=0.5;
   my $weight_MPR1_length=0.5;
   my $Powerd;
   my @NoteMatrix;
   my $M=0;
   my @Level;
   my $NC=0;


   die "No filename" unless @ARGV;
   $filename=$ARGV[0];    
   my $twig_1=new XML::Twig(TwigHandlers=>{
                   "part"                 => \&part,
                   "measure"              => \&measure,
                   "note"                 => \&note_1,
                   "divisions"            => \&divisions,
                   "fifths"               => \&fifths,
                   "beats"                => \&beats,
                   "beat-type"            => \&beattype,
                   "step"                 => \&step,
                   "alter"                => \&alter,
                   "octave"               => \&octave,
                   "rest"                 => \&rest,
                   "duration"             => \&duration,
                   "voice"                => \&voice,
                   "type"                 => \&type,
                   "stem"                 => \&stem, 
                   "tie"                  => \&tie,
                   "chordes"              => \&chordes,
                   "staccato"             => \&staccato,
                   "slur"                 => \&slur,
                   "accent"               => \&accent
                                       });
   $twig_1->parsefile($filename);

   $NoteCount=-1;
   $Group_layer=-1;
   $Now_layer=-1;

   if ($ARGV[1] eq ''){
      $GPRfilename='GPR-'.$filename;
   }
   else{
      $GPRfilename=$ARGV[1];
   }
   if ($ARGV[2] eq ''){
      $MPRfilename='MPR-'.$filename;
   }
   else{
      $MPRfilename=$ARGV[2];
   }
   if ($ARGV[3] eq ''){
      my $URL=$filename;

      $URL=~/([0-9]+)/;
      $URL=$1;
      $URL=~s/\.xml//;

      $BaseURL=qq{doc/FMPRX/}.$URL.qq{/FRAGMENTS-}.$URL.'xml';
   }
   else{
      $BaseURL=$ARGV[3];
   }

   open (OUT,">Temp_1");
   open (IN,"$GPRfilename");
   while (my $in=<IN>){
      $in=~s/$g_start/$g_start."\n"/;
      print OUT $in;
   }
   close (IN);
   close (OUT);

   $g_level=-1;
   $Max_level=0;
   open (IN,"Temp_1");
   while(my $in=<IN>){
      if ($in=~/$g_start/){
         $g_level++;
         if ($g_level>$Max_level){
            $Max_level=$g_level;
         }
      }
      if ($in=~/$g_end/){
         $g_level--;
      }
   }
   close (IN);

   open (OUT,">Temp_2");
   open (IN,"Temp_1");
   while (my $in=<IN>){
      if ($in=~/$g_start/){
         $g_level++;
         my $level=$Max_level-$g_level;
         $in=q{<group level="}.$level.q{">}."\n";
      }
      if ($in=~/$g_end/){
         $g_level--;
      }      
      print OUT $in;
   }
   close (IN);
   close (OUT);

   my $twig_2=new XML::Twig(TwigHandlers=>{
                   "group"                    => \&group,
                   "note"                     => \&note_2,
                   "mr:note"                  => \&note_2,
                   "mr:fragment"              => \&note_2,
                   "applied"                  => \&applied,

                                       });
   $twig_2->parsefile('Temp_2');

   #MainWindow
   $top=MainWindow->new();
   $top->title("Metrical.pl 1.02    $filename");

   $f1=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f0=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f2=$f0->Scrolled("Text",'-width' => 200,
                            '-height'=> 90,
                            '-wrap'  =>'none',
                            '-font'  => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
                   )->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f3=$f1->Label (        '-text'   => 'The strength of each rule',
                           '-height' => 2
                   )->pack('-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both',
                           '-pady'   => '3');

   $f_MPR1=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR1->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR1->Label (       '-text'   => "MPR1    ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR1->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR1,  
               '-command'      => \&compute_weight_MPR1   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR2=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR2->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR2->Label (       '-text'   => "MPR2    ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR2->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR2,  
               '-command'      => \&compute_weight_MPR2   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR3=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR3->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR3->Label (       '-text'   => "MPR3    ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR3->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,  
               '-variable'     => \$weight_MPR3,  
               '-command'      => \&compute_weight_MPR3            
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR4=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR4->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR4->Label (       '-text'   => "MPR4    ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR4->Scale('-orient'    => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR4,  
               '-command'      => \&compute_weight_MPR4   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR5a=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR5a->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5a->Label (       '-text'   => "MPR5a  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5a->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR5a,  
               '-command'      => \&compute_weight_MPR5a   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR5b=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR5b->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5b->Label (       '-text'   => "MPR5b  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5b->Scale('-orient'       => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_MPR5b,  
               '-command'      => \&compute_weight_MPR5b   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR5c=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR5c->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5c->Label (       '-text'   => "MPR5c  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5c->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_MPR5c,  
               '-command'      => \&compute_weight_MPR5c   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR5d=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR5d->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5d->Label (       '-text'   => "MPR5d  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5d->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR5d,  
               '-command'      => \&compute_weight_MPR5d   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR5e=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR5e->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5e->Label (       '-text'   => "MPR5e  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR5e->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR5e,  
               '-command'      => \&compute_weight_MPR5e   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_MPR10=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_MPR10->Label (       '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR10->Label (       '-text'   => "MPR10  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_MPR10->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$weight_MPR10,  
               '-command'      => \&compute_weight_MPR10   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f4=$f1->Label     ('-text'   => 'Threshold Parameters',
                       '-height' => 2
               )->pack('-side'   => 'top',
                       '-anchor' => 'n',
                       '-fill'   => 'both',
                       '-anchor' => 'n',
                       '-pady'   => '2');

   $f_T1=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T1->Label (       '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T1->Label (       '-text'   => "MPR1  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T1->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$threshold_MPR1,  
               '-command'      => \&compute_threshold_MPR1   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_T4=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T4->Label (          '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T4->Label (       '-text'   => "MPR4  ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T4->Scale('-orient'      => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$threshold_MPR4,  
               '-command'      => \&compute_threshold_MPR4   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_T5a=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T5a->Label (         '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5a->Label (         '-text'   => "MPR5a ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5a->Scale('-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,
               '-width'        => 5,           
               '-variable'     => \$threshold_MPR5a,  
               '-command'      => \&compute_threshold_MPR5a   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_T5b=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T5b->Label (         '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5b->Label (         '-text'   => "MPR5b ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'#
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5b->Scale(  '-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$threshold_MPR5b,  
               '-command'      => \&compute_threshold_MPR5b   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_T5c=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_T5c->Label (         '-text'   => 'T',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5c->Label (         '-text'   => "MPR5c ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_T5c->Scale(  '-orient'   => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,           
               '-variable'     => \$threshold_MPR5c,  
               '-command'      => \&compute_threshold_MPR5c   
               )->pack('-side' => 'top',
                       '-fill' => 'x',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f5=$f1->Label     ('-text'   => 'Other Parameters',
                       '-height' => 2
               )->pack('-side'   => 'top',
                       '-fill'   => 'both',
                       '-anchor' => 'n',
                       '-pady'   => '5');

   $f_Wr=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_Wr->Label (          '-text'   => 'W',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wr->Label (          '-text'   => 'r          ',
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_Wr->Scale('-orient'      => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,  
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,  
               '-width'        => 5,             
               '-variable'     => \$weight_MPR1_rithm_register,  
               '-command'      => \&compute_weight_MPR1_rithm_register
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                       '-pady' => '0');

         &GetPowerd;
         &GetNoteMatrix;
         &GetM2N;
         $Metrical_level=&Metrical($Group_layer);
         &XMLOut_Metrical($Metrical_level);
         &Print_Metrical($Metrical_level);

   MainLoop();

   sub compute_weight_MPR1 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR2 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR3 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR4 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR5a {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR5b {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR5c {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR5d {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR5e {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR10 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_threshold_MPR1 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_threshold_MPR4 {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_threshold_MPR5a {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_threshold_MPR5b {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_threshold_MPR5c {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }

   sub compute_weight_MPR1_rithm_register {
      ($Metrical_level)=&Metrical($Group_layer);
      &XMLOut_Metrical($Metrical_level);
      &Print_Metrical($Metrical_level);
   }


#Metrical structure#############################################################
   sub Metrical{
      my $i=0;
      my $j=0;
      my $k=0;
      my $M_Level=0;
      my $T_MPR4;
      my $T_MPR5a;
      my $T_MPR5b;
      my $T_MPR5c;
      my $Next_notenum;
      my $Count;
      my $Sl_Count;
      my $sum_velo;
      my $sum_valu;
      my $sum_vol;
      my $sum_slur;
      my $M_velo;
      my $M_valu;
      my $M_vol;
      my $M_slur;
      my @D_all;
      my $ContinueMPR5a;
      my $ContinueMPR5d;
      my $ContinueMPR5e;
      my $Oldi;
      my $G_start;
      my $G_end;
      my $dotCount=0;
      my $G_Count=0;
      my $max;
      my $max_P;
      my $lastTie_start;
      my $lastSlur_start;

      foreach(@$NoteArray){
         $M=$_->{Note_off};
      }
      $M=$M*$Powerd; 
      for ($i=0;$i<=$M;$i++){
         $MetArray->[$i][1]{dot}=1;
      }

      $Level[1]=1/$Powerd;

      $lastTie_start='';
      foreach(@$NoteArray){
         if ($_->{rest} ne 1){
            $MetArray->[$_->{Note_on}*$Powerd][1]{duration}=($_->{Note_off}-$_->{Note_on})*$Powerd;
            $MetArray->[$_->{Note_on}*$Powerd][1]{duration2}=($_->{Note_off}-$_->{Note_on})*$Powerd;
            $MetArray->[$_->{Note_on}*$Powerd][1]{Note_num}=$_->{Note_num};
            $MetArray->[$_->{Note_on}*$Powerd][1]{dynamics}=$_->{Dynamics};
            $MetArray->[$_->{Note_on}*$Powerd][1]{slur}=0;
            $MetArray->[$_->{Note_on}*$Powerd][1]{note}=1;

            if ($_->{Tie} eq 'start'){
               $lastTie_start=$_->{Note_on}*$Powerd;
            }
            if ($_->{Tie} eq 'stop'){
               $MetArray->[$lastTie_start][1]{tie}=$_->{Note_off}*$Powerd-$lastTie_start;
               $lastTie_start='';
            }
            if ($_->{Slur} eq 'start'){
               $lastSlur_start=$_->{Note_on}*$Powerd;
            }
            if ($_->{Slur} eq 'stop'){
               $MetArray->[$lastSlur_start][1]{slur}=$_->{Note_off}*$Powerd-$lastSlur_start;
               $lastSlur_start='';
            }
         }
      }

      &MetricalParallelism($M);

      for ($i=0;$i<=$Group_layer;$i++){
         for ($j=0;$j<=$Group_Count[$i];$j++){
            $G_Count++;
         }
      }
      while(1){
         $M_Level++;
         #initalize
         for ($i=0;$i<=$M;$i++){
            $MetArray->[$i][$M_Level+1]{duration}='';
            $MetArray->[$i][$M_Level+1]{duration2}='';
            $MetArray->[$i][$M_Level+1]{Note_num}='';
            $MetArray->[$i][$M_Level+1]{dynamics}='';
            $MetArray->[$i][$M_Level+1]{Tie}='';
            $MetArray->[$i][$M_Level]{Old_duration}='';
            $MetArray->[$i][$M_Level]{Next_duration}='';
            $MetArray->[$i][$M_Level]{Old_duration2}='';
            $MetArray->[$i][$M_Level]{Next_duration2}='';
            $MetArray->[$i][$M_Level]{Next_notenum}='';
            $MetArray->[$i][$M_Level+1]{MPR1}='';
            $MetArray->[$i][$M_Level+1]{MPR1_note}='';
            $MetArray->[$i][$M_Level]{MPR3}='';
            $MetArray->[$i][$M_Level]{MPR4}='';
            $MetArray->[$i][$M_Level]{MPR5a}='';
            $MetArray->[$i][$M_Level]{MPR5b}='';
            $MetArray->[$i][$M_Level]{MPR5c}='';
            $MetArray->[$i][$M_Level]{MPR5d}='';
            $MetArray->[$i][$M_Level]{MPR5e}='';
            $MetArray->[$i][$M_Level+1]{dot}='';
            $MetArray->[$i][$M_Level+1]{note}='';
            $MetArray->[$i][$M_Level]{Bi}='';
            $MetArray->[$i][$M_Level]{lowlevel}='';
            $MetArray->[$i][$M_Level+1]{slur}='';

            $MetArray->[$i][$M_Level+1]{MPR3}='';
            $MetArray->[$i][$M_Level+1]{MPR4}='';
            $MetArray->[$i][$M_Level+1]{MPR5a}='';
            $MetArray->[$i][$M_Level+1]{MPR5b}='';
            $MetArray->[$i][$M_Level+1]{MPR5c}='';
            $MetArray->[$i][$M_Level+1]{MPR5d}='';
            $MetArray->[$i][$M_Level+1]{MPR5e}='';
            $MetArray->[$i][$M_Level+1]{Bi}='';
            $MetArray->[$i][$M_Level+1]{lowlevel}='';
         }

         for ($i=0;$i<5;$i++){
            $D_all[$i]=0;
         }

         $sum_velo=0;
         $sum_valu=0;
         $sum_vol=0;
         $sum_slur=0;   
         $Count=0;
         $Sl_Count=0;
         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level]{dot}==1 && $MetArray->[$i][1]{note}==1){
               $sum_velo=$sum_velo+$MetArray->[$i][$M_Level]{dynamics};
               $sum_valu=$sum_valu+$MetArray->[$i][$M_Level]{duration};
               $sum_vol= $sum_vol+ $MetArray->[$i][$M_Level]{duration2};
               $sum_slur=$sum_slur+$MetArray->[$i][$M_Level]{Tie}+$MetArray->[$i][$M_Level]{slur};
               $Count++;
               if ($MetArray->[$i][$M_Level]{Tie}>0 || $MetArray->[$i][$M_Level]{slur}>0){
                  $Sl_Count++;
               }
            }
         }
         $M_velo=$sum_velo/($Count);
         $M_valu=$sum_valu/($Count);
         $M_vol= $sum_vol /($Count);
         if ($Sl_Count>0){
            $M_slur=$sum_slur/($Sl_Count);
         }
         $Next_notenum='';
         for ($i=$M-1;$i>=0;$i--){
            $MetArray->[$i][$M_Level]{Next_notenum}=$Next_notenum;
            $Next_notenum=$MetArray->[$i][$M_Level]{Note_num};
         }

         $T_MPR4= 2*$M_velo*$threshold_MPR4;
         $T_MPR5a=2*$M_valu*$threshold_MPR5a;
         $T_MPR5b=2*$M_vol *$threshold_MPR5b;
         $T_MPR5c=2*$M_slur*$threshold_MPR5c;

         $ContinueMPR5e='';

         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level]{dot}==1 && $MetArray->[$i][1]{note}==1){
               if ($MetArray->[$i][$M_Level]{duration}>0){
                  $MetArray->[$i][$M_Level]{MPR3}=1;
               }
               if ($MetArray->[$i][$M_Level]{dynamics}>$T_MPR4){
                  $MetArray->[$i][$M_Level]{MPR4}=1;
               }
               if ($MetArray->[$i][$M_Level]{duration}>$T_MPR5a){
                  $MetArray->[$i][$M_Level]{MPR5a}=1;
               }
               if ($MetArray->[$i][$M_Level]{duration2}>$T_MPR5b){
                  $MetArray->[$i][$M_Level]{MPR5b}=1;
               }
               if ($MetArray->[$i][$M_Level]{slur}>$T_MPR5c ||
                   $MetArray->[$i][$M_Level]{tie} >$T_MPR5c){
                  $MetArray->[$i][$M_Level]{MPR5c}=1;  
               }
               if ($MetArray->[$i][$M_Level]{Next_notenum}==$MetArray->[$i][$M_Level]{Note_num} 
                 && $ContinueMPR5e eq ''){                  
                  $MetArray->[$i][$M_Level]{MPR5e}=1;
                  $ContinueMPR5e=1;
               }
               else{
                  $ContinueMPR5e='';
               }
            }      
         }

         $ContinueMPR5a='';
         $ContinueMPR5d='';
         $Oldi='';
         for ($i=$M-1;$i>=0;$i--){
            if ($MetArray->[$i][$M_Level]{dot}==1){
               if ($MetArray->[$i][1]{note}==1 && $MetArray->[$i][$M_Level]{MPR5a}==1){            
                  if ($ContinueMPR5a==1){
                     if($ContinueMPR5d eq ''){
                        $MetArray->[$i][$M_Level]{MPR5d}=1;
                        $Oldi=$i;
                     }
                     else{
                        $MetArray->[$Oldi][$M_Level]{MPR5d}='';
                        $MetArray->[$i][$M_Level]{MPR5d}=1;
                        $Oldi=$i;
                     }
                     $ContinueMPR5d=1;
                  }
                  else{
                     $ContinueMPR5d='';
                     $Oldi='';
                  }
                  $ContinueMPR5a=1;
               }
               else{
                  $ContinueMPR5a='';
                  $ContinueMPR5d='';
                  $Oldi='';
               }
            }
         }

         #MPR2
         for ($i=0;$i<=$Group_layer;$i++){
            for ($j=0;$j<=$Group_Count[$i];$j++){
               $G_start=$NoteArray->[$Group_Start[$i]->[$j]]{Note_on}*$Powerd; 
               $G_end=$NoteArray->[$Group_End[$i]->[$j]]{Note_off}*$Powerd;
               $dotCount=0;

               for ($k=$G_start;$k<$G_end;$k++){
                  if ($MetArray->[$k][$M_Level]{dotCount}>0){
                     $dotCount++;
                  }
               }
               if ($dotCount>1){
                  for ($k=$G_start;$k<$G_end;$k++){
                     if ($MetArray->[$k][$M_Level]{dotCount}>0){
                        if ($MetArray->[$k][$M_Level]{MPR2}==0){
                           $MetArray->[$k][$M_Level]{MPR2}=($G_end-$k)/($G_end-$G_start);
                        }
                     }
                  }
               }
            }
         }


         for ($i=0;$i<=$M;$i++){
            $MetArray->[$i][$M_Level]{Bi}
                  =$MetArray->[$i][$M_Level]{MPR2}*$weight_MPR2
                  +$MetArray->[$i][$M_Level]{MPR3}*$weight_MPR3
                  +$MetArray->[$i][$M_Level]{MPR4}*$weight_MPR4
                  +$MetArray->[$i][$M_Level]{MPR5a}*$weight_MPR5a
                  +$MetArray->[$i][$M_Level]{MPR5b}*$weight_MPR5b
                  +$MetArray->[$i][$M_Level]{MPR5c}*$weight_MPR5c
                  +$MetArray->[$i][$M_Level]{MPR5d}*$weight_MPR5d
                  +$MetArray->[$i][$M_Level]{MPR5e}*$weight_MPR5e;
         }

         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level]{MPR1}==1){
               $MetArray->[$i][$M_Level]{lowlevel}=$MetArray->[$i][$M_Level]{Bi}
                  +$MetArray->[$MetArray->[$i][$M_Level]{MPR_note}][$M_Level]{Bi}*$weight_MPR1;
            }
            else{
               $MetArray->[$i][$M_Level]{lowlevel}=$MetArray->[$i][$M_Level]{Bi};
            }
         }         

         #5Possibilities

         $dotCount=0;
         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level]{dot}==1){
               $dotCount++;
               if ($dotCount%2==1){
                  $D_all[0]=$D_all[0]+$MetArray->[$i][$M_Level]{lowlevel};
               }
               if ($dotCount%2==0){
                  $D_all[1]=$D_all[1]+$MetArray->[$i][$M_Level]{lowlevel};
               }
               if ($dotCount%3==1){
                  $D_all[2]=$D_all[2]+$MetArray->[$i][$M_Level]{lowlevel}*$weight_MPR10;
               }
               if ($dotCount%3==2){
                  $D_all[3]=$D_all[3]+$MetArray->[$i][$M_Level]{lowlevel}*$weight_MPR10;
               }
               if ($dotCount%3==0){
                  $D_all[4]=$D_all[4]+$MetArray->[$i][$M_Level]{lowlevel}*$weight_MPR10;
               }
            }
         }

         $max=0;
         $max_P=0;
         for ($i=0;$i<5;$i++){
             if ($D_all[$i]>$max){
                $max=$D_all[$i];
                $max_P=$i;
             }
         }

         $dotCount=0;
         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level]{dot}==1){
               $dotCount++;
               if ($dotCount%2==1 && $max_P==0){
                  $MetArray->[$i][$M_Level+1]{dot}=1;
               }
               if ($dotCount%2==0 && $max_P==1){
                  $MetArray->[$i][$M_Level+1]{dot}=1;
               }
               if ($dotCount%3==1 && $max_P==2){
                  $MetArray->[$i][$M_Level+1]{dot}=1;
               }
               if ($dotCount%3==2 && $max_P==3){
                  $MetArray->[$i][$M_Level+1]{dot}=1;
               }
               if ($dotCount%3==0 && $max_P==4){
                  $MetArray->[$i][$M_Level+1]{dot}=1;
               }
            }
         }
         
         if ($max_P<2){
            $Level[$M_Level+1]=$Level[$M_Level]*2;
         }
         else{
            $Level[$M_Level+1]=$Level[$M_Level]*3;
         }



         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level+1]{dot}==1 && $MetArray->[$i][1]{note}==1){
               $MetArray->[$i][$M_Level+1]{duration}=$MetArray->[$i][$M_Level]{duration};
               $MetArray->[$i][$M_Level+1]{Note_num}=$MetArray->[$i][$M_Level]{Note_num};
               $MetArray->[$i][$M_Level+1]{dynamics}=$MetArray->[$i][$M_Level]{dynamics}; 
               $MetArray->[$i][$M_Level+1]{duration2}=$MetArray->[$i][$M_Level]{duration2};
               if ($MetArray->[$i][$M_Level]{Tie}>0 
                && $MetArray->[$i][$M_Level]{Tie}>=$MetArray->[$i][$M_Level+1]{duration2}){
                  $MetArray->[$i][$M_Level+1]{Tie}=$MetArray->[$i][$M_Level]{Tie};
               }
               if ($MetArray->[$i][$M_Level]{slur}>0 
                && $MetArray->[$i][$M_Level]{slur}>=$MetArray->[$i][$M_Level+1]{duration2}){
                  $MetArray->[$i][$M_Level+1]{slur}=$MetArray->[$i][$M_Level]{slur};
               }

            }
            if ($MetArray->[$i][$M_Level]{MPR1}==1){
               if ($MetArray->[$i][$M_Level+1]{dot}==$MetArray->[$MetArray->[$i][$M_Level]{MPR1_note}][$M_Level+1]{dot}){
                  $MetArray->[$i][$M_Level+1]{MPR1}==1;
                  $MetArray->[$i][$M_Level+1]{MPR1_note}==$MetArray->[$i][$M_Level]{MPR1_note};
               }   
            }
         }

         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level+1]{dot}==1 && $MetArray->[$i][1]{note}==1){
               while(1){
                  if ($i+$MetArray->[$i][$M_Level+1]{duration2}<$M){
                     if ($MetArray->[$i+$MetArray->[$i][$M_Level+1]{duration2}][$M_Level+1]{dot}=='' &&
                         $MetArray->[$i+$MetArray->[$i][$M_Level+1]{duration2}][$M_Level]{dot}==1 &&
                         $MetArray->[$i+$MetArray->[$i][$M_Level+1]{duration2}][1]{note}==1){                
                        $MetArray->[$i][$M_Level+1]{duration2}=$MetArray->[$i][$M_Level+1]{duration2}
                       +$MetArray->[$i+$MetArray->[$i][$M_Level+1]{duration2}][$M_Level]{duration2};
                     }
                     else{
                        last;
                     }
                  }
                  else{
                     last;
                  }
               } 
            }
         }
         $dotCount=0;
         for ($i=0;$i<=$M;$i++){
            if ($MetArray->[$i][$M_Level+1]{dot}==1){
               $dotCount++;
            }
         }
         if ($dotCount<2){
            last;
         }
      }
      return $M_Level+1;
   }

   sub MetricalParallelism{
      my $beatCount;
      my $beatCount1;
      my $beatCount2;
      my $NCount;
      my $NCount_2;
      my $NCount_3;
      my $register; 
      my $register_2;
      my $M=$_[0];

      for (my $i=0;$i<=$M;$i++){
         $MetArray->[$i][1]{MPR1}='';
      }
      for(my $i=0;$i<=$Group_Count[0];$i++){
         for (my $j=$i+1;$j<=$Group_Count[0];$j++){
            if ($i<$j){
               $beatCount=int($NoteArray->[$Group_Start[0]->[$j]]{Note_on})
                          -int($NoteArray->[$Group_Start[0]->[$i]]{Note_on});
               $beatCount1=int($NoteArray->[$Group_End[0]->[$i]]{Note_on})
                          -int($NoteArray->[$Group_Start[0]->[$i]]{Note_on});
               $beatCount2=int($NoteArray->[$Group_End[0]->[$j]]{Note_on})
                          -int($NoteArray->[$Group_Start[0]->[$j]]{Note_on});
               $NCount=0;
               if ($beatCount1==$beatCount2){
                  $NCount=$Group_End[0]->[$i]-$Group_Start[0]->[$i]+$Group_End[0]->[$j]-$Group_Start[0]->[$j]+2;
               }
               if ($NCount>4){
                  $NCount_2=0;
                  $NCount_3=0;
                  $register='';
                  for (my $k=$Group_Start[0]->[$i];$k<=$Group_End[0]->[$i];$k++){
                     if ($NoteMatrix[($NoteArray->[$k]{Note_on}+$beatCount)*$Powerd]>0){
                        $NCount_2++;
                        $register_2=$NoteMatrix[$NoteArray->[$k]{Note_on}*$Powerd]
                                   -$NoteMatrix[($NoteArray->[$k]{Note_on}
                                   +int($NoteArray->[$Group_Start[0]->[$j]]{Note_on})
                                   -int($NoteArray->[$Group_Start[0]->[$i]]{Note_on}))*$Powerd];
                        if ($register==$register_2){
                           $NCount_3++;
                        }
                        $register=$register_2;
                     }
                  }
                  if ($NCount_2>3){
                     if (($NCount_2/$NCount*(1-$weight_MPR1_rithm_register)*$beatCount1**(1+$weight_MPR1_length)
                         +$NCount_3/$NCount_2*$weight_MPR1_rithm_register)*$beatCount1**(1+$weight_MPR1_length)>$threshold_MPR1){
                        for (my $k=$Group_Start[0]->[$i];$k<=$Group_End[0]->[$i];$k++){
                           if ($MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1}==''){
                              $MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1}=1;
                              $MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1_note}=($NoteArray->[$k]{Note_on}+$beatCount)*$Powerd;
                           } 
                        }   
                        for (my $k=$Group_Start[0]->[$j];$k<=$Group_End[0]->[$j];$k++){
                           if ($MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1}==''){
                              $MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1}=1;
                              $MetArray->[$NoteArray->[$k]{Note_on}*$Powerd][1]{MPR1_note}=($NoteArray->[$k]{Note_on}-$beatCount)*$Powerd;
                           } 
                        }
                     }   
                  }
               }
            }
         }
      }
   }

   sub GetPowerd{
      my $i=0;
      my $Non;
      my $Noff;
      $Powerd=1;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            $Powerd=$Powerd*210;
            $i=0;
         }
         else{
            last;
         }
      }
      $i=0;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/2;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*2;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/3;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*3;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/5;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*5;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/7;
            $i=0;
         }
      }
      $Powerd=$Powerd*7;
   }

   sub GetNoteMatrix{
      my $i=0;
      foreach(@$NoteArray){
         if ($_->{Note_num}>0){
            $NoteMatrix[$_->{Note_on}*$Powerd]=$_->{Note_num};

         }
         $i++;
      }
   }

   sub GetM2N{
      my $Count=0;
      foreach(@$NoteArray){
         $Count++;
         $M2N[$_->{Note_on}*$Powerd]=$Count;
      }
    }

#XMLOut Metrical#############################################################

   sub XMLOut_Metrical{
      my $M_Level=$_[0];
      my $i;
      my $j;
      my $measure=0;
      my $noteCount=0;
      my $prior_Noteoff=0;
      my $output=new IO::File(">$MPRfilename");
      my $writer = new XML::Writer(OUTPUT => $output,DATA_MODE => 'true',DATA_INDENT=>2);
      my $Dot;
      my $at2;
      my $Count;
      my $level;
      my $link1=qq{xmlns:GTTM};
      my $link2=qq{xmlns:mr};
      my $link3=qq{xmlns:xlink};
      my $link4=qq{xmlns:xsi};
      my $link5=qq{xsi:SchemaLocation};
      my $link6=qq{xml:base};
      $writer->xmlDecl( 'UTF-8' );
      $writer->startTag( 'MPR',$link1=> "http://www.dacreation.com/ns/GTTM",
                               $link2=> "http://www.dacreation.com/ns/MusicResonator",
                               $link3=> "http://www.w3.org/1999/xlink",
                               $link4=> "http://www.w3.org/2001/XMLSchema-instance",
                               $link5=> 
      "http://www.dacreation.com/ns/GTTM http://www.dacreation.com/ns/GTTM/ts.xsd",
                               $link6=> $BaseURL,);

       for ($i=0;$i<=$M;$i++){
          $Dot=0;
          for ($j=1;$j<=$M_Level;$j++){         
             if ($MetArray->[$i][$j]{dot} eq '1'){
                $Dot++;
             }
          }
          $at2=$i/$Powerd;
          if (!($at2 =~/\./)){$at2="$at2.0";}
          if ($MetArray->[$i][1]{duration}>0){
             $writer->startTag( 'metric','dot'=>$Dot,'at'=>$at2);
             for ($j=1;$j<=$M_Level;$j++){                
                if ($MetArray->[$i][$j]{MPR1}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'1');
                }
                if ($MetArray->[$i][$j]{MPR3}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'3');
                }
                if ($MetArray->[$i][$j]{MPR4}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'4');
                }
                if ($MetArray->[$i][$j]{MPR5a}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'5a');
                }
                if ($MetArray->[$i][$j]{MPR5b}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'5b');
                }
                if ($MetArray->[$i][$j]{MPR5c}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'5c');
                }
                if ($MetArray->[$i][$j]{MPR5d}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'5d');
                }
                if ($MetArray->[$i][$j]{MPR5e}==1){
                   $writer->emptyTag('applied','level'=>$Level[$j],'rule'=>'5e');
                }
             }

             foreach(@$NoteArray){
                if ($_->{Note_on}*$Powerd==$i){
#                   if ($measure < $_->{Measure}){
#                      $measure=$_->{Measure};
#                      $noteCount=0;
#                   }
#                   $noteCount++;
#                   if ($prior_Noteoff < $_->{Note_on}){
#                      $noteCount++;
#                   }
#                   $_->{NoteCount}=$noteCount;
#                   $prior_Noteoff=$_->{Note_off};
#                   $noteCount=$_->{NoteCount};
##                   $writer->emptyTag( 'mr:note',id=>"$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}" );
                   
                    my $link7=qq{xlink:herf};
                    my $link8=qq{#xpointer(id('};
                    my $link9=qq{'))};
                    $link8=$link8."$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}".$link9;
#                   $writer->emptyTag(qq{mr:fragment}, $link7=>$link8);
                      $writer->emptyTag(qq{note},id=>qq{$_->{Part_id}\-$_->{Measure}\-$_->{Note_Count}}, $link7=>$link8);

#                   $writer->startTag( 'note',id=>"$_->{Part_id}\-$measure\-$noteCount" );
#                   $writer->emptyTag( 'supplementaryLink',$Xlink_type=>'simple',$Xlink_href=>
#                   "file:/#xpointer(//part[\@id=\'$_->{Part_id}\']/measure[\@number=\'$measure\']/note[$noteCount])" );
#                   my $at=$_->{Note_on};
#                   if ($at eq ''){$at='0.0';}
#                   if (!($at =~/\./)){$at="$at.0";}
#                   my $Dur=$_->{Note_off}-$_->{Note_on};
#                   $writer->emptyTag( 'supplementaryInformation','at'=>$at,'duration'=> $Dur,'notenumber'=>$_->{Note_num},
#                   'velocity'=>'90','step'=>$_->{Step},'octave_base'=>$_->{Octave},'octave_width'=>'0','alter'=>$_->{Alter});
#                   $writer->endTag('note');
                }
             }
             $writer->endTag('metric');
          }
          else{
             $writer->emptyTag('metric','dot'=>$Dot,'at'=>$at2);
          }
       }
       $writer->endTag('MPR');
       $writer->end();
   }



#Print Metrical#############################################################

   sub Print_Metrical{
      my $M_Level=$_[0];
      my $M;
      my $i;
      my $j;

      open (OUT,">TempM");
      for ($M=0;$M<@$MetArray-1;$M++){  
         $j=$M+1;   
         print OUT "$j  ";    
         if ($M2N[$M] eq ''){
            print OUT "            \t";
         }
         else{
            print OUT "Note$M2N[$M]\:  \t";
         }
         for ($i=1;$i<=$M_Level;$i++){
            if ($MetArray->[$M][$i]{dot}==1){
               print OUT "\*  ";
            }
            else{
               print OUT "   ";
            }
            if ($MetArray->[$M][1]{MPR1}>0 && $MetArray->[$M][$i]{dot}==1){
               print OUT " 1 ";
            }
            else{
               print OUT "    ";
            }
            if ($MetArray->[$M][$i]{MPR3}==1){
               print OUT " 3 ";
            }
            else{
               print OUT "   ";
            }
            if ($MetArray->[$M][$i]{MPR4}==1){
               print OUT " 4 ";
            }
            else{
               print OUT "    ";
            }
            if ($MetArray->[$M][$i]{MPR5a}==1){
               print OUT " 5a ";
            }
            else{
               print OUT "      ";
            }
            if ($MetArray->[$M][$i]{MPR5b}==1){
               print OUT " 5b ";
            }
            else{
               print OUT "      ";
            }
            if ($MetArray->[$M][$i]{MPR5c}==1){
               print OUT " 5c ";
            }
            else{
               print OUT "      ";
            }

            if ($MetArray->[$M][$i]{MPR5d}==1){
               print OUT " 5d ";
            }
            else{
               print OUT "     ";
            }
            if ($MetArray->[$M][$i]{MPR5e}==1){
               print OUT " 5e ";
            }
            else{
               print OUT "      ";
            }
            print OUT "\t";
         }
         print OUT "\n";
      }
      close(OUT);
      (my $top,my $bottom)=$f2->yview();
      $f2->delete("1.0",'end');
      open (IN,"TempM");
      while (<IN>){
         $f2->insert("end",$_);
      }
      close(IN);
      $f2->yviewMoveto($top);
   }




#Get Grouping Data##########################################################

   sub group{
      my ($tree,$elem)=@_;
      $Now_layer=$elem->att('level');
      if ($Group_layer<$Now_layer){
         $Group_layer=$Now_layer;
      }
      if ($Group_Count[$Now_layer] eq ''){
         $Group_Count[$Now_layer]=0;
      }
      else{
         $Group_Count[$Now_layer]++;
      }
      if ($Group_Start[$Now_layer]->[$Group_Count[$Now_layer]] eq ''){
         $Group_Start[$Now_layer]->[$Group_Count[$Now_layer]]=0;
      }
      $Group_End[$Now_layer]->[$Group_Count[$Now_layer]]=$NoteCount; 
      $Group_Start[$Now_layer]->[$Group_Count[$Now_layer]+1]=$NoteCount+1; 
      if ($g_flg==0){
         for (my $i=0;$i<$Now_layer;$i++){
            if ($Group_Count[$i] eq ''){
               $Group_Count[$i]=0;
            }
            else{
               $Group_Count[$i]++;
            }
            if ($Group_Start[$i]->[$Group_Count[$i]] eq ''){
               $Group_Start[$i]->[$Group_Count[$i]]=0;
            }
            $Group_End[$i]->[$Group_Count[$i]]=$NoteCount; 
            $Group_Start[$i]->[$Group_Count[$i]+1]=$NoteCount+1; 
         }
      $g_flg=1;
      }
   }

   sub note_2{
      $g_flg=0;
   }

   sub SInfo{
      my ($tree,$elem)=@_;
      my $at=$elem->att('at');
      for(my $i=0; $i<@$NoteArray;$i++){
         if ($at==$NoteArray->[$i]{Note_on}){
            $NoteCount=$i;
         }
      }
      if ($NoteArray->[$NoteCount]{Tie} eq 'start'){$NoteCount++;}
   }

   sub applied{
      my ($tree,$elem)=@_;
      my $rule=$elem->att('rule');
      if ($rule==''){ $rule=$elem->text;}
      if    ($rule eq '2a' || $rule eq 'GPR2a'){
         $NoteArray->[$NoteCount+1]{GPR2a}=1;
      }
      elsif ($rule eq '2b' || $rule eq 'GPR2b'){
         $NoteArray->[$NoteCount+1]{GPR2b}=1;
      }
      elsif ($rule eq '3a' || $rule eq 'GPR3a'){
         $NoteArray->[$NoteCount+1]{GPR3a}=1;
      }
      elsif ($rule eq '3b' || $rule eq 'GPR3b'){
         $NoteArray->[$NoteCount+1]{GPR3b}=1;
      }
      elsif ($rule eq '3c' || $rule eq 'GPR3c'){
         $NoteArray->[$NoteCount+1]{GPR3c}=1;
      }
      elsif ($rule eq '3d' || $rule eq 'GPR3d'){
         $NoteArray->[$NoteCount+1]{GPR3d}=1;
      }
      elsif ($rule eq '4' || $rule eq 'GPR4'){
         $NoteArray->[$NoteCount+1]{GPR4}=1;
      }
      elsif ($rule eq '5' || $rule eq 'GPR5'){
         $NoteArray->[$NoteCount+1]{GPR5}=1;
      }
      elsif ($rule eq '6' || $rule eq 'GPR6'){
         $NoteArray->[$NoteCount+1]{GPR6}=1;
      }
   }

   sub note_1{
       $main::NC++;
       my ($tree,$elem)=@_;
       if($main::tie ne 'stop'){
          if($main::rest ne '1'){
             my $note={
                 "Divisons" => $main::divisions,
                 "Fifths"   => $main::fifths,
                 "Beats"    => $main::beats,
                 "Beattype" => $main::beattype,
                 "Step"     => $main::step,
                 "Alter"    => $main::alter,
                 "Octave"   => $main::octave,
                 "Rest"     => $main::rest,
                 "Duration" => $main::duration,
                 "Voice"    => $main::voice,
                 "Type"     => $main::type,
                 "Stem"     => $main::stem,
                 "Tie"      => $main::tie,
                 "Chordes"  => $main::chordes,
                 "Note_on"  => $main::Time/$main::divisions,
                 "Note_off" => ($main::Time+$main::duration)/$main::divisions,
                 "Note_num" => 12*$main::octave+$main::alter+&ValStep($main::step),
                 "Note_Count"   => $main::NC,
                   };
             push (@$NoteArray, $note);
         }
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
      }
      else{
         $NoteArray->[@$NoteArray-1]{Note_off}=($main::Time+$main::duration)/$main::divisions;
         $NoteArray->[@$NoteArray-1]{Duration}=$NoteArray->[@$NoteArray-1]{Duration}+$main::duration;
         $NoteArray->[@$NoteArray-1]{Type}="$NoteArray->[@$NoteArray-1]{Type}$main::type";
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
         $main::tie='';
      }
   }

   sub measure{
         my ($tree,$elem)=@_;
         my $measure=$elem->att('number');
         foreach (@$NoteArray){
            if ($_->{Measure} eq ''){$_->{Measure}=$measure;}
         }
      $main::NC=0;
   }

   sub part{
      my ($tree,$elem)=@_;
      my $id=$elem->att('id');
      foreach (@$NoteArray){
         if ($_->{Part_id} eq ''){$_->{Part_id}=$id;}
      }
      $main::divisions='';
      $main::fifths='';
      $main::beats='';
      $main::beattype='';
      $main::Time=0;
   }

   sub divisions{
      my($tree,$elem)=@_;
      $main::divisions=$elem->text;
   }

   sub fifths{
      my($tree,$elem)=@_;
      $main::fifths=$elem->text;
   }

   sub beats{
      my($tree,$elem)=@_;
      $main::beats=$elem->text;
   }

   sub beattype{
      my($tree,$elem)=@_;
      $main::beattype=$elem->text;
   }

   sub step{
      my($tree,$elem)=@_;
      $main::step=$elem->text;
   }

   sub alter{
      my($tree,$elem)=@_;
      $main::alter=$elem->text;
   }

   sub octave{
      my($tree,$elem)=@_;
      $main::octave=$elem->text;
   }

   sub rest{
      my($tree,$elem)=@_;
      $main::rest=1;
   }

   sub duration{
      my($tree,$elem)=@_;
      $main::duration=$elem->text;
   }

   sub voice{
      my($tree,$elem)=@_;
      $main::voice=$elem->text;
   }

   sub type{
      my($tree,$elem)=@_; 
      $main::type=$elem->text;
   }

   sub stem{
      my($tree,$elem)=@_;
      $main::stem=$elem->text;
   }

   sub tie{
      my($tree,$elem)=@_;
      if ($main::tie ne 'stop'){
         $main::tie=$elem->att('type');
      }
   }

   sub chords{
      my($tree,$elem)=@_;
      $main::chords=1;
   }

   sub slur{
      my($tree,$elem)=@_;
      $main::slur=$elem->att('type');
      if ($main::slur eq 'start'){
         $main::articulation=1;
      }
      else{
         $main::articulation=0.8;
      }
   }

   sub staccato{
      $main::staccato="staccato";
      $main::articulation=0.5;
   }

   sub accent{
      $main::dynamics=1;
   }

   sub ValStep{
      if ($_[0] eq 'A'){return 9;}
      if ($_[0] eq 'B'){return 11;}
      if ($_[0] eq 'C'){return 0;}
      if ($_[0] eq 'D'){return 2;}
      if ($_[0] eq 'E'){return 4;}
      if ($_[0] eq 'F'){return 5;}
      if ($_[0] eq 'G'){return 7;}
   }

#Copyright (c) 2003-2005 Masatoshi Hamanaka All rights reserved.