#!/usr/bin/perl
###########################################################################
#  Time-span  ver. 1.01                                                   #
#                                Masatoshi Hamanaka (10th/Mar./2005)      #
###########################################################################

   use strict;
   use Tk;
   use XML::Twig;
   use XML::Writer;
   use IO;
   my $divisions;
   my $fifths;
   my $beats;
   my $beattype;
   my $step;
   my $octave;
   my $duration;
   my $voice;
   my $type;
   my $stem;
   my $tie;
   my $chordes;
   my $NoteArray;
   my $TSArray;
   my $filename;
   my $GPRfilename;
   my $MPRfilename;
   my $TSfilename;
   my $BaseURL;
   my $NoteCount=0;
   my @Group_Start;
   my @Group_End;
   my @Group_Count;
   my $Group_layer;
   my $Now_layer;
   my $top;
   my $text;
   my $f0;
   my $f1;
   my $f2; 
   my $f3;  
   my $f_TSRPR1;
   my $f_TSRPR3a;
   my $f_TSRPR3b;
   my $f_TSRPR4;
   my $f_TSRPR8;
   my $f_TSRPR9;
   my $weight_TSRPR1=0.5;
   my $weight_TSRPR3a=0.5;
   my $weight_TSRPR3b=0.5;
   my $weight_TSRPR4=0.5;
   my $weight_TSRPR8=0.5;
   my $weight_TSRPR9=0.5;
   my $g_level;
   my $Max_level;
   my $g_flg=0;
   my $g_start='<group>';
   my $g_end='</group>';
   my $NC=0;
   my $MetArray;
   my @M2N;
   my $Powerd;
   my $metrical=0;
   my $Maxdot=0;
   my $M_level=0;
   my $Old_level=0;
   my $Maxpitch=0;
   my $T_level=0;
   my @N2TS;

   die "No filename" unless @ARGV;
   $filename=$ARGV[0];    
   my $twig_1=new XML::Twig(TwigHandlers=>{
                   "part"                      => \&part,
                   "measure"                   => \&measure,
                   "note"                      => \&note_1,
                   "divisions"                 => \&divisions,
                   "fifths"                    => \&fifths,
                   "beats"                     => \&beats,
                   "beat-type"                 => \&beattype,
                   "step"                      => \&step,
                   "alter"                     => \&alter,
                   "octave"                    => \&octave,
                   "rest"                      => \&rest,
                   "duration"                  => \&duration,
                   "voice"                     => \&voice,
                   "type"                      => \&type,
                   "stem"                      => \&stem, 
                   "tie"                       => \&tie,
                   "chordes"                   => \&chordes
                                       });
   $twig_1->parsefile($filename);

   $NoteCount=-1;
   $Group_layer=-1;
   $Now_layer=-1;

   if ($ARGV[1] eq ''){
      $GPRfilename='GPR-'.$filename;
   }
   else{
      $GPRfilename=$ARGV[1];
   }

   open (OUT,">Temp_1");
   open (IN,$GPRfilename);
   while (my $in=<IN>){
      $in=~s/$g_start/$g_start \n/;
      unless ($in=~/supple/){      
         print OUT $in;
      }
   }
   close (IN);
   close (OUT);

   $g_level=-1;
   $Max_level=0;
   open (IN,"Temp_1");
   while(my $in=<IN>){
      if ($in=~/$g_start/){
         $g_level++;
         if ($g_level>$Max_level){
            $Max_level=$g_level;
         }
      }
      if ($in=~/$g_end/){
         $g_level--;
      }
   }
   close (IN);

   open (OUT,">Temp_2");
   open (IN,"Temp_1");
   while (my $in=<IN>){
      if ($in=~/$g_start/){
         $g_level++;
         my $level=$Max_level-$g_level;
         $in=q{<group level="}.$level.q{">}."\n";
      }
      if ($in=~/$g_end/){
         $g_level--;
      }      
      print OUT $in;
   }
   close (IN);
   close (OUT);

   my $twig_2=new XML::Twig(TwigHandlers=>{
                   "group"                    => \&group,
                   "note"                     => \&note_2,
                   "mr:note"                  => \&note_2,
                   "mr:fragment"              => \&note_2,
                   "applied"                  => \&applied_G,
                                       });
   $twig_2->parsefile('Temp_2');


   if ($ARGV[2] eq ''){
      $MPRfilename='MPR-'.$filename;
   }
   else{
      $MPRfilename=$ARGV[2];
   }
   &GetPowerd;
   &GetM2N;
   my $twig_3=new XML::Twig(TwigHandlers=>{
                   "metric"                   => \&metric,
                   "note"                     => \&note_3,
                   "applied"                  => \&applied_M,
                                      });
   $twig_3->parsefile($MPRfilename);

   if ($ARGV[3] eq ''){
      $TSfilename='TS-'.$filename;
   }
   else{
      $TSfilename=$ARGV[3];
   }

   if ($ARGV[4] eq ''){
      my $URL=$filename;

      $URL=~/([0-9]+)/;
      $URL=$1;
      $URL=~s/\.xml//;

      $BaseURL=qq{doc/FMPRX/}.$URL.qq{/FRAGMENTS-}.$URL.'xml';
   }
   else{
      $BaseURL=$ARGV[4];
   }

   my $leftend=0;
   my $rightend=$NoteArray->[@$NoteArray-1]{Note_off};
   TS_segmentation($leftend,$rightend,$Group_layer,-1);
   &Get_Child;
   &Get_T_level;
   &Get_N2TS;
   &Cal_Metdot;
   &Cal_Maxpitch;
   &Cal_TSRPR13;

   #MainWindow
   $top=MainWindow->new();
   $top->title("Time-span.pl 1.01    $filename");

   $f1=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f0=$top->Frame()->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f2=$f0->Scrolled("Text",'-width' => 100,
                            '-height'=> 90,
                            '-wrap'  =>'none',
                            '-font'  => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
                   )->pack('-side'   => 'left',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f3=$f1->Label (        '-text'   => 'The strength of each rule',
                           '-height' => 2
                   )->pack('-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both',
                           '-pady'   => '3');

   $f_TSRPR1=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR1->Label (      '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR1->Label (      '-text'   => "TSRPR1 ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR1->Scale('-orient'  => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR1,    
               '-command'      => \&compute_weight_TSRPR1
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_TSRPR3a=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR3a->Label (     '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR3a->Label (     '-text'   => "TSRPR3a",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR3a->Scale('-orient' => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR3a,    
               '-command'      => \&compute_weight_TSRPR3a
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_TSRPR3b=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR3b->Label (     '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR3b->Label (     '-text'   => "TSRPR3b",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR3b->Scale('-orient' => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR3b,    
               '-command'      => \&compute_weight_TSRPR3b
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_TSRPR4=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR4->Label (      '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR4->Label (      '-text'   => "TSRPR4 ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR4->Scale('-orient'  => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR4,    
               '-command'      => \&compute_weight_TSRPR4
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_TSRPR8=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR8->Label (      '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR8->Label (      '-text'   => "TSRPR8 ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR8->Scale('-orient'  => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR8,    
               '-command'      => \&compute_weight_TSRPR8
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');

   $f_TSRPR9=$f1->Frame()->pack(
                           '-side'   => 'top',
                           '-anchor' => 'n',
                           '-fill'   => 'both');

   $f_TSRPR9->Label (      '-text'   => 'S',
                           '-height' => 1,
                           '-font'   => 'lucidasans-italic-18'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR9->Label (      '-text'   => "TSRPR9 ",
                           '-height' => 1,
                           '-font'   => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1'
                   )->pack('-side'   => 'left',
                           '-anchor' => 'nw',
                           '-fill'   => 'both',
                           '-pady'   => '0');

   $f_TSRPR9->Scale('-orient'  => 'horizontal',
               '-from'         => 0, 
               '-to'           => 1.0,  
               '-resolution'   => 0.1,
               '-font'         => '-adobe-helvetica-medium-r-normal--10-100-75-75-p-56-iso8859-1',
               '-length'       => 300,   
               '-width'        => 5,              
               '-variable'     => \$weight_TSRPR9,    
               '-command'      => \&compute_weight_TSRPR9
               )->pack('-side' => 'top',
                       '-fill' => 'both',
                     '-anchor' => 'n',
                       '-pady' => '0');
   MainLoop();

   sub compute_weight_TSRPR1 {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }

   sub compute_weight_TSRPR3a {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }

   sub compute_weight_TSRPR3b {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }

   sub compute_weight_TSRPR4 {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }

   sub compute_weight_TSRPR8 {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }

   sub compute_weight_TSRPR9 {
       &Time_span;
       &XMLOut_TimeSpan;
       &Print_TimeSpan;
   }


#Time-span reduction########################################################

   sub Time_span{
      foreach(@$TSArray){
        $_->{head}='';
        $_->{primary}='';
        $_->{secondary}='';
        if ($_->{startnote} eq $_->{endnote}){
           $_->{head}=$_->{startnote};
        }
      }
      &MakeTree;
   }

   sub MakeTree{
      my $Count;
      while($Count<@$TSArray){
         for (my $i=0;$i<@$TSArray;$i++){
            if ($TSArray->[$i]{head} ne ''){
               for (my $j=0;$j<@$TSArray;$j++){
                  if ($TSArray->[$j]{head} ne ''){
                     if ($i!=$j){
                        if($TSArray->[$i]{parent} == $TSArray->[$j]{parent}){
                           if ($TSArray->[$TSArray->[$i]{parent}]{head} eq ''){
                              if ($i<$j){
                                 &Makehead($i,$j);
                              }
                              else{
                                 &Makehead($j,$i);
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
         $Count=0;
         foreach(@$TSArray){
            if ($_->{head} ne ''){$Count++;}
         }  
      }
   }

   sub Makehead{
      my $i=$_[0];
      my $j=$_[1];   
      my $Bi=&Cal_Bi($i);
      my $Bj=&Cal_Bi($j);
      my $Si=$Bi;
      my $Sj=$Bj;

      #TSRPR4     
      for (my $i2=0;$i2<@$TSArray;$i2++){
         if ($TSArray->[$i2]{head} ne ''){
            for (my $j2=0;$j2<@$TSArray;$j2++){
               if ($TSArray->[$j2]{head} ne ''){
                  if ($i2!=$j2){
                     if($TSArray->[$i2]{parent} == $TSArray->[$j2]{parent}){
                         if (($TSArray->[$i2]{rightend}-$TSArray->[$i2]{leftendend}
                            ==$TSArray->[$i]{rightend} -$TSArray->[$i]{leftendend})&&
                             ($TSArray->[$j2]{rightend}-$TSArray->[$j2]{leftendend}
                            ==$TSArray->[$j]{rightend} -$TSArray->[$j]{leftendend})){
                            $Si=$Si+$weight_TSRPR4*&Cal_Bi($i2);
                            $Sj=$Sj+$weight_TSRPR4*&Cal_Bi($j2);
                         }
                     }
                  }
               }
            }
         }
      }
      if ($Si>$Sj){
         $TSArray->[$TSArray->[$i]{parent}]{head}=$TSArray->[$i]{head};
         $TSArray->[$TSArray->[$i]{parent}]{primary}=$i;
         $TSArray->[$TSArray->[$i]{parent}]{secondary}=$j;
      }
      else{
         $TSArray->[$TSArray->[$j]{parent}]{head}=$TSArray->[$j]{head};
         $TSArray->[$TSArray->[$j]{parent}]{primary}=$j;
         $TSArray->[$TSArray->[$j]{parent}]{secondary}=$i;
      }
   }

   sub Cal_Bi{
      my $i=$_[0];
      #TSRPR1
      my $D1=$NoteArray->[$TSArray->[$i]{head}]{TSRPR1};

      #TSRPR3a
      my $D3a=$NoteArray->[$TSArray->[$i]{head}]{TSRPR3};

      #TSRPR3
      my $D3b=1-$NoteArray->[$TSArray->[$i]{head}]{TSRPR3};

      #TSRPR8
      my $D8=0; 
      for (my $L=$Group_layer;$L>=0;$L--){
         for (my $k=0;$k<=$Group_Count[$L];$k++){
            if ($D8==0){
               if ($NoteArray->[$Group_Start[$L]->[$k]]{Note_on}<=$TSArray->[$i]{leftend} 
                && $NoteArray->[$Group_End[$L]->[$k]]{Note_off}>$TSArray->[$i]{rightend}){
                  if ($NoteArray->[$Group_End[$L]->[$k]]{Note_off}
                     -$NoteArray->[$Group_Start[$L]->[$k]]{Note_on}>0){
                     $D8=($TSArray->[$i]{leftend}-$NoteArray->[$Group_Start[$L]->[$k]]{Note_on})/
                                                 ($NoteArray->[$Group_End[$L]->[$k]]{Note_off}
                                                 -$NoteArray->[$Group_Start[$L]->[$k]]{Note_on}); 
                  }
               }               
            }
         }
      }

      #TSRPR9
      my $D9=0;
      for (my $L=$Group_layer;$L>=0;$L--){
         for (my $k=0;$k<=$Group_Count[$L];$k++){
            if ($D9==0){
               if ($NoteArray->[$Group_End[$L]->[$k]]{Note_off}=>$TSArray->[$i]{rightend} 
                && $NoteArray->[$Group_Start[$L]->[$k]]{Note_on}<$TSArray->[$i]{leftend}){
                  if ($NoteArray->[$Group_End[$L]->[$k]]{Note_off}
                     -$NoteArray->[$Group_Start[$L]->[$k]]{Note_on}>0){
                     $D9=($NoteArray->[$Group_End[$L]->[$k]]{Note_off}-$TSArray->[$i]{leftend})/
                                                 ($NoteArray->[$Group_End[$L]->[$k]]{Note_off}
                                                 -$NoteArray->[$Group_Start[$L]->[$k]]{Note_on}); 
                  }
               }
            }
         }
      }
      return $weight_TSRPR1*$D1+$weight_TSRPR3a*$D3a+$weight_TSRPR3b*$D3b+$weight_TSRPR8*$D8+$weight_TSRPR9*$D9;
   }

   sub Cal_Metdot{
      foreach(@$NoteArray){
          $MetArray->[$_->{Note_on}*$Powerd][0]{dotcount}=0;
          for (my $i=0; $i<=$Maxdot;$i++){
             if ($MetArray->[$_->{Note_on}*$Powerd][$i]{dot}==1){
                $MetArray->[$_->{Note_on}*$Powerd][0]{dotcount}++;
             }
          }
      }
   }

   sub Cal_Maxpitch{
      foreach(@$NoteArray){
         if ($_->{Note_num}>$Maxpitch){
            $Maxpitch=$_->{Note_num};
         }
      }
   }

  sub Cal_TSRPR13{
      foreach(@$NoteArray){
         $_->{TSRPR1}=$MetArray->[$_->{Note_on}*$Powerd][0]{dotcount}/$Maxdot;
         $_->{TSRPR3}=$_->{Note_num}/$Maxpitch;
      }
  }

   sub TS_segmentation{
      my $leftend=$_[0];
      my $rightend=$_[1];
      my $Layer=$_[2];
      my $Parent=$_[3];
      my $Start_note=0;
      my $End_note=0;
      my $Mdot=0;
      my $Mdot_m=0;
      my $dot;
      my $null='';
      foreach(@$NoteArray){
         if ($_->{Note_on}<$leftend){$Start_note++;}
         if ($_->{Note_off}<$rightend){$End_note++;}
      }

      my $TS={
          "leftend"  => $leftend,
          "rightend" => $rightend,
          "startnote"=> $Start_note,
          "endnote"  => $End_note,
          "parent"   => $Parent,
          "child1"   => $null,
          "child2"   => $null,
            };

      push (@$TSArray, $TS);

      $Parent=@$TSArray-1;
      if ($End_note==$Start_note){return;}
    
      for (my $L=$Layer;$L>=0;$L--){
         for (my $j=0;$j<=$Group_Count[$L]-1;$j++){
            if ($Start_note<=$Group_End[$L]->[$j] && $Group_Start[$L]->[$j+1]<=$End_note){
               &TS_segmentation($NoteArray->[$Start_note]{Note_on},
                                $NoteArray->[$Group_End[$L]->[$j]]{Note_off},$Layer,$Parent);
               &TS_segmentation($NoteArray->[$Group_Start[$L]->[$j+1]]{Note_on},
                                $NoteArray->[$End_note]{Note_off},$Layer,$Parent);
               return;
            }
         }
      }
     
      for (my $j=$NoteArray->[$Start_note]{Note_off}*$Powerd;
              $j<=$NoteArray->[$End_note]{Note_on}*$Powerd;$j++){
         for (my $i=$Mdot;$i<=$Maxdot;$i++){
            if ($MetArray->[$j][$i]{dot}==1){
               $Mdot++;
               $Mdot_m=$j;
            }
         }           
      }

      if ($Mdot_m==0){$Mdot_m=($NoteArray->[$End_note]{Note_on}+$NoteArray->[$Start_note]{Note_off})*$Powerd/2;}

      for (my $i=$Start_note;$i<=$End_note;$i++){
         if ($Mdot_m<=$Powerd*$NoteArray->[$i]{Note_on}){
            &TS_segmentation($NoteArray->[$Start_note]{Note_on},
                             $NoteArray->[$i-1]{Note_off},$Layer,$Parent);
            &TS_segmentation($NoteArray->[$i]{Note_on},
                             $NoteArray->[$End_note]{Note_off},$Layer,$Parent);
            return;
         }
      }
   }

   sub Get_Child{
      my $Count=0;
      foreach(@$TSArray){
         if ($_->{parent}>-1){
            if ($TSArray->[$_->{parent}]{child1}==''){
               $TSArray->[$_->{parent}]{child1}=$Count;
            }
            else{
               $TSArray->[$_->{parent}]{child2}=$Count;              
            }
         }
         $Count++;
      }
   }


#XMLOut Time-span##########################################################

   sub XMLOut_TimeSpan{
      my $output=new IO::File(">$TSfilename");
      my $writer = new XML::Writer(OUTPUT => $output,DATA_MODE => 'true',DATA_INDENT=>2);
      my $link1=qq{xmlns:GTTM};
      my $link2=qq{xmlns:mr};
      my $link3=qq{xmlns:xlink};
      my $link4=qq{xmlns:xsi};
      my $link5=qq{xsi:SchemaLocation};
      my $link6=qq{xml:base};

      $writer->xmlDecl( 'UTF-8' );
      $writer->startTag( 'tstree',$link1=> "http://www.dacreation.com/ns/GTTM",
                                        $link2=> "http://www.dacreation.com/ns/MusicResonator",
                                        $link3=> "http://www.w3.org/1999/xlink",
                                        $link4=> "http://www.w3.org/2001/XMLSchema-instance",
                                        $link5=> 
               "http://www.dacreation.com/ns/GTTM http://www.dacreation.com/ns/GTTM/ts.xsd",
                                        $link6=> $BaseURL,);
      &WriteXML($writer,0);
      $writer->endTag('tstree');
      $writer->end();
   }

   sub WriteXML{
      my $writer=$_[0];
      my $P=$_[1];
      my $link1=qq{xlink:href};
      my $link2=qq{xlink:type};
      my $link3=qq{#xpointer(id('};
      my $link4=qq{'))};
      my $part=$NoteArray->[$TSArray->[$P]{head}]{Part_id};
      my $mesure=$NoteArray->[$TSArray->[$P]{head}]{Measure};
      my $NCount=$NoteArray->[$TSArray->[$P]{head}]{Note_Count};
      $link3=$link3."$part\-$mesure\-$NCount".$link4;
     $writer->startTag( 'ts' );
      $writer->startTag( 'head' );
      $writer->startTag( 'chord' );
   #   $writer->emptyTag(qq{mr:fragment}, $link1=>$link3,
   #                                     $link2=>'simple',);
       $writer->emptyTag(qq{note},id=>qq{$part\-$mesure\-$NCount});
 

      $writer->endTag( 'chord' );

      $writer->endTag( 'head' );
      if ($TSArray->[$P]{startnote} ne $TSArray->[$P]{endnote}){
         $writer->startTag( 'primary' );
     #    $writer->startTag( 'ts' );
            &WriteXML($writer,$TSArray->[$P]{primary});
     #    $writer->endTag( 'ts' );
        $writer->endTag( 'primary' );
         $writer->startTag( 'secondary' );
   #     $writer->startTag( 'ts' );
        &WriteXML($writer,$TSArray->[$P]{secondary});
   #      $writer->endTag( 'ts' );
        $writer->endTag( 'secondary' );
      }
      $writer->endTag( 'ts' );
   }

#Print Time-span###########################################################

   sub Print_TimeSpan{
      my @h_line;
      my @v_line;
      my @T_line;
      my $Count;
      my $Child1;
      my $Child2;
      $h_line[$TSArray->[0]{head}][$T_level]=1;
      $T_line[$TSArray->[0]{head}][$T_level]=0;

      for (my $i=$T_level;$i>0;$i--){
         $Count=0;
         foreach(@$NoteArray){
            if ($h_line[$Count][$i]==1){    
               if ($TSArray->[$T_line[$Count][$i]]{child1} ne ''){
                  $Child1=$TSArray->[$T_line[$Count][$i]]{child1};
                  $Child2=$TSArray->[$T_line[$Count][$i]]{child2};
                  $h_line[$TSArray->[$Child1]{head}][$i-1]=1;
                  $h_line[$TSArray->[$Child2]{head}][$i-1]=1;
                  $T_line[$TSArray->[$Child1]{head}][$i-1]=$Child1;
                  $T_line[$TSArray->[$Child2]{head}][$i-1]=$Child2;
                  if ($TSArray->[$Child1]{head} < $TSArray->[$Child2]{head}){
                     for (my $j=$TSArray->[$Child1]{head}; $j<$TSArray->[$Child2]{head}; $j++){
                        $v_line[$j][$i-1]=1;
                     }
                  }          
                  else{
                     for (my $j=$TSArray->[$Child2]{head}; $j<$TSArray->[$Child1]{head}; $j++){
                        $v_line[$j][$i-1]=1;
                     }
                  }
               }
               else{
                  $h_line[$Count][$i-1]=1;
                  $T_line[$Count][$i-1]=$T_line[$Count][$i];
               }
            }
            $Count++;
         }
      }

      $Count=0;
      my $TS;
      open (OUT,">TempT");  
      print OUT "       "; 

      foreach(@$NoteArray){

         $Count++;
         print OUT "\nNote$Count\t";         

         for (my $i=0;$i<=$T_level;$i++){
            if ($h_line[$Count-1][$i]==1){
               print OUT "------";  
            }           
            else{
               print OUT "        ";
            }
            if ($v_line[$Count-1][$i]==1 || ($Count>1 && $v_line[$Count-2][$i]==1)){
               print OUT "|";
            }
            else{
               print OUT " ";
            }
         }      
         print OUT "\n          \t";
         for (my $i=0;$i<=$T_level;$i++){
            if ($v_line[$Count-1][$i]==1){
               print OUT "        |";
            }
            else{ 
               print OUT "         ";
            }
         } 
      }
      print OUT "\n";
      close(OUT);

      (my $top,my $bottom)=$f2->yview();
      $f2->delete("1.0",'end');
      open (IN,"TempT");
      while (<IN>){
         $f2->insert("end",$_);
      }
      close(IN);
      $f2->yviewMoveto($top);
   }

   sub Get_T_level{
      my $T;
      my $Parent;
      $T_level=0;
      foreach(@$TSArray){
         $T=1;
         $Parent=$_->{parent};
         while($Parent ne -1){
            $Parent=$TSArray->[$Parent]{parent};
            $T++;
         }
         if ($T_level<$T){$T_level=$T;}
      }
   }

   sub Get_N2TS{
      my $Count=0;
      foreach(@$TSArray){
         if ($_->{startnote}==$_->{endnote}){
            $N2TS[$_->{startnote}]=$Count;
         }
         $Count++;
      }
   }

############################################################################



   sub GetPowerd{
      my $i=0;
      my $Non;
      my $Noff;
      $Powerd=1;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            $Powerd=$Powerd*210;
            $i=0;
         }
         else{
            last;
         }
      }
      $i=0;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/2;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*2;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/3;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*3;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/5;
            $i=0;
         }
      }
      $i=0;
      $Powerd=$Powerd*5;
      while(1){
         foreach(@$NoteArray){
            $Non= $_->{Note_on} *$Powerd;
            $Noff=$_->{Note_off}*$Powerd;
            if($Non=~/\.\d/){$i++;}
            if($Noff=~/\.\d/){$i++;} 
         }
         if ($i>0){
            last;
         }
         else{
            $Powerd=$Powerd/7;
            $i=0;
         }
      }
      $Powerd=$Powerd*7;
   }

   sub GetM2N{
      my $Count=0;
      foreach(@$NoteArray){
         $Count++;
         $M2N[$_->{Note_on}*$Powerd]=$Count;
      }
    }


   sub metric{
      my ($tree,$elem)=@_;
      my $dot=$elem->att('dot');
      my $at=$elem->att('at');
      for (my $i=1;$i<=$dot;$i++){
         $MetArray->[$at*$Powerd][$i]{dot}=1;
      }
      if ($Maxdot<$dot){$Maxdot=$dot;}
      $metrical++;
      $Old_level=0;
      $M_level=0;
   }

   sub note_3{
   }

   sub applied_M{
      my ($tree,$elem)=@_;
      my $level=$elem->att('level');
      my $rule=$elem->att('rule');
      if ($Old_level<$level){
         $M_level++;
         $Old_level=$level;
      }
      $rule="MPR$rule";
      $MetArray->[$metrical][$M_level]{$rule}=1;
   }



   sub group{
      my ($tree,$elem)=@_;
      $Now_layer=$elem->att('level');
      if ($Group_layer<$Now_layer){
         $Group_layer=$Now_layer;
      }
      if ($Group_Count[$Now_layer] eq ''){
         $Group_Count[$Now_layer]=0;
      }
      else{
         $Group_Count[$Now_layer]++;
      }
      if ($Group_Start[$Now_layer]->[$Group_Count[$Now_layer]] eq ''){
         $Group_Start[$Now_layer]->[$Group_Count[$Now_layer]]=0;
      }
      $Group_End[$Now_layer]->[$Group_Count[$Now_layer]]=$NoteCount; 
      $Group_Start[$Now_layer]->[$Group_Count[$Now_layer]+1]=$NoteCount+1; 
      if ($g_flg==0){
         for (my $i=0;$i<$Now_layer;$i++){
            if ($Group_Count[$i] eq ''){
               $Group_Count[$i]=0;
            }
            else{
               $Group_Count[$i]++;
            }
            if ($Group_Start[$i]->[$Group_Count[$i]] eq ''){
               $Group_Start[$i]->[$Group_Count[$i]]=0;
            }
            $Group_End[$i]->[$Group_Count[$i]]=$NoteCount; 
            $Group_Start[$i]->[$Group_Count[$i]+1]=$NoteCount+1; 
         }
      $g_flg=1;
      }
   }

   sub note_2{
      $g_flg=0;
      $NoteCount++;
   }

   sub applied_G{
      my ($tree,$elem)=@_;
      my $rule=$elem->att('rule');
      if ($rule==''){ $rule=$elem->text;}
      if    ($rule eq '2a' || $rule eq 'GPR2a'){
         $NoteArray->[$NoteCount+1]{GPR2a}=1;
      }
      elsif ($rule eq '2b' || $rule eq 'GPR2b'){
         $NoteArray->[$NoteCount+1]{GPR2b}=1;
      }
      elsif ($rule eq '3a' || $rule eq 'GPR3a'){
         $NoteArray->[$NoteCount+1]{GPR3a}=1;
      }
      elsif ($rule eq '3b' || $rule eq 'GPR3b'){
         $NoteArray->[$NoteCount+1]{GPR3b}=1;
      }
      elsif ($rule eq '3c' || $rule eq 'GPR3c'){
         $NoteArray->[$NoteCount+1]{GPR3c}=1;
      }
      elsif ($rule eq '3d' || $rule eq 'GPR3d'){
         $NoteArray->[$NoteCount+1]{GPR3d}=1;
      }
      elsif ($rule eq '4' || $rule eq 'GPR4'){
         $NoteArray->[$NoteCount+1]{GPR4}=1;
      }
      elsif ($rule eq '5' || $rule eq 'GPR5'){
         $NoteArray->[$NoteCount+1]{GPR5}=1;
      }
      elsif ($rule eq '6' || $rule eq 'GPR6'){
         $NoteArray->[$NoteCount+1]{GPR6}=1;
      }
   }

   sub note_1{
       $main::NC++;
       my ($tree,$elem)=@_;
       if($main::tie ne 'stop'){
          if($main::rest ne '1'){
             my $note={
                 "Divisons" => $main::divisions,
                 "Fifths"   => $main::fifths,
                 "Beats"    => $main::beats,
                 "Beattype" => $main::beattype,
                 "Step"     => $main::step,
                 "Alter"    => $main::alter,
                 "Octave"   => $main::octave,
                 "Rest"     => $main::rest,
                 "Duration" => $main::duration,
                 "Voice"    => $main::voice,
                 "Type"     => $main::type,
                 "Stem"     => $main::stem,
                 "Tie"      => $main::tie,
                 "Chordes"  => $main::chordes,
                 "Note_on"  => $main::Time/$main::divisions,
                 "Note_off" => ($main::Time+$main::duration)/$main::divisions,
                 "Note_num" => 12*$main::octave+$main::alter+&ValStep($main::step),
                 "Note_Count"   => $main::NC,
                   };
             push (@$NoteArray, $note);
         }
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
      }
      else{
         $NoteArray->[@$NoteArray-1]{Note_off}=($main::Time+$main::duration)/$main::divisions;
         $NoteArray->[@$NoteArray-1]{Duration}=$NoteArray->[@$NoteArray-1]{Duration}+$main::duration;
         $NoteArray->[@$NoteArray-1]{Type}="$NoteArray->[@$NoteArray-1]{Type}$main::type";
         $main::rest=0;
         $main::Time=$main::Time+$main::duration;
         $main::tie='';
      }
   }


   sub measure{
         my ($tree,$elem)=@_;
         my $measure=$elem->att('number');
         foreach (@$NoteArray){
            if ($_->{Measure} eq ''){$_->{Measure}=$measure;}
         }
      $main::NC=0;
   }

   sub part{
      my ($tree,$elem)=@_;
      my $id=$elem->att('id');
      foreach (@$NoteArray){
         if ($_->{Part_id} eq ''){$_->{Part_id}=$id;}
      }
      $main::divisions='';
      $main::fifths='';
      $main::beats='';
      $main::beattype='';
      $main::Time=0;
   }

   sub divisions{
      my($tree,$elem)=@_;
      $main::divisions=$elem->text;
   }

   sub fifths{
      my($tree,$elem)=@_;
      $main::fifths=$elem->text;
   }

   sub beats{
      my($tree,$elem)=@_;
      $main::beats=$elem->text;
   }

   sub beattype{
      my($tree,$elem)=@_;
      $main::beattype=$elem->text;
   }

   sub step{
      my($tree,$elem)=@_;
      $main::step=$elem->text;
   }

   sub alter{
      my($tree,$elem)=@_;
      $main::alter=$elem->text;
   }

   sub octave{
      my($tree,$elem)=@_;
      $main::octave=$elem->text;
   }

   sub rest{
      my($tree,$elem)=@_;
      $main::rest=1;
   }

   sub duration{
      my($tree,$elem)=@_;
      $main::duration=$elem->text;
   }

   sub voice{
      my($tree,$elem)=@_;
      $main::voice=$elem->text;
   }

   sub type{
      my($tree,$elem)=@_; 
      $main::type=$elem->text;
   }

   sub stem{
      my($tree,$elem)=@_;
      $main::stem=$elem->text;
   }

   sub tie{
      my($tree,$elem)=@_;
      if ($main::tie ne 'stop'){
         $main::tie=$elem->att('type');
      }
   }

   sub chords{
      my($tree,$elem)=@_;
      $main::chords=1;
   }

   sub ValStep{
      if ($_[0] eq 'A'){return 9;}
      if ($_[0] eq 'B'){return 11;}
      if ($_[0] eq 'C'){return 0;}
      if ($_[0] eq 'D'){return 2;}
      if ($_[0] eq 'E'){return 4;}
      if ($_[0] eq 'F'){return 5;}
      if ($_[0] eq 'G'){return 7;}
   }

#Copyright (c) 2003-2005 Masatoshi Hamanaka All rights reserved.